/*
 * $Id: Read_unit.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/include/Read_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit::Read_unit"
  Read_unit::Read_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Read_unit,FUNCTION,"Begin");

    log_printf(INFO,Read_unit,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {	
	log_printf(INFO,Read_unit,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (_usage & USE_VHDL)
      {
	// generate the vhdl
	log_printf(INFO,Read_unit,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (_usage & USE_SYSTEMC)
      {
	log_printf(INFO,Read_unit,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_printf(FUNC,Read_unit,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Read_unit::~Read_unit"
  Read_unit::~Read_unit (void)
  {
    log_printf(FUNC,Read_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {
	log_printf(INFO,Read_unit,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Read_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Read_unit,FUNCTION,"End");
  };

}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
