#ifdef SYSTEMC
/*
 * $Id: Execution_unit_to_Write_unit_transition.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Execution_unit_to_Write_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace execution_unit_to_write_unit {


#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::transition"
  void Execution_unit_to_Write_unit::transition (void)
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

    if (PORT_READ(in_NRESET) == 0)
      {
	// Flush routing_table
	for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_thread; j++)
	      _destination [i][j].clear();
	
	// Fill routing table
	for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	    // Test if link between src and dest
	    if (_param->_table_routing [i][j])
	      // Test the thread accepted by the execute_unit
	      for (uint32_t k=0; k<_param->_nb_thread; k++)
		if (_param->_table_thread[j][k])
		  // push_back == minor have a better priority
		  _destination [i][k].push_back(j);
      }
    else
      {
	if (_param->_priority == PRIORITY_ROUND_ROBIN)
	  for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	    for (uint32_t j=0; j<_param->_nb_thread; j++)
	      if (_destination [i][j].size() > 1)
		{
		  // Head queue became the Tail queue
		  _destination [i][j].push_back(_destination [i][j].front());
		  _destination [i][j].pop_front();
		}
      }


#if (DEBUG >= DEBUG_TRACE)
    // Print
    log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"Routing Table");
    for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
      for (uint32_t j=0; j<_param->_nb_thread; j++)
	for (std::list<uint32_t>::iterator k=_destination[i][j].begin();
	     k != _destination[i][j].end();
	     k++)
	  log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"  * Execute_unit [%d], send at the write_unit [%d], the operation of thread [%d].",i,*k,j);
#endif

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };

}; // end namespace execution_unit_to_write_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
