/*
 * $Id: Parameters.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace execution_unit_to_write_unit {


#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::Parameters"
  Parameters::Parameters (uint32_t    nb_execute_unit              ,
			  uint32_t    nb_write_unit                ,
			  uint32_t    nb_context                   ,
			  uint32_t    nb_front_end                 ,
			  uint32_t    nb_ooo_engine                ,
			  uint32_t    nb_packet                    ,
			  uint32_t    size_general_data            ,
			  uint32_t    size_special_data            ,
			  uint32_t    nb_general_register          ,
			  uint32_t    nb_special_register          ,
			  Tpriority_t priority                     ,
			  bool     ** table_routing                ,
			  bool     ** table_thread                 ):
    _nb_execute_unit         (nb_execute_unit    ),
    _nb_write_unit           (nb_write_unit      ),
    _nb_context              (nb_context         ),
    _nb_front_end            (nb_front_end       ),
    _nb_ooo_engine           (nb_ooo_engine      ),
    _nb_packet               (nb_packet          ),
    _size_general_data       (size_general_data  ),
    _size_special_data       (size_special_data  ),
    _nb_general_register     (nb_general_register),
    _nb_special_register     (nb_special_register),
    _priority                (priority           ),
    
    _size_context_id         (log2(nb_context         )),
    _size_front_end_id       (log2(nb_front_end       )),
    _size_ooo_engine_id      (log2(nb_ooo_engine      )),
    _size_packet_id          (log2(nb_packet          )),
    _size_general_register   (log2(nb_general_register)),
    _size_special_register   (log2(nb_special_register)),
    
    _have_port_context_id    (_size_context_id    > 0),
    _have_port_front_end_id  (_size_front_end_id  > 0),
    _have_port_ooo_engine_id (_size_ooo_engine_id > 0),
    _have_port_packet_id     (_size_packet_id     > 0),

    _nb_thread               (get_nb_thread (nb_context, nb_front_end, nb_ooo_engine))
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

    _table_routing = table_routing ;
    _table_thread  = table_thread  ;

    test();
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::Parameters (copy)"
  Parameters::Parameters (Parameters & param):
    _nb_execute_unit         (param._nb_execute_unit        ),
    _nb_write_unit           (param._nb_write_unit          ),
    _nb_context              (param._nb_context             ),
    _nb_front_end            (param._nb_front_end           ),
    _nb_ooo_engine           (param._nb_ooo_engine          ),
    _nb_packet               (param._nb_packet              ),
    _size_general_data       (param._size_general_data      ),
    _size_special_data       (param._size_special_data      ),
    _nb_general_register     (param._nb_general_register    ),
    _nb_special_register     (param._nb_special_register    ),
    _priority                (param._priority               ),

    _size_context_id         (param._size_context_id        ),
    _size_front_end_id       (param._size_front_end_id      ),
    _size_ooo_engine_id      (param._size_ooo_engine_id     ),
    _size_packet_id          (param._size_packet_id         ),
    _size_general_register   (param._size_general_register  ),
    _size_special_register   (param._size_special_register  ),

    _have_port_context_id    (param._have_port_context_id   ),
    _have_port_front_end_id  (param._have_port_front_end_id ),
    _have_port_ooo_engine_id (param._have_port_ooo_engine_id),
    _have_port_packet_id     (param._have_port_packet_id    ),

    _nb_thread               (param._nb_thread              )
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

    _table_routing = param._table_routing ;
    _table_thread  = param._table_thread  ;

    test();
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };

}; // end namespace execution_unit_to_write_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
