#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id: Register_unit_Glue_genMealy_gpr_read_status.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/Register_unit_Glue/include/Register_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {
namespace register_unit_glue {


#undef  FUNCTION
#define FUNCTION "Register_unit_Glue::genMealy_gpr_read_status"
  void Register_unit_Glue::genMealy_gpr_read_status (void)
  {
    log_printf(FUNC,Register_unit_Glue,FUNCTION,"Begin");

    for (uint32_t j=0; j<_param->_nb_gpr_read; j++)
      {
	Tcontext_t ooo_engine_id    = (_param->_have_port_ooo_engine_id == true)?PORT_READ(in_GPR_READ_OOO_ENGINE_ID[j]):0;
	Tcontrol_t val              = PORT_READ(in_GPR_READ_VAL [j]);
	Tcontrol_t registerfile_ack = PORT_READ(in_GPR_READ_REGISTERFILE_ACK [ooo_engine_id][j]);
    
	Tcontrol_t status_val       = val and registerfile_ack;

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    Tcontrol_t id = (i == ooo_engine_id)?1:0;
	    PORT_WRITE(out_GPR_READ_STATUS_VAL       [i][j], (id and status_val));
	  }
      }

    log_printf(FUNC,Register_unit_Glue,FUNCTION,"End");
  };

}; // end namespace register_unit_glue
}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
