/*
 * $Id: Context_State_deallocation.cpp 83 2008-05-09 18:00:21Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Context_State.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


#undef  FUNCTION
#define FUNCTION "Context_State::deallocation"
  void Context_State::deallocation (void)
  {
    log_begin(Context_State,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL( in_DECOD_EVENT_VAL                    ,_param->_nb_decod_unit,1);
        DELETE1_SIGNAL(out_DECOD_EVENT_ACK                    ,_param->_nb_decod_unit,1);
        DELETE1_SIGNAL( in_DECOD_EVENT_CONTEXT_ID             ,_param->_nb_decod_unit,_param->_size_context_id);
        DELETE1_SIGNAL( in_DECOD_EVENT_DEPTH                  ,_param->_nb_decod_unit,_param->_size_max_depth);
        DELETE1_SIGNAL( in_DECOD_EVENT_TYPE                   ,_param->_nb_decod_unit,_param->_size_event_type);
        DELETE1_SIGNAL( in_DECOD_EVENT_IS_DELAY_SLOT          ,_param->_nb_decod_unit,1);
        DELETE1_SIGNAL( in_DECOD_EVENT_ADDRESS                ,_param->_nb_decod_unit,_param->_size_address);
        DELETE1_SIGNAL( in_DECOD_EVENT_ADDRESS_EPCR           ,_param->_nb_decod_unit,_param->_size_address);
        
	DELETE1_SIGNAL( in_COMMIT_EVENT_VAL                   ,_param->_nb_ooo_engine,1);
        DELETE1_SIGNAL(out_COMMIT_EVENT_ACK                   ,_param->_nb_ooo_engine,1);
        DELETE1_SIGNAL( in_COMMIT_EVENT_CONTEXT_ID            ,_param->_nb_ooo_engine,_param->_size_context_id);
        DELETE1_SIGNAL( in_COMMIT_EVENT_DEPTH                 ,_param->_nb_ooo_engine,_param->_size_max_depth);
        DELETE1_SIGNAL( in_COMMIT_EVENT_TYPE                  ,_param->_nb_ooo_engine,_param->_size_event_type);
        DELETE1_SIGNAL( in_COMMIT_EVENT_IS_DELAY_SLOT         ,_param->_nb_ooo_engine,1);
        DELETE1_SIGNAL( in_COMMIT_EVENT_ADDRESS               ,_param->_nb_ooo_engine,_param->_size_address);
        DELETE1_SIGNAL( in_COMMIT_EVENT_ADDRESS_EPCR          ,_param->_nb_ooo_engine,_param->_size_address);
	DELETE1_SIGNAL( in_COMMIT_EVENT_ADDRESS_EEAR_VAL      ,_param->_nb_ooo_engine,_param->_size_address);
	DELETE1_SIGNAL( in_COMMIT_EVENT_ADDRESS_EEAR          ,_param->_nb_ooo_engine,1);

	DELETE1_SIGNAL( in_BRANCH_COMPLETE_VAL                ,_param->_nb_inst_branch_complete,1);
	DELETE1_SIGNAL(out_BRANCH_COMPLETE_ACK                ,_param->_nb_inst_branch_complete,1);
	DELETE1_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID         ,_param->_nb_inst_branch_complete,_param->_size_context_id);
	DELETE1_SIGNAL( in_BRANCH_COMPLETE_DEPTH              ,_param->_nb_inst_branch_complete,_param->_size_max_depth);
	DELETE1_SIGNAL( in_BRANCH_COMPLETE_MISS_PREDICTION    ,_param->_nb_inst_branch_complete,1);
	DELETE1_SIGNAL( in_BRANCH_COMPLETE_TAKE               ,_param->_nb_inst_branch_complete,1);
	DELETE1_SIGNAL( in_BRANCH_COMPLETE_ADDRESS_SRC        ,_param->_nb_inst_branch_complete,_param->_size_address);
	DELETE1_SIGNAL( in_BRANCH_COMPLETE_ADDRESS_DEST       ,_param->_nb_inst_branch_complete,_param->_size_address);
        
	DELETE1_SIGNAL( in_NB_INST_DECOD_ALL                  ,_param->_nb_decod_unit,_param->_size_inst_decod  [alloc_signal_it1]);
//      DELETE1_SIGNAL( in_NB_INST_COMMIT_ALL                 ,_param->_nb_decod_unit,_param->_size_inst_commit [alloc_signal_it1]);
//      DELETE1_SIGNAL( in_NB_INST_COMMIT_MEM                 ,_param->_nb_decod_unit,_param->_size_inst_commit [alloc_signal_it1]);
//      DELETE1_SIGNAL( in_NB_INST_DECOD_ALL                  ,_param->_nb_ooo_engine,_param->_size_inst_decod  [alloc_signal_it1]);
        DELETE1_SIGNAL( in_NB_INST_COMMIT_ALL                 ,_param->_nb_ooo_engine,_param->_size_inst_commit [alloc_signal_it1]);
        DELETE1_SIGNAL( in_NB_INST_COMMIT_MEM                 ,_param->_nb_ooo_engine,_param->_size_inst_commit [alloc_signal_it1]);
        
	DELETE1_SIGNAL(out_EVENT_VAL                          ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_EVENT_ACK                          ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_EVENT_ADDRESS                      ,_param->_nb_context,_param->_size_address);
        DELETE1_SIGNAL(out_EVENT_ADDRESS_NEXT                 ,_param->_nb_context,_param->_size_address);
        DELETE1_SIGNAL(out_EVENT_ADDRESS_NEXT_VAL             ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_EVENT_IS_DS_TAKE                   ,_param->_nb_context,1);
        
	DELETE1_SIGNAL(out_SPR_VAL                            ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_SPR_ACK                            ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_SPR_EPCR                           ,_param->_nb_context,_param->_size_address);
        DELETE1_SIGNAL(out_SPR_EEAR                           ,_param->_nb_context,_param->_size_address);
        DELETE1_SIGNAL(out_SPR_EEAR_WEN                       ,_param->_nb_context,1);
	DELETE1_SIGNAL(out_SPR_SR_DSX                         ,_param->_nb_context,1);
	DELETE1_SIGNAL(out_SPR_SR_TO_ESR                      ,_param->_nb_context,1);
        
	DELETE1_SIGNAL(out_CONTEXT_DECOD_ENABLE               ,_param->_nb_context,1);

	DELETE1_SIGNAL( in_DEPTH_TAIL                         ,_param->_nb_context,_param->_size_depth [alloc_signal_it1]);
      }

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete [] reg_STATE                 ;
    delete [] reg_EVENT_ADDRESS         ;
    delete [] reg_EVENT_ADDRESS_EPCR    ; 
    delete [] reg_EVENT_ADDRESS_EPCR_VAL;
    delete [] reg_EVENT_ADDRESS_EEAR    ; 
    delete [] reg_EVENT_ADDRESS_EEAR_VAL;
    delete [] reg_EVENT_IS_DELAY_SLOT   ;
    delete [] reg_EVENT_IS_DS_TAKE      ;
    delete [] reg_EVENT_DEPTH           ;

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    delete [] internal_DECOD_EVENT_ACK  ;
    delete [] internal_COMMIT_EVENT_ACK ;
    delete [] internal_EVENT_VAL        ;
    delete [] internal_SPR_VAL          ;
    
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_end(Context_State,FUNCTION);
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
