/*
 * $Id: test.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (2048*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/SelfTest/include/test.h"
#include <list>
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

  class entry_t
  {
//   public : Tcontrol_t          _val                        ;
  public : Tinstruction_t      _instruction                ;
//   public : Tcontext_t          _context_id                 ;
  public : Tgeneral_address_t  _address_previous           ;
  public : Tgeneral_address_t  _address                    ;
  public : Tgeneral_address_t  _address_next               ;
  public : Tbranch_state_t     _branch_state               ;
  public : Tprediction_ptr_t   _branch_update_prediction_id;
  public : Tbranch_condition_t _branch_condition           ;
//   public : Tcontrol_t          _branch_stack_write         ;
  public : Tcontrol_t          _branch_direction           ;
  public : Tgeneral_address_t  _branch_address_dest        ;
  public : Tdepth_t            _depth                      ;
  public : Ttype_t             _type                       ;
  public : Toperation_t        _operation                  ;
  public : Tcontrol_t          _is_delay_slot              ;
  public : Tcontrol_t          _has_immediat               ;
  public : Tgeneral_data_t     _immediat                   ;
  public : Tcontrol_t          _read_ra                    ;
  public : Tgeneral_address_t  _num_reg_ra                 ;
  public : Tcontrol_t          _read_rb                    ;
  public : Tgeneral_address_t  _num_reg_rb                 ;
  public : Tcontrol_t          _read_rc                    ;
  public : Tspecial_address_t  _num_reg_rc                 ;
  public : Tcontrol_t          _write_rd                   ;
  public : Tgeneral_address_t  _num_reg_rd                 ;
  public : Tcontrol_t          _write_re                   ;
  public : Tspecial_address_t  _num_reg_re                 ;
  public : Texception_t        _exception_use              ;
  public : Tevent_type_t       _context_event_type         ;

  public : entry_t (
// 		    Tcontrol_t          val                        ,
		    Tinstruction_t      instruction                ,
// 		    Tcontext_t          context_id                 ,
		    Tgeneral_address_t  address_previous           ,
		    Tgeneral_address_t  address                    ,
		    Tgeneral_address_t  address_next               ,
		    Tbranch_state_t     branch_state               ,
		    Tprediction_ptr_t   branch_update_prediction_id,
		    Tbranch_condition_t branch_condition           ,
// 		    Tcontrol_t          branch_stack_write         ,
		    Tcontrol_t          branch_direction           ,
		    Tgeneral_address_t  branch_address_dest        ,
		    Tdepth_t            depth                      ,
		    Ttype_t             type                       ,
		    Toperation_t        operation                  ,
		    Tcontrol_t          is_delay_slot              ,
		    Tcontrol_t          has_immediat               ,
		    Tgeneral_data_t     immediat                   ,
		    Tcontrol_t          read_ra                    ,
		    Tgeneral_address_t  num_reg_ra                 ,
		    Tcontrol_t          read_rb                    ,
		    Tgeneral_address_t  num_reg_rb                 ,
		    Tcontrol_t          read_rc                    ,
		    Tspecial_address_t  num_reg_rc                 ,
		    Tcontrol_t          write_rd                   ,
		    Tgeneral_address_t  num_reg_rd                 ,
		    Tcontrol_t          write_re                   ,
		    Tspecial_address_t  num_reg_re                 ,
		    Texception_t        exception_use              ,
		    Tevent_type_t       context_event_type         )
    {
//       _val                         = val                        ;
      _instruction                 = instruction                ;
//       _context_id                  = context_id                 ;
      _address_previous            = address_previous           ;
      _address                     = address                    ;
      _address_next                = address_next               ;
      _branch_state                = branch_state               ;
      _branch_update_prediction_id = branch_update_prediction_id;
      _branch_condition            = branch_condition           ;
//       _branch_stack_write          = branch_stack_write         ;
      _branch_direction            = branch_direction           ;
      _branch_address_dest         = branch_address_dest        ;
      _depth                       = depth                      ;
      _type                        = type                       ;
      _operation                   = operation                  ;
      _is_delay_slot               = is_delay_slot              ;
      _has_immediat                = has_immediat               ;
      _immediat                    = immediat                   ;
      _read_ra                     = read_ra                    ;
      _num_reg_ra                  = num_reg_ra                 ;
      _read_rb                     = read_rb                    ;
      _num_reg_rb                  = num_reg_rb                 ;
      _read_rc                     = read_rc                    ;
      _num_reg_rc                  = num_reg_rc                 ;
      _write_rd                    = write_rd                   ;
      _num_reg_rd                  = num_reg_rd                 ;
      _write_re                    = write_re                   ;
      _num_reg_re                  = num_reg_re                 ;
      _exception_use               = exception_use              ;
      _context_event_type          = context_event_type         ;
    }
  };


void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Decod * _Decod = new Decod 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     USE_ALL);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC2_SC_SIGNAL( in_IFETCH_VAL                         ," in_IFETCH_VAL                         ",Tcontrol_t         ,_param->_nb_context,_param->_nb_inst_fetch[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL(out_IFETCH_ACK                         ,"out_IFETCH_ACK                         ",Tcontrol_t         ,_param->_nb_context,_param->_nb_inst_fetch[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_IFETCH_INSTRUCTION                 ," in_IFETCH_INSTRUCTION                 ",Tinstruction_t     ,_param->_nb_context,_param->_nb_inst_fetch[alloc_signal_it1]);
  ALLOC1_SC_SIGNAL( in_IFETCH_CONTEXT_ID                  ," in_IFETCH_CONTEXT_ID                  ",Tcontext_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_IFETCH_ADDRESS                     ," in_IFETCH_ADDRESS                     ",Tgeneral_address_t ,_param->_nb_context);
//   ALLOC1_SC_SIGNAL( in_IFETCH_ADDRESS_NEXT                ," in_IFETCH_ADDRESS_NEXT                ",Tgeneral_address_t ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_IFETCH_INST_IFETCH_PTR             ," in_IFETCH_INST_IFETCH_PTR             ",Tinst_ifetch_ptr_t ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_IFETCH_BRANCH_STATE                ," in_IFETCH_BRANCH_STATE                ",Tbranch_state_t    ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_IFETCH_BRANCH_UPDATE_PREDICTION_ID ," in_IFETCH_BRANCH_UPDATE_PREDICTION_ID ",Tprediction_ptr_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DECOD_VAL                          ,"out_DECOD_VAL                          ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_ACK                          ," in_DECOD_ACK                          ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_CONTEXT_ID                   ,"out_DECOD_CONTEXT_ID                   ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_DEPTH                        ,"out_DECOD_DEPTH                        ",Tdepth_t           ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_TYPE                         ,"out_DECOD_TYPE                         ",Ttype_t            ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OPERATION                    ,"out_DECOD_OPERATION                    ",Toperation_t       ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_IS_DELAY_SLOT                ,"out_DECOD_IS_DELAY_SLOT                ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_ADDRESS                      ,"out_DECOD_ADDRESS                      ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_HAS_IMMEDIAT                 ,"out_DECOD_HAS_IMMEDIAT                 ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_IMMEDIAT                     ,"out_DECOD_IMMEDIAT                     ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RA                      ,"out_DECOD_READ_RA                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RA                   ,"out_DECOD_NUM_REG_RA                   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RB                      ,"out_DECOD_READ_RB                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RB                   ,"out_DECOD_NUM_REG_RB                   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RC                      ,"out_DECOD_READ_RC                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RC                   ,"out_DECOD_NUM_REG_RC                   ",Tspecial_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_WRITE_RD                     ,"out_DECOD_WRITE_RD                     ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RD                   ,"out_DECOD_NUM_REG_RD                   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_WRITE_RE                     ,"out_DECOD_WRITE_RE                     ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RE                   ,"out_DECOD_NUM_REG_RE                   ",Tspecial_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_EXCEPTION_USE                ,"out_DECOD_EXCEPTION_USE                ",Texception_t       ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_VAL                        ,"out_PREDICT_VAL                        ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_PREDICT_ACK                        ," in_PREDICT_ACK                        ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_CONTEXT_ID                 ,"out_PREDICT_CONTEXT_ID                 ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_MATCH_INST_IFETCH_PTR      ,"out_PREDICT_MATCH_INST_IFETCH_PTR      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_STATE               ,"out_PREDICT_BRANCH_STATE               ",Tbranch_state_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,"out_PREDICT_BRANCH_UPDATE_PREDICTION_ID",Tprediction_ptr_t  ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_CONDITION           ,"out_PREDICT_BRANCH_CONDITION           ",Tbranch_condition_t,_param->_nb_inst_decod);
//   ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_STACK_WRITE         ,"out_PREDICT_BRANCH_STACK_WRITE         ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_DIRECTION           ,"out_PREDICT_BRANCH_DIRECTION           ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_ADDRESS_SRC                ,"out_PREDICT_ADDRESS_SRC                ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_ADDRESS_DEST               ,"out_PREDICT_ADDRESS_DEST               ",Tgeneral_data_t    ,_param->_nb_inst_decod);
//   ALLOC1_SC_SIGNAL( in_PREDICT_CAN_CONTINUE               ," in_PREDICT_CAN_CONTINUE               ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_CONTEXT_DECOD_ENABLE               ," in_CONTEXT_DECOD_ENABLE               ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_CONTEXT_DEPTH                      ," in_CONTEXT_DEPTH                      ",Tdepth_t           ,_param->_nb_context);
  ALLOC_SC_SIGNAL (out_CONTEXT_EVENT_VAL                  ,"out_CONTEXT_EVENT_VAL                  ",Tcontrol_t         );
  ALLOC_SC_SIGNAL ( in_CONTEXT_EVENT_ACK                  ," in_CONTEXT_EVENT_ACK                  ",Tcontrol_t         );
  ALLOC_SC_SIGNAL (out_CONTEXT_EVENT_CONTEXT_ID           ,"out_CONTEXT_EVENT_CONTEXT_ID           ",Tcontext_t         );
  ALLOC_SC_SIGNAL (out_CONTEXT_EVENT_TYPE                 ,"out_CONTEXT_EVENT_TYPE                 ",Tevent_type_t      );
  ALLOC_SC_SIGNAL (out_CONTEXT_EVENT_IS_DELAY_SLOT        ,"out_CONTEXT_EVENT_IS_DELAY_SLOT        ",Tcontrol_t         );
  ALLOC_SC_SIGNAL (out_CONTEXT_EVENT_ADDRESS              ,"out_CONTEXT_EVENT_ADDRESS              ",Tgeneral_data_t    );
  ALLOC_SC_SIGNAL (out_CONTEXT_EVENT_ADDRESS_EPCR         ,"out_CONTEXT_EVENT_ADDRESS_EPCR         ",Tgeneral_data_t    );
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Decod.\n"),name.c_str());

  (*(_Decod->in_CLOCK))        (*(in_CLOCK));
  (*(_Decod->in_NRESET))       (*(in_NRESET));

  INSTANCE2_SC_SIGNAL(_Decod, in_IFETCH_VAL                         ,_param->_nb_context,_param->_nb_inst_fetch[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Decod,out_IFETCH_ACK                         ,_param->_nb_context,_param->_nb_inst_fetch[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Decod, in_IFETCH_INSTRUCTION                 ,_param->_nb_context,_param->_nb_inst_fetch[alloc_signal_it1]);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Decod, in_IFETCH_CONTEXT_ID                  ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Decod, in_IFETCH_ADDRESS                     ,_param->_nb_context);
//   INSTANCE1_SC_SIGNAL(_Decod, in_IFETCH_ADDRESS_NEXT                ,_param->_nb_context);
  if (_param->_have_port_inst_ifetch_ptr)
  INSTANCE1_SC_SIGNAL(_Decod, in_IFETCH_INST_IFETCH_PTR             ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Decod, in_IFETCH_BRANCH_STATE                ,_param->_nb_context);
  if (_param->_have_port_branch_update_prediction_id)
  INSTANCE1_SC_SIGNAL(_Decod, in_IFETCH_BRANCH_UPDATE_PREDICTION_ID ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_VAL                          ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod, in_DECOD_ACK                          ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_CONTEXT_ID                   ,_param->_nb_inst_decod);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_DEPTH                        ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_TYPE                         ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_OPERATION                    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_IS_DELAY_SLOT                ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_ADDRESS                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_HAS_IMMEDIAT                 ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_IMMEDIAT                     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_READ_RA                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_NUM_REG_RA                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_READ_RB                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_NUM_REG_RB                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_READ_RC                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_NUM_REG_RC                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_WRITE_RD                     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_NUM_REG_RD                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_WRITE_RE                     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_NUM_REG_RE                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_DECOD_EXCEPTION_USE                ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_PREDICT_VAL                        ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod, in_PREDICT_ACK                        ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Decod,out_PREDICT_CONTEXT_ID                 ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_PREDICT_MATCH_INST_IFETCH_PTR      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_PREDICT_BRANCH_STATE               ,_param->_nb_inst_decod);
  if (_param->_have_port_branch_update_prediction_id)
  INSTANCE1_SC_SIGNAL(_Decod,out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_PREDICT_BRANCH_CONDITION           ,_param->_nb_inst_decod);
//   INSTANCE1_SC_SIGNAL(_Decod,out_PREDICT_BRANCH_STACK_WRITE         ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_PREDICT_BRANCH_DIRECTION           ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_PREDICT_ADDRESS_SRC                ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod,out_PREDICT_ADDRESS_DEST               ,_param->_nb_inst_decod);
//   INSTANCE1_SC_SIGNAL(_Decod, in_PREDICT_CAN_CONTINUE               ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod, in_CONTEXT_DECOD_ENABLE               ,_param->_nb_context);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Decod, in_CONTEXT_DEPTH                      ,_param->_nb_context);
  INSTANCE_SC_SIGNAL (_Decod,out_CONTEXT_EVENT_VAL                  );
  INSTANCE_SC_SIGNAL (_Decod, in_CONTEXT_EVENT_ACK                  );
  if (_param->_have_port_context_id)
  INSTANCE_SC_SIGNAL (_Decod,out_CONTEXT_EVENT_CONTEXT_ID           );
  INSTANCE_SC_SIGNAL (_Decod,out_CONTEXT_EVENT_TYPE                 );
  INSTANCE_SC_SIGNAL (_Decod,out_CONTEXT_EVENT_IS_DELAY_SLOT        );
  INSTANCE_SC_SIGNAL (_Decod,out_CONTEXT_EVENT_ADDRESS              );
  INSTANCE_SC_SIGNAL (_Decod,out_CONTEXT_EVENT_ADDRESS_EPCR         );

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  const  int32_t percent_transaction_ifetch  = 75;
  const  int32_t percent_transaction_decod   = 75;
  const  int32_t percent_transaction_predict = 75;
  const  int32_t percent_transaction_event   = 75;

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      list<entry_t> request [_param->_nb_context];

      uint32_t w;
      uint32_t x = 0xfc;
      uint32_t y = 0x100;
      uint32_t z = 0x104;

      uint32_t delay_slot_previous [_param->_nb_context];
      uint32_t delay_slot_current  [_param->_nb_context];
      uint32_t delay_slot_next     [_param->_nb_context];

#define SEQ    do {x=y; y=z; z+=4;} while(0);
#define JMP(j) do {x=y; y=z; z =j;} while(0);

      // ===== l.add	r15, r4 , r8
      request [0].push_back (entry_t(
      //instruction,address_previous,address,address_next
      0xe1e44000,x,y,z,
      //branch_state,branch_update_prediction_id,branch_condition,branch_stack_write,branch_direction, branch_address_dest
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0,0x0,
      //depth,type,operation,is_delay_slot
      0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
      //has_immediat,immediat,read_ra,reg_ra,read_rb,reg_rb,read_rc,reg_rc,write_rd,reg_rd,write_re,reg_re
      0,0x00000000,1, 4,1, 8,0,0                 ,1,15,1,SPR_LOGIC_SR_CY_OV,
      //exception_use,context_event_type
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.addc	r15, r4 , r31
      request [0].push_back (entry_t(
      0xe1e4f801,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0,0x0, 
      0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
      0,0x00000000,1, 4,1,31,1,SPR_LOGIC_SR_CY_OV,1,15,1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.addi	r7 , r12, -1
      request [0].push_back (entry_t(
      0x9cecffff,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
      1,0xffffffff,1,12,0, 0,0,0                 ,1,7 ,1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.addi	r8 , r17, 0
      request [0].push_back (entry_t(
      0x9d110000,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
      1,0x00000000,1,17,0, 0,0,0                 ,1,8 ,1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.addi	r21, r7 , 1981
      request [0].push_back (entry_t(
      0x9ea707bd,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
      1,0x000007bd,1, 7,0, 0,0,0                 ,1,21,1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.addic	r7 , r12, -1
      request [0].push_back (entry_t(
      0xa0ecffff,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
      1,0xffffffff,1,12,0, 0,1,SPR_LOGIC_SR_CY_OV,1,7 ,1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.addic	r8 , r17, 0
      request [0].push_back (entry_t(
      0xa1110000,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
      1,0x00000000,1,17,0, 0,1,SPR_LOGIC_SR_CY_OV,1,8 ,1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.addic	r21, r7 , 1981
      request [0].push_back (entry_t(
      0xa2a707bd,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
      1,0x000007bd,1, 7,0, 0,1,SPR_LOGIC_SR_CY_OV,1,21,1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.and	r24, r0 , r14
      request [0].push_back (entry_t(
      0xe3007003,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_ALU,OPERATION_ALU_L_AND,false, 
      0,0x0       ,1, 0,1,14,0,0                 ,1,24,0,0                 ,
      EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.andi	r24, r4 , 1981
      request [0].push_back (entry_t(
      0xa70407bd,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_ALU,OPERATION_ALU_L_AND,false, 
      1,0x000007bd,1, 4,0,0 ,0,0                 ,1,24,0,0                 ,
      EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.bf 11
      w = y+(11<<2);
      request [0].push_back (entry_t(
      0x1000000b,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_FLAG_SET,0, w,
      0,TYPE_BRANCH,OPERATION_BRANCH_L_TEST_F,false, 
      1,w,0, 0,0,0 ,1,SPR_LOGIC_SR_F    ,0,0 ,0,0                 ,
      EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
      JMP(w);

      // ===== l.cmov	r30, r10, r20
      request [0].push_back (entry_t(
      0xe3caa00e,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_MOVE,OPERATION_MOVE_L_CMOV,true,
      0,0x0,1,10,1,20,1,SPR_LOGIC_SR_F    ,1,30,0,0                 ,
      EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.div r30,r10,r20
      request [0].push_back (entry_t(
      0xe3caa309,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_MUL_DIV,OPERATION_MUL_DIV_L_DIV,false,
      0,0x0,1,10,1,20,0,0                 ,1,30,1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.bf -9
      w = y+(-9<<2);
      request [0].push_back (entry_t(
      0x13fffff7,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_FLAG_SET,1, w,
      0,TYPE_BRANCH,OPERATION_BRANCH_L_TEST_F,false, 
      1,w,0, 0,0,0 ,1,SPR_LOGIC_SR_F    ,0,0 ,0,0                 ,
      EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
      JMP(w);

      // ===== l.divu r30,r10,r20
      request [0].push_back (entry_t(
      0xe3caa30a,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_MUL_DIV,OPERATION_MUL_DIV_L_DIVU,true,
      0,0x0,1,10,1,20,0,0                 ,1,30,1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.extbs r30,r10
      request [0].push_back (entry_t(
      0xe3ca004c,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_S,false,
      1,8  ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.bnf 11
      w = y+(11<<2);
      request [0].push_back (entry_t(
      0x0c00000b,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_FLAG_UNSET,0, w,
      0,TYPE_BRANCH,OPERATION_BRANCH_L_TEST_NF,false, 
      1,w,0, 0,0,0 ,1,SPR_LOGIC_SR_F    ,0,0 ,0,0                 ,
      EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
      JMP(w);

      // ===== l.extbz r30,r10
      request [0].push_back (entry_t(
      0xe3ca00cc,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_Z,true ,
      1,8  ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;
      
      // ===== l.exths r30,r10
      request [0].push_back (entry_t(
      0xe3ca000c,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_S,false,
      1,16 ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.bnf -9
      w = y+(-9<<2);
      request [0].push_back (entry_t(
      0x0ffffff7,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_FLAG_UNSET,1, w,
      0,TYPE_BRANCH,OPERATION_BRANCH_L_TEST_NF,false, 
      1,w,0, 0,0,0 ,1,SPR_LOGIC_SR_F    ,0,0 ,0,0                 ,
      EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
      JMP(w);

      // ===== l.exthz r30,r10
      request [0].push_back (entry_t(
      0xe3ca008c,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_Z,true ,
      1,16 ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.extws r30,r10
      request [0].push_back (entry_t(
      0xe3ca000d,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_S,false,
      1,32 ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.extwz r30,r10
      request [0].push_back (entry_t(
      0xe3ca004d,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_Z,false,
      1,32 ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.csync
      request [0].push_back (entry_t(
      0x23000000,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_SPECIAL,OPERATION_SPECIAL_L_CSYNC,false,
      0,0  ,0,0 ,0,0 ,0,0                 ,0,0 ,0,0                 ,
      EXCEPTION_USE_NONE,EVENT_TYPE_CSYNC));
      SEQ;

      // ===== l.ff1 r30,r10
      request [0].push_back (entry_t(
      0xe3ca000f,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_FIND,OPERATION_FIND_L_FF1,false,
      0,0  ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.fl1 r30,r10
      request [0].push_back (entry_t(
      0xe3ca010f,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_FIND,OPERATION_FIND_L_FL1,false,
      0,0  ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.j 1018
      w = y+(1018<<2);
      request [0].push_back (entry_t(
      0x000003fa,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,1, w,
      0,TYPE_BRANCH,OPERATION_BRANCH_NONE,false, 
      0,0,0, 0,0,0 ,0,0                 ,0,0 ,0,0                 ,
      EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
      JMP(w);

      // ===== l.lbs r30,0x3fa(r10)
      request [0].push_back (entry_t(
      0x93ca03fa,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_8_S,true,
      1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
      EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.lbz r30,0x3fa(r10)
      request [0].push_back (entry_t(
      0x8fca03fa,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_8_Z,false,
      1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
      EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.j -1018
      w = y+(-1018<<2);
      request [0].push_back (entry_t(
      0x03fffc06,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,1, w,
      0,TYPE_BRANCH,OPERATION_BRANCH_NONE,false, 
      0,0,0, 0,0,0 ,0,0                 ,0,0 ,0,0                 ,
      EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
      JMP(w);

      // ===== l.lhs r30,0x3fa(r10)
      request [0].push_back (entry_t(
      0x9bca03fa,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_16_S,true,
      1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.lhz r30,0x3fa(r10)
      request [0].push_back (entry_t(
      0x97ca03fa,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_16_Z,false,
      1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.jal 1018
      w = y+(1018<<2);
      request [0].push_back (entry_t(
      0x040003fa,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITH_WRITE_STACK,1, w,
      0,TYPE_BRANCH,OPERATION_BRANCH_L_JALR,false,
      1,z+4,0, 0,0,0 ,0,0                 ,1,9 ,0,0                 ,
      EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
      JMP(w);

      // ===== l.lws r30,0x3fa(r10)
      request [0].push_back (entry_t(
      0x8bca03fa,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_32_S,true,
      1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.lwz r30,0x3fa(r10)
      request [0].push_back (entry_t(
      0x87ca03fa,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_32_Z,false,
      1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.jal -1018
      w = y+(-1018<<2);
      request [0].push_back (entry_t(
      0x07fffc06,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITH_WRITE_STACK,1, w,
      0,TYPE_BRANCH,OPERATION_BRANCH_L_JALR,false,
      1,z+4,0, 0,0,0 ,0,0                 ,1,9 ,0,0                 ,
      EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
      JMP(w);

      // ===== l.ld r30,1018(r10)
      request [0].push_back (entry_t(
      0x83ca03fa,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_64_S,true,
      1,1018,1,10,0,0 ,0,0,1,30,0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.ld r30,-1018(r10)
      request [0].push_back (entry_t(
      0x83cafc06,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_64_S,false,
      1,static_cast<Tgeneral_data_t>(-1018),1,10,0,0 ,0,0,1,30,0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.jalr r20
      request [0].push_back (entry_t(
      0x4800a000,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK,1, z, // branch_address_dest can be determined if BRANCH_STATE != NONE (also : previous prediction)
      0,TYPE_BRANCH,OPERATION_BRANCH_L_JALR,false,
      0,0   ,0,0 ,1,20,0,0,1,9 ,0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;
      
      // ===== l.mac r10,r20
      request [0].push_back (entry_t(
      0xc40aa001,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MAC,true,
      0,0,1,10,1,20,0,0,0,0,0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
      SEQ;
      
      // ===== l.maci r10,1018
      request [0].push_back (entry_t(
      0x4c0a03fa,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MAC,false,
      1,1018,1,10,0,0,0,0,0,0,0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
      SEQ;

      // ===== l.maci r10,-1018
      request [0].push_back (entry_t(
      0x4fea0406,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MAC,false,
      1,static_cast<Tgeneral_data_t>(-1018),1,10,0,0,0,0,0,0,0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
      SEQ;
      
      // ===== l.jr r10
      request [0].push_back (entry_t(
      0x44005000,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_READ_REGISTER_WITHOUT_WRITE_STACK,1, z,
      0,TYPE_BRANCH,OPERATION_BRANCH_L_JALR,false,
      0,0   ,0, 0,1,10,0,0,0,0 ,0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;
      
      // ===== l.macrc r30
      request [0].push_back (entry_t(
      0x1bc10000,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MACRC,true,
      0,0,0, 0,0, 0,0,0,1,30,0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
      SEQ;

      // ===== l.mfspr r30,r10,1018
      request [0].push_back (entry_t(
      0xb7ca03fa,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MFSPR,false,
      1,1018,1,10,0, 0,0,0,1,30,0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
      SEQ;

      // ===== l.mfspr r30,r10,-1018
      request [0].push_back (entry_t(
      0xb7cafc06,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
      0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MFSPR,false,
      1,0xfc06,1,10,0, 0,0,0,1,30,0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
      SEQ;

      // ===== l.jr r9 
      request [0].push_back (entry_t(
      0x44004800,x,y,z,
      BRANCH_STATE_NONE,0,BRANCH_CONDITION_READ_STACK,1, z,
      0,TYPE_BRANCH,OPERATION_BRANCH_L_JALR,false,
      0,0   ,0, 0,1,9,0,0,0,0 ,0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;
            
      // ===== l.movhi r30,0x3fa
      request [0].push_back (entry_t(
      0x1bc003fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_MOVE,OPERATION_MOVE_L_MOVHI,true,
      1,0x3fa,0,0, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;
      
      // ===== l.movhi r30,0xfc06
      request [0].push_back (entry_t(
      0x1bc0fc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_MOVE,OPERATION_MOVE_L_MOVHI,false,
      1,0xfc06,0,0, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.msb r10,r20
      request [0].push_back (entry_t(
      0xc40aa002,x,y,z,
      0,0,0,0,0,0,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_MSB,false,
      0,0, 1,10, 1,20, 0,0, 0,0, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
      SEQ;

      // ===== l.msync
      request [0].push_back (entry_t(
      0x22000000,x,y,z,
      0,0,0,0,0,0,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_MSYNC,false,
      0,0, 0,0, 0,0, 0,0, 0,0, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_MSYNC));
      SEQ;

      // ===== l.mtspr r10,r20,0x3fa
      request [0].push_back (entry_t(
      0xc00aa3fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_MTSPR,false,
      1,0x3fa, 1,10, 1,20, 0,0, 0,0, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
      SEQ;

      // ===== l.mtspr r10,r20,0xfc06
      request [0].push_back (entry_t(
      0xc3eaa406,x,y,z,
      0,0,0,0,0,0,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_MTSPR,false,
      1,0xfc06, 1,10, 1,20, 0,0, 0,0, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
      SEQ;

      // ===== l.mul r30,r10,r20
      request [0].push_back (entry_t(
      0xe3caa306,x,y,z,
      0,0,0,0,0,0,
      TYPE_MUL_DIV,OPERATION_MUL_DIV_L_MUL,false,
      0,0, 1,10, 1,20, 0,0, 1,30, 1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.muli r30,r10,0x3fa
      request [0].push_back (entry_t(
      0xb3ca03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_MUL_DIV,OPERATION_MUL_DIV_L_MUL,false,
      1,0x3fa, 1,10, 0,0, 0,0, 1,30, 1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.muli r30,r10,0xfffffc06
      request [0].push_back (entry_t(
      0xb3cafc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_MUL_DIV,OPERATION_MUL_DIV_L_MUL,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 1,30, 1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.mulu r30,r10,r20
      request [0].push_back (entry_t(
      0xe3caa30b,x,y,z,
      0,0,0,0,0,0,
      TYPE_MUL_DIV,OPERATION_MUL_DIV_L_MULU,false,
      0,0, 1,10, 1,20, 0,0, 1,30, 1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.nop 0x3fa
      request [0].push_back (entry_t(
      0x150003fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP,false,
      0,0x3fa, 0,0, 0,0, 0,0, 0,0, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.nop 0xfc06
      request [0].push_back (entry_t(
      0x1500fc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP,false,
      0,0xfc06, 0,0, 0,0, 0,0, 0,0, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.or r30,r10,r20
      request [0].push_back (entry_t(
      0xe3caa004,x,y,z,
      0,0,0,0,0,0,
      TYPE_ALU,OPERATION_ALU_L_OR,false,
      0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.ori r30,r10,0x3fa
      request [0].push_back (entry_t(
      0xabca03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_ALU,OPERATION_ALU_L_OR,false,
      1,0x3fa, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.ori r30,r10,0xfc06
      request [0].push_back (entry_t(
      0xabcafc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_ALU,OPERATION_ALU_L_OR,false,
      1,0xfc06, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.psync
      request [0].push_back (entry_t(
      0x22800000,x,y,z,
      0,0,0,0,0,0,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_PSYNC,false,
      0,0, 0,0, 0,0, 0,0, 0,0, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_PSYNC));
      SEQ;

      // ===== l.ror r30,r10,r20
      request [0].push_back (entry_t(
      0xe3caa0c8,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_ROR,false,
      0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.rori r30,r10,0x3f
      request [0].push_back (entry_t(
      0xbbca00ff,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_ROR,false,
      1,0x3f, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.rori r30,r10,0x1
      request [0].push_back (entry_t(
      0xbbca00c1,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_ROR,false,
      1,0x1, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sb 0x3fa(r10),r20
      request [0].push_back (entry_t(
      0xd80aa3fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_MEMORY,OPERATION_MEMORY_STORE_8,false,
      1,0x3fa, 1,10, 1,20, 0,0, 0,0, 0,0,
      EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sb 0xfffffc06(r10),r20
      request [0].push_back (entry_t(
      0xdbeaa406,x,y,z,
      0,0,0,0,0,0,
      TYPE_MEMORY,OPERATION_MEMORY_STORE_8,false,
      1,0xfffffc06, 1,10, 1,20, 0,0, 0,0, 0,0,
      EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sd 0x3fa(r10),r20
      request [0].push_back (entry_t(
      0xd00aa3fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_MEMORY,OPERATION_MEMORY_STORE_64,false,
      1,0x3fa, 1,10, 1,20, 0,0, 0,0, 0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sd 0xfffffc06(r10),r20
      request [0].push_back (entry_t(
      0xd3eaa406,x,y,z,
      0,0,0,0,0,0,
      TYPE_MEMORY,OPERATION_MEMORY_STORE_64,false,
      1,0xfffffc06, 1,10, 1,20, 0,0, 0,0, 0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sh 0x3fa(r10),r20
      request [0].push_back (entry_t(
      0xdc0aa3fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_MEMORY,OPERATION_MEMORY_STORE_16,false,
      1,0x3fa, 1,10, 1,20, 0,0, 0,0, 0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sh 0xfffffc06(r10),r20
      request [0].push_back (entry_t(
      0xdfeaa406,x,y,z,
      0,0,0,0,0,0,
      TYPE_MEMORY,OPERATION_MEMORY_STORE_16,false,
      1,0xfffffc06, 1,10, 1,20, 0,0, 0,0, 0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sw 0x3fa(r10),r20
      request [0].push_back (entry_t(
      0xd40aa3fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_MEMORY,OPERATION_MEMORY_STORE_32,false,
      1,0x3fa, 1,10, 1,20, 0,0, 0,0, 0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sw 0xfffffc06(r10),r20
      request [0].push_back (entry_t(
      0xd7eaa406,x,y,z,
      0,0,0,0,0,0,
      TYPE_MEMORY,OPERATION_MEMORY_STORE_32,false,
      1,0xfffffc06, 1,10, 1,20, 0,0, 0,0, 0,0,
      EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sll r30,r10,r20
      request [0].push_back (entry_t(
      0xe3caa008,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_SLL,false,
      0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.slli r30,r10,0x1
      request [0].push_back (entry_t(
      0xbbca0001,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_SLL,false,
      1,0x1, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.slli r30,r10,0x3f
      request [0].push_back (entry_t(
      0xbbca003f,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_SLL,false,
      1,0x3f, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sra r30,r10,r20
      request [0].push_back (entry_t(
      0xe3caa088,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_SRA,false,
      0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.srai r30,r10,0x1
      request [0].push_back (entry_t(
      0xbbca0081,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_SRA,false,
      1,0x1, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.srai r30,r10,0x3f
      request [0].push_back (entry_t(
      0xbbca00bf,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_SRA,false,
      1,0x3f, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.srl r30,r10,r20
      request [0].push_back (entry_t(
      0xe3caa048,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_SRL,false,
      0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.srli r30,r10,0x1
      request [0].push_back (entry_t(
      0xbbca0041,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_SRL,false,
      1,0x1, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.srli r30,r10,0x3f
      request [0].push_back (entry_t(
      0xbbca007f,x,y,z,
      0,0,0,0,0,0,
      TYPE_SHIFT,OPERATION_SHIFT_L_SRL,false,
      1,0x3f, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.xor r30,r10,r20
      request [0].push_back (entry_t(
      0xe3caa005,x,y,z,
      0,0,0,0,0,0,
      TYPE_ALU,OPERATION_ALU_L_XOR,false,
      0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.xori r30,r10,0x3fa
      request [0].push_back (entry_t(
      0xafca03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_ALU,OPERATION_ALU_L_XOR,false,
      1,0x3fa, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.xori r30,r10,0xfffffc06
      request [0].push_back (entry_t(
      0xafcafc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_ALU,OPERATION_ALU_L_XOR,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 1,30, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sub r30,r10,r20
      request [0].push_back (entry_t(
      0xe3caa002,x,y,z,
      0,0,0,0,0,0,
      TYPE_ALU,OPERATION_ALU_L_SUB,false,
      0,0, 1,10, 1,20, 0,0, 1,30, 1,SPR_LOGIC_SR_CY_OV,
      EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sys 0x3fa
      request [0].push_back (entry_t(
      0x200003fa,x,y,z,
      0,0,0,0,0,z,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_SYS,false,
      0,0, 0,0, 0,0, 0,0, 0,0, 0,0,
      EXCEPTION_USE_SYSCALL,EVENT_TYPE_EXCEPTION));
      SEQ;

      // ===== l.sys 0xfc06
      request [0].push_back (entry_t(
      0x2000fc06,x,y,z,
      0,0,0,0,0,z,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_SYS,false,
      0,0, 0,0, 0,0, 0,0, 0,0, 0,0,
      EXCEPTION_USE_SYSCALL,EVENT_TYPE_EXCEPTION));
      SEQ;

      // ===== l.trap 0x3fa
      request [0].push_back (entry_t(
      0x210003fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_TRAP,false,
      1,0x3fa, 0,0, 0,0, 0,0, 0,0, 0,0,
      EXCEPTION_USE_TRAP,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.trap 0xfc06
      request [0].push_back (entry_t(
      0x2100fc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_TRAP,false,
      1,0xfc06, 0,0, 0,0, 0,0, 0,0, 0,0,
      EXCEPTION_USE_TRAP,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.rfe
      request [0].push_back (entry_t(
      0x24000000,x,y,z,
      0,0,0,0,0,0,
      TYPE_SPECIAL,OPERATION_SPECIAL_L_RFE,false,
      0,0, 0,0, 0,0, 0,0, 0,0, 0,0,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfeq r10,r20
      request [0].push_back (entry_t(
      0xe40aa000,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFEQ,false,
      0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfeqi r10,0x3fa
      request [0].push_back (entry_t(
      0xbc0a03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFEQ,false,
      1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfeqi r10,0xfffffc06
      request [0].push_back (entry_t(
      0xbc0afc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFEQ,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfne r10,r20
      request [0].push_back (entry_t(
      0xe42aa000,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFNE,false,
      0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfnei r10,0x3fa
      request [0].push_back (entry_t(
      0xbc2a03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFNE,false,
      1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfnei r10,0xfffffc06
      request [0].push_back (entry_t(
      0xbc2afc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFNE,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfges r10,r20
      request [0].push_back (entry_t(
      0xe56aa000,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGES,false,
      0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfgesi r10,0x3fa
      request [0].push_back (entry_t(
      0xbd6a03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGES,false,
      1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfgesi r10,0xfffffc06
      request [0].push_back (entry_t(
      0xbd6afc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGES,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfgeu r10,r20
      request [0].push_back (entry_t(
      0xe46aa000,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGEU,false,
      0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfgeui r10,0x3fa
      request [0].push_back (entry_t(
      0xbc6a03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGEU,false,
      1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfgeui r10,0xfffffc06
      request [0].push_back (entry_t(
      0xbc6afc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGEU,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfgts r10,r20
      request [0].push_back (entry_t(
      0xe54aa000,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGTS,false,
      0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfgtsi r10,0x3fa
      request [0].push_back (entry_t(
      0xbd4a03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGTS,false,
      1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfgtsi r10,0xfffffc06
      request [0].push_back (entry_t(
      0xbd4afc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGTS,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfgtu r10,r20
      request [0].push_back (entry_t(
      0xe44aa000,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGTU,false,
      0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfgtui r10,0x3fa
      request [0].push_back (entry_t(
      0xbc4a03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGTU,false,
      1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfgtui r10,0xfffffc06
      request [0].push_back (entry_t(
      0xbc4afc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFGTU,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfles r10,r20
      request [0].push_back (entry_t(
      0xe5aaa000,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLES,false,
      0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sflesi r10,0x3fa
      request [0].push_back (entry_t(
      0xbdaa03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLES,false,
      1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sflesi r10,0xfffffc06
      request [0].push_back (entry_t(
      0xbdaafc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLES,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfleu r10,r20
      request [0].push_back (entry_t(
      0xe4aaa000,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLEU,false,
      0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfleui r10,0x3fa
      request [0].push_back (entry_t(
      0xbcaa03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLEU,false,
      1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfleui r10,0xfffffc06
      request [0].push_back (entry_t(
      0xbcaafc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLEU,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sflts r10,r20
      request [0].push_back (entry_t(
      0xe58aa000,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLTS,false,
      0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfltsi r10,0x3fa
      request [0].push_back (entry_t(
      0xbd8a03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLTS,false,
      1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfltsi r10,0xfffffc06
      request [0].push_back (entry_t(
      0xbd8afc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLTS,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfltu r10,r20
      request [0].push_back (entry_t(
      0xe48aa000,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLTU,false,
      0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfltui r10,0x3fa
      request [0].push_back (entry_t(
      0xbc8a03fa,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLTU,false,
      1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      // ===== l.sfltui r10,0xfffffc06
      request [0].push_back (entry_t(
      0xbc8afc06,x,y,z,
      0,0,0,0,0,0,
      TYPE_TEST,OPERATION_TEST_L_SFLTU,false,
      1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
      EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
      SEQ;

      for (uint32_t i=1; i<_param->_nb_context; i++)
	{
	  request[i] = request [0];
	}

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  delay_slot_current  [i] = false;
	  delay_slot_next     [i] = false;
	}

      uint32_t nb_request = request[0].size() * _param->_nb_context;

      while (nb_request > 0)
	{
	  for (uint32_t i=0; i<_param->_nb_context; i++)
	    {
	      delay_slot_previous  [i] = false;
	      
	      in_CONTEXT_DECOD_ENABLE [i]->write((rand()%100)<percent_transaction_decod);

	      for (uint32_t j=0; j<_param->_nb_inst_fetch[i]; j++)
		in_IFETCH_VAL [i][j]->write(0);
		  
	      if ((rand()%100)<percent_transaction_ifetch)
		{
		  list<entry_t>::iterator it = request [i].begin();

		  if (it!=request [i].end())
		    {
		      uint32_t lsb = (it->_address>>2)%_param->_nb_inst_fetch[i];
		      
		      in_IFETCH_ADDRESS         [i]->write(it->_address-(lsb<<2));
		      in_IFETCH_BRANCH_STATE    [i]->write(BRANCH_STATE_NONE);
		      if (_param->_have_port_inst_ifetch_ptr)
		      in_IFETCH_INST_IFETCH_PTR [i]->write(0);

		      // Alignement
		      for (uint32_t j=lsb; j<_param->_nb_inst_fetch[i]; j++)
			{
			  in_IFETCH_VAL                         [i][j]->write(1);
			  in_IFETCH_INSTRUCTION                 [i][j]->write(it->_instruction);
// 			  in_IFETCH_ADDRESS_NEXT                [i]->write(it->_address_next);
			  if (it->_type == TYPE_BRANCH)
			  in_IFETCH_BRANCH_STATE                [i]->write(it->_branch_state);
			  in_IFETCH_BRANCH_UPDATE_PREDICTION_ID [i]->write(it->_branch_update_prediction_id);
			  
			  if ((it->_is_delay_slot) or
			      ((++it)==request [i].end()))
			    break;
			}
		    }
		}
	    }
	  
	  {
	    bool previous_ack = true;
	      
	    for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	      {
		bool ack = previous_ack and ((rand()%100)<percent_transaction_decod);
		in_DECOD_ACK [i]->write(ack);
		
		previous_ack = ack;

		in_PREDICT_ACK          [i]->write((rand()%100)<percent_transaction_predict);
// 		in_PREDICT_CAN_CONTINUE [i]->write(0);
	      }
	  }

	  in_CONTEXT_EVENT_ACK->write((rand()%100)<percent_transaction_event);

	  SC_START(0);


	  uint32_t nb_inst_ifetch = 0;
	  for (uint32_t i=0; i<_param->_nb_context; i++)
	    for (uint32_t j=0; j<_param->_nb_inst_fetch[i]; j++)
	    if (in_IFETCH_VAL[i][j]->read() and out_IFETCH_ACK[i][j]->read())
	      {
		LABEL("IFETCH      [%d][%d] : transaction",i,j);
		nb_inst_ifetch ++;
	      }

	  uint32_t nb_inst_decod = 0;
	  uint32_t find_event = false;

	  for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	    if (out_DECOD_VAL[i]->read() and in_DECOD_ACK[i]->read())
	      {
		Tcontext_t context = (_param->_have_port_context_id)?out_DECOD_CONTEXT_ID[i]->read():0;

		LABEL("DECOD       [%d]    : transaction",i  );
		LABEL(" * context         : %d",context);

		if (_param->_have_port_depth)
		TEST(Tdepth_t          ,  out_DECOD_DEPTH         [i]->read(), request [context].front()._depth        );
		TEST(Ttype_t           ,  out_DECOD_TYPE          [i]->read(), request [context].front()._type         );
		TEST(Toperation_t      ,  out_DECOD_OPERATION     [i]->read(), request [context].front()._operation    );
		TEST(Tcontrol_t        ,  out_DECOD_IS_DELAY_SLOT [i]->read(), request [context].front()._is_delay_slot);
		TEST(Tcontrol_t        , delay_slot_current [context]        , request [context].front()._is_delay_slot);
		TEST(Tgeneral_data_t   ,  out_DECOD_ADDRESS       [i]->read(), request [context].front()._address      );
		TEST(Tcontrol_t        ,  out_DECOD_HAS_IMMEDIAT  [i]->read(), request [context].front()._has_immediat );
		if (request [context].front()._has_immediat)
		TEST(Tgeneral_data_t   ,  out_DECOD_IMMEDIAT      [i]->read(), request [context].front()._immediat     );
		TEST(Tcontrol_t        ,  out_DECOD_READ_RA       [i]->read(), request [context].front()._read_ra      );
		if (request [context].front()._read_ra)
		TEST(Tgeneral_address_t,  out_DECOD_NUM_REG_RA    [i]->read(), request [context].front()._num_reg_ra   );
		TEST(Tcontrol_t        ,  out_DECOD_READ_RB       [i]->read(), request [context].front()._read_rb      );
		if (request [context].front()._read_rb)
		TEST(Tgeneral_address_t,  out_DECOD_NUM_REG_RB    [i]->read(), request [context].front()._num_reg_rb   );
		TEST(Tcontrol_t        ,  out_DECOD_READ_RC       [i]->read(), request [context].front()._read_rc      );
		if (request [context].front()._read_rc)
		TEST(Tspecial_address_t,  out_DECOD_NUM_REG_RC    [i]->read(), request [context].front()._num_reg_rc   );
		TEST(Tcontrol_t        ,  out_DECOD_WRITE_RD      [i]->read(), request [context].front()._write_rd     );
		if (request [context].front()._write_rd)
		TEST(Tgeneral_address_t,  out_DECOD_NUM_REG_RD    [i]->read(), request [context].front()._num_reg_rd   );
		TEST(Tcontrol_t        ,  out_DECOD_WRITE_RE      [i]->read(), request [context].front()._write_re     );
		if (request [context].front()._write_re)
		TEST(Tspecial_address_t,  out_DECOD_NUM_REG_RE    [i]->read(), request [context].front()._num_reg_re   );
		TEST(Texception_t      ,  out_DECOD_EXCEPTION_USE [i]->read(), request [context].front()._exception_use);

		if (request [context].front()._type == TYPE_BRANCH)
		  {
		    delay_slot_next     [context] = true;

		    TEST(Tcontrol_t, out_PREDICT_VAL[i]->read(), true);
		    TEST(Tcontrol_t,  in_PREDICT_ACK[i]->read(), true);
		    
		    LABEL("PREDICT     [%d]    : transaction",i  );

		    if (_param->_have_port_context_id)
		    TEST(Tcontext_t         , out_PREDICT_CONTEXT_ID                  [i]->read(), context);
		    TEST(Tcontrol_t         , out_PREDICT_MATCH_INST_IFETCH_PTR       [i]->read(),((request [context].front()._address>>2)%_param->_nb_inst_fetch[context]) == 0);
		    TEST(Tbranch_state_t    , out_PREDICT_BRANCH_STATE                [i]->read(), request [context].front()._branch_state               );
		    if (_param->_have_port_branch_update_prediction_id)
		    TEST(Tprediction_ptr_t  , out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [i]->read(), request [context].front()._branch_update_prediction_id);
		    TEST(Tbranch_condition_t, out_PREDICT_BRANCH_CONDITION            [i]->read(), request [context].front()._branch_condition           );
// 		    TEST(Tcontrol_t         , out_PREDICT_BRANCH_STACK_WRITE          [i]->read(), request [context].front()._branch_stack_write         );
		    TEST(Tcontrol_t         , out_PREDICT_BRANCH_DIRECTION            [i]->read(), request [context].front()._branch_direction           );
		    TEST(Tgeneral_data_t    , out_PREDICT_ADDRESS_SRC                 [i]->read(), request [context].front()._address                    );
		    TEST(Tgeneral_data_t    , out_PREDICT_ADDRESS_DEST                [i]->read(), request [context].front()._branch_address_dest        );
		  }
		else
		  {
		    TEST(Tcontrol_t, out_PREDICT_VAL[i]->read(), false);
		  }

		TEST(bool, find_event, false); // can continue decod after event
		if (request [context].front()._context_event_type != EVENT_TYPE_NONE)
		  {
		    find_event = true;
		    
		    LABEL("CONTEXT_EVENT      : transaction");

		    if (_param->_have_port_context_id)
		    TEST(Tcontext_t     ,out_CONTEXT_EVENT_CONTEXT_ID   ->read(), context);
		    TEST(Tevent_type_t  ,out_CONTEXT_EVENT_TYPE         ->read(), request [context].front()._context_event_type);
		    TEST(Tcontrol_t     ,out_CONTEXT_EVENT_IS_DELAY_SLOT->read(), request [context].front()._is_delay_slot);
		    TEST(Tgeneral_data_t,out_CONTEXT_EVENT_ADDRESS      ->read(), request [context].front()._address      );
		    TEST(Tgeneral_data_t,out_CONTEXT_EVENT_ADDRESS_EPCR ->read(), request [context].front()._address_next );

		  }

		TEST(bool, delay_slot_previous [context], false); // can't continue
		delay_slot_previous [context] = delay_slot_current  [context];
		delay_slot_current  [context] = delay_slot_next     [context];
		delay_slot_next     [context] = false;

		request [context].pop_front();
		nb_inst_decod ++;
		nb_request --;
	      }

	  TEST(bool, (out_CONTEXT_EVENT_VAL->read() and in_CONTEXT_EVENT_ACK->read()), find_event);
	  TEST(uint32_t, nb_inst_decod, nb_inst_ifetch);

	  SC_START(1);
	}
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_IFETCH_VAL                         ;
  delete [] out_IFETCH_ACK                         ;
  delete []  in_IFETCH_INSTRUCTION                 ;
  delete []  in_IFETCH_CONTEXT_ID                  ;
  delete []  in_IFETCH_ADDRESS                     ;
//   delete []  in_IFETCH_ADDRESS_NEXT                ;
  delete []  in_IFETCH_INST_IFETCH_PTR             ;
  delete []  in_IFETCH_BRANCH_STATE                ;
  delete []  in_IFETCH_BRANCH_UPDATE_PREDICTION_ID ;
  
  delete [] out_DECOD_VAL                          ;
  delete []  in_DECOD_ACK                          ;
  delete [] out_DECOD_CONTEXT_ID                   ;
  delete [] out_DECOD_DEPTH                        ;
  delete [] out_DECOD_TYPE                         ;
  delete [] out_DECOD_OPERATION                    ;
  delete [] out_DECOD_IS_DELAY_SLOT                ;
  delete [] out_DECOD_ADDRESS                      ;
  delete [] out_DECOD_HAS_IMMEDIAT                 ;
  delete [] out_DECOD_IMMEDIAT                     ;
  delete [] out_DECOD_READ_RA                      ;
  delete [] out_DECOD_NUM_REG_RA                   ;
  delete [] out_DECOD_READ_RB                      ;
  delete [] out_DECOD_NUM_REG_RB                   ;
  delete [] out_DECOD_READ_RC                      ;
  delete [] out_DECOD_NUM_REG_RC                   ;
  delete [] out_DECOD_WRITE_RD                     ;
  delete [] out_DECOD_NUM_REG_RD                   ;
  delete [] out_DECOD_WRITE_RE                     ;
  delete [] out_DECOD_NUM_REG_RE                   ;
  delete [] out_DECOD_EXCEPTION_USE                ;
  
  delete [] out_PREDICT_VAL                        ;
  delete []  in_PREDICT_ACK                        ;
  delete [] out_PREDICT_CONTEXT_ID                 ;
  delete [] out_PREDICT_MATCH_INST_IFETCH_PTR      ;
  delete [] out_PREDICT_BRANCH_STATE               ;
  delete [] out_PREDICT_BRANCH_UPDATE_PREDICTION_ID;
  delete [] out_PREDICT_BRANCH_CONDITION           ;
//   delete [] out_PREDICT_BRANCH_STACK_WRITE         ;
  delete [] out_PREDICT_BRANCH_DIRECTION           ;
  delete [] out_PREDICT_ADDRESS_SRC                ;
  delete [] out_PREDICT_ADDRESS_DEST               ;
//   delete []  in_PREDICT_CAN_CONTINUE               ;
  
  delete []  in_CONTEXT_DECOD_ENABLE               ;
  delete []  in_CONTEXT_DEPTH                      ;
  
  delete    out_CONTEXT_EVENT_VAL                  ;
  delete     in_CONTEXT_EVENT_ACK                  ;
  delete    out_CONTEXT_EVENT_CONTEXT_ID           ;
  delete    out_CONTEXT_EVENT_TYPE                 ;
  delete    out_CONTEXT_EVENT_IS_DELAY_SLOT        ;
  delete    out_CONTEXT_EVENT_ADDRESS              ;
  delete    out_CONTEXT_EVENT_ADDRESS_EPCR         ;
#endif

  delete _Decod;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
