/*
 * $Id: test.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Common/include/BitManipulation.h"
#include "Behavioural/include/Allocation.h"
#include <set>


class entry_t
{
  public : Tcontext_t         _context_id     ;
  public : Tcontext_t         _front_end_id   ;
  public : Tcontext_t         _ooo_engine_id  ;
  public : Tpacket_t          _packet_id      ;
//public : Toperation_t       _operation      ;
  public : Ttype_t            _type           ;
  public : Tcontrol_t         _write_rd       ;
  public : Tgeneral_address_t _num_reg_rd     ;
  public : Tgeneral_data_t    _data_rd        ;
  public : Tcontrol_t         _write_re       ;
  public : Tspecial_address_t _num_reg_re     ;
  public : Tspecial_data_t    _data_re        ;
  public : Texception_t       _exception      ;
  public : Tcontrol_t         _no_sequence    ;
  public : Tgeneral_data_t    _address        ;
  
public : entry_t (Tcontext_t         context_id     ,
  		  Tcontext_t         front_end_id   ,
  		  Tcontext_t         ooo_engine_id  ,
  		  Tpacket_t          packet_id      ,
//		  Toperation_t       operation      ,
		  Ttype_t            type           ,
  		  Tcontrol_t         write_rd       ,
  		  Tgeneral_address_t num_reg_rd     ,
  		  Tgeneral_data_t    data_rd        ,
  		  Tcontrol_t         write_re       ,
  		  Tspecial_address_t num_reg_re     ,
  		  Tspecial_data_t    data_re        ,
  		  Texception_t       exception      ,
  		  Tcontrol_t         no_sequence    ,
  		  Tgeneral_data_t    address        )
  {
    _context_id     = context_id   ;
    _front_end_id   = front_end_id ;
    _ooo_engine_id  = ooo_engine_id;
    _packet_id      = packet_id    ;
//  _operation      = operation    ;
    _type           = type         ;
    _write_rd       = write_rd     ;
    _num_reg_rd     = num_reg_rd   ;
    _data_rd        = data_rd      ;
    _write_re       = write_re     ;
    _num_reg_re     = num_reg_re   ;
    _data_re        = data_re      ;
    _exception      = exception    ;
    _no_sequence    = no_sequence  ;
    _address        = address      ;
  }
};

void test (string name,
	   morpheo::behavioural::core::multi_execute_loop::execute_loop::network::execution_unit_to_write_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Execution_unit_to_Write_unit * _Execution_unit_to_Write_unit = new Execution_unit_to_Write_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     USE_ALL);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_VAL          ," in_EXECUTE_UNIT_OUT_VAL          ",Tcontrol_t        ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_UNIT_OUT_ACK          ,"out_EXECUTE_UNIT_OUT_ACK          ",Tcontrol_t        ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_CONTEXT_ID   ," in_EXECUTE_UNIT_OUT_CONTEXT_ID   ",Tcontext_t        ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_FRONT_END_ID ," in_EXECUTE_UNIT_OUT_FRONT_END_ID ",Tcontext_t        ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID," in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID",Tcontext_t        ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_PACKET_ID    ," in_EXECUTE_UNIT_OUT_PACKET_ID    ",Tpacket_t         ,_param->_nb_execute_unit);
//ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_OPERATION    ," in_EXECUTE_UNIT_OUT_OPERATION    ",Toperation_t      ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_TYPE         ," in_EXECUTE_UNIT_OUT_TYPE         ",Ttype_t           ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_WRITE_RD     ," in_EXECUTE_UNIT_OUT_WRITE_RD     ",Tcontrol_t        ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_NUM_REG_RD   ," in_EXECUTE_UNIT_OUT_NUM_REG_RD   ",Tgeneral_address_t,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_DATA_RD      ," in_EXECUTE_UNIT_OUT_DATA_RD      ",Tgeneral_data_t   ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_WRITE_RE     ," in_EXECUTE_UNIT_OUT_WRITE_RE     ",Tcontrol_t        ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_NUM_REG_RE   ," in_EXECUTE_UNIT_OUT_NUM_REG_RE   ",Tspecial_address_t,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_DATA_RE      ," in_EXECUTE_UNIT_OUT_DATA_RE      ",Tspecial_data_t   ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_EXCEPTION    ," in_EXECUTE_UNIT_OUT_EXCEPTION    ",Texception_t      ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_NO_SEQUENCE  ," in_EXECUTE_UNIT_OUT_NO_SEQUENCE  ",Tcontrol_t        ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_UNIT_OUT_ADDRESS      ," in_EXECUTE_UNIT_OUT_ADDRESS      ",Tgeneral_data_t   ,_param->_nb_execute_unit);
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_VAL             ,"out_WRITE_UNIT_IN_VAL             ",Tcontrol_t        ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL( in_WRITE_UNIT_IN_ACK             ," in_WRITE_UNIT_IN_ACK             ",Tcontrol_t        ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_CONTEXT_ID      ,"out_WRITE_UNIT_IN_CONTEXT_ID      ",Tcontext_t        ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_FRONT_END_ID    ,"out_WRITE_UNIT_IN_FRONT_END_ID    ",Tcontext_t        ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_OOO_ENGINE_ID   ,"out_WRITE_UNIT_IN_OOO_ENGINE_ID   ",Tcontext_t        ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_PACKET_ID       ,"out_WRITE_UNIT_IN_PACKET_ID       ",Tpacket_t         ,_param->_nb_write_unit  );
//ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_OPERATION       ,"out_WRITE_UNIT_IN_OPERATION       ",Toperation_t      ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_TYPE            ,"out_WRITE_UNIT_IN_TYPE            ",Ttype_t           ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_WRITE_RD        ,"out_WRITE_UNIT_IN_WRITE_RD        ",Tcontrol_t        ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_NUM_REG_RD      ,"out_WRITE_UNIT_IN_NUM_REG_RD      ",Tgeneral_address_t,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_DATA_RD         ,"out_WRITE_UNIT_IN_DATA_RD         ",Tgeneral_data_t   ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_WRITE_RE        ,"out_WRITE_UNIT_IN_WRITE_RE        ",Tcontrol_t        ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_NUM_REG_RE      ,"out_WRITE_UNIT_IN_NUM_REG_RE      ",Tspecial_address_t,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_DATA_RE         ,"out_WRITE_UNIT_IN_DATA_RE         ",Tspecial_data_t   ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_EXCEPTION       ,"out_WRITE_UNIT_IN_EXCEPTION       ",Texception_t      ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_NO_SEQUENCE     ,"out_WRITE_UNIT_IN_NO_SEQUENCE     ",Tcontrol_t        ,_param->_nb_write_unit  );
  ALLOC1_SC_SIGNAL(out_WRITE_UNIT_IN_ADDRESS         ,"out_WRITE_UNIT_IN_ADDRESS         ",Tgeneral_data_t   ,_param->_nb_write_unit  );
    
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Execution_unit_to_Write_unit.\n"),name.c_str());

  (*(_Execution_unit_to_Write_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Execution_unit_to_Write_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_VAL          ,_param->_nb_execute_unit);
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_EXECUTE_UNIT_OUT_ACK          ,_param->_nb_execute_unit);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_CONTEXT_ID   ,_param->_nb_execute_unit);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_FRONT_END_ID ,_param->_nb_execute_unit);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID,_param->_nb_execute_unit);
  if (_param->_have_port_packet_id)
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_PACKET_ID    ,_param->_nb_execute_unit);
//INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_OPERATION    ,_param->_nb_execute_unit);
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_TYPE         ,_param->_nb_execute_unit);
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_WRITE_RD     ,_param->_nb_execute_unit);
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_NUM_REG_RD   ,_param->_nb_execute_unit);
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_DATA_RD      ,_param->_nb_execute_unit);
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_WRITE_RE     ,_param->_nb_execute_unit);
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_NUM_REG_RE   ,_param->_nb_execute_unit);
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_DATA_RE      ,_param->_nb_execute_unit);
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_EXCEPTION    ,_param->_nb_execute_unit);
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_NO_SEQUENCE  ,_param->_nb_execute_unit);
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_EXECUTE_UNIT_OUT_ADDRESS      ,_param->_nb_execute_unit);

  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_VAL             ,_param->_nb_write_unit  );
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit, in_WRITE_UNIT_IN_ACK             ,_param->_nb_write_unit  );
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_CONTEXT_ID      ,_param->_nb_write_unit  );
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_FRONT_END_ID    ,_param->_nb_write_unit  );
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_OOO_ENGINE_ID   ,_param->_nb_write_unit  );
  if (_param->_have_port_packet_id)
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_PACKET_ID       ,_param->_nb_write_unit  );
//INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_OPERATION       ,_param->_nb_write_unit  );
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_TYPE            ,_param->_nb_write_unit  );
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_WRITE_RD        ,_param->_nb_write_unit  );
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_NUM_REG_RD      ,_param->_nb_write_unit  );
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_DATA_RD         ,_param->_nb_write_unit  );
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_WRITE_RE        ,_param->_nb_write_unit  );
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_NUM_REG_RE      ,_param->_nb_write_unit  );
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_DATA_RE         ,_param->_nb_write_unit  );
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_EXCEPTION       ,_param->_nb_write_unit  );
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_NO_SEQUENCE     ,_param->_nb_write_unit  );
  INSTANCE1_SC_SIGNAL(_Execution_unit_to_Write_unit,out_WRITE_UNIT_IN_ADDRESS         ,_param->_nb_write_unit  );

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
// const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_in  = 75;
  const  int32_t percent_transaction_out = 75;

  set<Tcontext_t> execute_unit_thread [_param->_nb_execute_unit];
 
  for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
    for (uint32_t j=0; j<_param->_nb_write_unit; j++)
      if (_param->_table_routing[i][j])
	for (uint32_t k=0; k<_param->_nb_thread; k++)
	  if (_param->_table_thread[j][k])
	    {
	      execute_unit_thread [i].insert(k);
	    }
  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      list<entry_t> request [_param->_nb_execute_unit];

      uint32_t nb_request_in;
      for (nb_request_in=0; nb_request_in < _param->_nb_packet; )
	for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	  {
	    if (nb_request_in >= _param->_nb_packet)
	      break;

	    Tcontext_t context_id   ;
	    Tcontext_t front_end_id ;
	    Tcontext_t ooo_engine_id;
	    Tcontext_t num_thread   ;

	    // Find compatible thread
	    do
	      {
		context_id    = range<Tcontext_t> (rand(), _param->_size_context_id   );
		front_end_id  = range<Tcontext_t> (rand(), _param->_size_front_end_id );
		ooo_engine_id = range<Tcontext_t> (rand(), _param->_size_ooo_engine_id);
		num_thread    = get_num_thread (context_id   , _param->_size_context_id   ,
						front_end_id , _param->_size_front_end_id ,
						ooo_engine_id, _param->_size_ooo_engine_id);
	      }
	    while (execute_unit_thread[i].find(num_thread) == execute_unit_thread[i].end());

	    request[i].push_back(entry_t (context_id   ,
					  front_end_id ,
					  ooo_engine_id,
					  nb_request_in,
					  //range<Toperation_t      > (rand(), _param->_size_operation       ),
					  range<Ttype_t           > (rand(), _param->_size_type            ),
					  range<Tcontrol_t        > (rand(), 2                             ),
					  range<Tgeneral_address_t> (rand(), _param->_size_general_register),
					  range<Tgeneral_data_t   > (rand(), _param->_size_general_data    ),
					  range<Tcontrol_t        > (rand(), 2                             ),
					  range<Tspecial_address_t> (rand(), _param->_size_special_register),
					  range<Tspecial_data_t   > (rand(), _param->_size_special_data    ),
					  range<Texception_t      > (rand(), _param->_size_exception       ),
					  range<Tcontrol_t        > (rand(), 2                             ),
					  range<Tgeneral_data_t   > (rand(), _param->_size_general_data    )
					  ));

	    nb_request_in++;
	  }

      uint32_t   nb_request_out = 0;

      while (nb_request_out < nb_request_in)
	{
	  for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	    {
	      bool val = not request[i].empty() and ((rand()%100) < percent_transaction_in);
		
	      in_EXECUTE_UNIT_OUT_VAL [i]->write(val);

	      if (val)
		{
		  in_EXECUTE_UNIT_OUT_CONTEXT_ID           [i] ->write(request[i].front()._context_id           );
		  in_EXECUTE_UNIT_OUT_FRONT_END_ID         [i] ->write(request[i].front()._front_end_id         );
		  in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID        [i] ->write(request[i].front()._ooo_engine_id        );
		  in_EXECUTE_UNIT_OUT_PACKET_ID            [i] ->write(request[i].front()._packet_id            );
// 		  in_EXECUTE_UNIT_OUT_OPERATION            [i] ->write(request[i].front()._operation            );
		  in_EXECUTE_UNIT_OUT_TYPE                 [i] ->write(request[i].front()._type                 );
		  in_EXECUTE_UNIT_OUT_WRITE_RD             [i] ->write(request[i].front()._write_rd             );
		  in_EXECUTE_UNIT_OUT_NUM_REG_RD           [i] ->write(request[i].front()._num_reg_rd           );
		  in_EXECUTE_UNIT_OUT_DATA_RD              [i] ->write(request[i].front()._data_rd              );
		  in_EXECUTE_UNIT_OUT_WRITE_RE             [i] ->write(request[i].front()._write_re             );
		  in_EXECUTE_UNIT_OUT_NUM_REG_RE           [i] ->write(request[i].front()._num_reg_re           );
		  in_EXECUTE_UNIT_OUT_DATA_RE              [i] ->write(request[i].front()._data_re              );
		  in_EXECUTE_UNIT_OUT_EXCEPTION            [i] ->write(request[i].front()._exception            );
		  in_EXECUTE_UNIT_OUT_NO_SEQUENCE          [i] ->write(request[i].front()._no_sequence          );
		  in_EXECUTE_UNIT_OUT_ADDRESS              [i] ->write(request[i].front()._address              );
		}
	    }

	  for (uint32_t i=0; i<_param->_nb_write_unit; i++)
	    in_WRITE_UNIT_IN_ACK [i]->write((rand()%100) < percent_transaction_out);

	  SC_START(0);

	  for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	    if (in_EXECUTE_UNIT_OUT_VAL [i]->read() and out_EXECUTE_UNIT_OUT_ACK [i]->read())
	      {
		LABEL("EXECUTE_UNIT_OUT   [%d] - Transaction accepted",i);
	      }

	  for (uint32_t i=0; i<_param->_nb_write_unit; i++)
	    if (out_WRITE_UNIT_IN_VAL [i]->read() and in_WRITE_UNIT_IN_ACK [i]->read())
	      {
		LABEL("WRITE_UNIT_IN [%d] - Transaction accepted (%d)",i,nb_request_out);
		nb_request_out ++;
		
		Tpacket_t packet = (_param->_have_port_packet_id)?out_WRITE_UNIT_IN_PACKET_ID[i]->read():0;
		LABEL("  * packet           : %d",packet);		
		uint32_t execute_unit;

		// find execute_unit
		for (execute_unit=0; execute_unit<_param->_nb_execute_unit; execute_unit++)
		  if (packet == ((_param->_have_port_packet_id)?request[execute_unit].front()._packet_id:0))
		    break;

		LABEL("  * execute_unit source : %d",execute_unit);

		if (_param->_have_port_packet_id)
		TEST(Tcontext_t        ,out_WRITE_UNIT_IN_PACKET_ID            [i]->read(), request[execute_unit].front()._packet_id            );

		// Authorised link ? execute_unit -> write_unit
		TEST(bool, _param->_table_routing[execute_unit][i], true);

		if (_param->_have_port_context_id)
		TEST(Tcontext_t        ,out_WRITE_UNIT_IN_CONTEXT_ID           [i]->read(), request[execute_unit].front()._context_id           );
		if (_param->_have_port_front_end_id)
		TEST(Tcontext_t        ,out_WRITE_UNIT_IN_FRONT_END_ID         [i]->read(), request[execute_unit].front()._front_end_id         );
		if (_param->_have_port_ooo_engine_id)
		TEST(Tcontext_t        ,out_WRITE_UNIT_IN_OOO_ENGINE_ID        [i]->read(), request[execute_unit].front()._ooo_engine_id        );
// 		TEST(Toperation_t      ,out_WRITE_UNIT_IN_OPERATION            [i]->read(), request[execute_unit].front()._operation            );
		TEST(Ttype_t           ,out_WRITE_UNIT_IN_TYPE                 [i]->read(), request[execute_unit].front()._type                 );
		TEST(Tcontrol_t        ,out_WRITE_UNIT_IN_WRITE_RD             [i]->read(), request[execute_unit].front()._write_rd             );
		TEST(Tgeneral_address_t,out_WRITE_UNIT_IN_NUM_REG_RD           [i]->read(), request[execute_unit].front()._num_reg_rd           );
		TEST(Tgeneral_data_t   ,out_WRITE_UNIT_IN_DATA_RD              [i]->read(), request[execute_unit].front()._data_rd              );
		TEST(Tcontrol_t        ,out_WRITE_UNIT_IN_WRITE_RE             [i]->read(), request[execute_unit].front()._write_re             );
		TEST(Tspecial_address_t,out_WRITE_UNIT_IN_NUM_REG_RE           [i]->read(), request[execute_unit].front()._num_reg_re           );
		TEST(Tspecial_data_t   ,out_WRITE_UNIT_IN_DATA_RE              [i]->read(), request[execute_unit].front()._data_re              );
		TEST(Texception_t      ,out_WRITE_UNIT_IN_EXCEPTION            [i]->read(), request[execute_unit].front()._exception            );
		TEST(Tcontrol_t        ,out_WRITE_UNIT_IN_NO_SEQUENCE          [i]->read(), request[execute_unit].front()._no_sequence          );
		TEST(Tgeneral_data_t   ,out_WRITE_UNIT_IN_ADDRESS              [i]->read(), request[execute_unit].front()._address              );
		
		request[execute_unit].pop_front();
	      }
	  SC_START(1);
	}

    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_EXECUTE_UNIT_OUT_VAL          ;
  delete [] out_EXECUTE_UNIT_OUT_ACK          ;
  delete []  in_EXECUTE_UNIT_OUT_CONTEXT_ID   ;
  delete []  in_EXECUTE_UNIT_OUT_FRONT_END_ID ;
  delete []  in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID;
  delete []  in_EXECUTE_UNIT_OUT_PACKET_ID    ;
//delete []  in_EXECUTE_UNIT_OUT_OPERATION    ;
  delete []  in_EXECUTE_UNIT_OUT_TYPE         ;
  delete []  in_EXECUTE_UNIT_OUT_WRITE_RD     ;
  delete []  in_EXECUTE_UNIT_OUT_NUM_REG_RD   ;
  delete []  in_EXECUTE_UNIT_OUT_DATA_RD      ;
  delete []  in_EXECUTE_UNIT_OUT_WRITE_RE     ;
  delete []  in_EXECUTE_UNIT_OUT_NUM_REG_RE   ;
  delete []  in_EXECUTE_UNIT_OUT_DATA_RE      ;
  delete []  in_EXECUTE_UNIT_OUT_EXCEPTION    ;
  delete []  in_EXECUTE_UNIT_OUT_NO_SEQUENCE  ;
  delete []  in_EXECUTE_UNIT_OUT_ADDRESS      ;

  delete [] out_WRITE_UNIT_IN_VAL             ;
  delete []  in_WRITE_UNIT_IN_ACK             ;
  delete [] out_WRITE_UNIT_IN_CONTEXT_ID      ;
  delete [] out_WRITE_UNIT_IN_FRONT_END_ID    ;
  delete [] out_WRITE_UNIT_IN_OOO_ENGINE_ID   ;
  delete [] out_WRITE_UNIT_IN_PACKET_ID       ;
//delete [] out_WRITE_UNIT_IN_OPERATION       ;
  delete [] out_WRITE_UNIT_IN_TYPE            ;
  delete [] out_WRITE_UNIT_IN_WRITE_RD        ;
  delete [] out_WRITE_UNIT_IN_NUM_REG_RD      ;
  delete [] out_WRITE_UNIT_IN_DATA_RD         ;
  delete [] out_WRITE_UNIT_IN_WRITE_RE        ;
  delete [] out_WRITE_UNIT_IN_NUM_REG_RE      ;
  delete [] out_WRITE_UNIT_IN_DATA_RE         ;
  delete [] out_WRITE_UNIT_IN_EXCEPTION       ;
  delete [] out_WRITE_UNIT_IN_NO_SEQUENCE     ;
  delete [] out_WRITE_UNIT_IN_ADDRESS         ;
#endif

  delete _Execution_unit_to_Write_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
