#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_two_level_branch_predictor_two_level_branch_predictor_glue_Two_Level_Branch_Predictor_Glue_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_two_level_branch_predictor_two_level_branch_predictor_glue_Two_Level_Branch_Predictor_Glue_h

/*
 * $Id: Two_Level_Branch_Predictor_Glue.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Statistics.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Component.h"

using namespace std;

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {


  class Two_Level_Branch_Predictor_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string     _name;

  protected : const Parameters _param;
//#ifdef STATISTICS
//protected : const morpheo::behavioural::Parameters_Statistics _param_statistics;
//#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK                      ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET                     ;

  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_BHT_ACK            ;
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_PHT_ACK            ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK                ;
					   
  public    : SC_IN (Taddress_t)           **  in_PREDICT_ADDRESS            ;
  public    : SC_IN (Tbht_history_t)       **  in_PREDICT_BHT_HISTORY        ;
  public    : SC_OUT(Taddress_t)           ** out_PREDICT_BHT_ADDRESS        ;
  public    : SC_OUT(Taddress_t)           ** out_PREDICT_PHT_ADDRESS        ;
					   
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_BHT_ACK    ;
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_PHT_ACK    ;
  public    : SC_OUT(Tcontrol_t)           ** out_BRANCH_COMPLETE_ACK        ;
					   
  public    : SC_IN (Taddress_t)           **  in_BRANCH_COMPLETE_ADDRESS    ;
  public    : SC_IN (Tbht_history_t)       **  in_BRANCH_COMPLETE_BHT_HISTORY;
  public    : SC_OUT(Taddress_t)           ** out_BRANCH_COMPLETE_BHT_ADDRESS;
  public    : SC_OUT(Taddress_t)           ** out_BRANCH_COMPLETE_PHT_ADDRESS;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Two_Level_Branch_Predictor_Glue);
#endif
  public  :          Two_Level_Branch_Predictor_Glue              (
#ifdef SYSTEMC
								   sc_module_name                              name,
#else					       
								   string                                      name,
#endif					       
#ifdef STATISTICS
								   morpheo::behavioural::Parameters_Statistics param_statistics,
#endif
								   Parameters                                  param );
					       
  public  :          Two_Level_Branch_Predictor_Glue              (Parameters param );
  public  :          ~Two_Level_Branch_Predictor_Glue             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void     transition                            (void);
#endif						           
  public  : void     genMealy_predict_ack                  (void);
  public  : void     genMealy_predict_bht_address          (void);
  public  : void     genMealy_predict_pht_address          (void);
  public  : void     genMealy_branch_complete_ack          (void);
  public  : void     genMealy_branch_complete_bht_address  (void);
  public  : void     genMealy_branch_complete_pht_address  (void);
#endif					       

#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_transition (void);
#endif
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction


}; // end namespace behavioural
}; // end namespace morpheo              

#endif
