/*
 * $Id: Return_Address_Stack_deallocation.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Return_Address_Stack.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace return_address_stack {


#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::deallocation"
  void Return_Address_Stack::deallocation (void)
  {
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");

    if (_usage & USE_SYSTEMC)
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

	delete []  in_PREDICT_VAL          ;
	delete [] out_PREDICT_ACK          ;
	if (_param->_have_port_context_id)
	delete []  in_PREDICT_CONTEXT_ID   ; 
	delete [] out_PREDICT_HIT          ; 
	delete []  in_PREDICT_PUSH         ;
	delete []  in_PREDICT_ADDRESS_PUSH ;
	delete [] out_PREDICT_ADDRESS_POP  ;
	delete [] out_PREDICT_INDEX        ;
	delete []  in_DECOD_VAL            ;
	delete [] out_DECOD_ACK            ;
	delete []  in_DECOD_PUSH           ;
	if (_param->_have_port_context_id)
	delete []  in_DECOD_CONTEXT_ID     ;
	delete [] out_DECOD_HIT            ;
	delete []  in_DECOD_ADDRESS_PUSH   ;
	delete [] out_DECOD_ADDRESS_POP    ;
	delete [] out_DECOD_INDEX          ;
	delete []  in_DECOD_MISS_PREDICTION;
	delete []  in_UPDATE_VAL           ;
	delete [] out_UPDATE_ACK           ;
	if (_param->_have_port_context_id)
	delete []  in_UPDATE_CONTEXT_ID    ;
	delete []  in_UPDATE_PUSH          ;
	delete []  in_UPDATE_INDEX         ;
	delete []  in_UPDATE_ADDRESS       ;
	delete []  in_UPDATE_MISS_PREDICTION;
	delete []  in_UPDATE_PREDICTION_IFETCH;
      }

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    delete [] reg_stack;
    delete [] reg_TOP;
    delete [] reg_BOTTOM;
    delete [] reg_NB_ELT;
    delete [] reg_PREDICT_TOP;
    delete [] reg_PREDICT_BOTTOM;
    delete [] reg_PREDICT_NB_ELT;
    
    delete [] internal_PREDICT_ACK;
    delete [] internal_PREDICT_HIT;
    delete [] internal_DECOD_ACK;
    delete [] internal_DECOD_HIT;
    delete [] internal_UPDATE_ACK;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");
  };

}; // end namespace return_address_stack
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
