#include "../include/Sim2OS.h"

namespace environment {
namespace sim2os {

  void * Sim2OS::service_read (void)
  {
    if (have_all_arguments(3) == false)
      {
	std::cerr << "<" << name << "> Usage : ssize_t read(int fd, void *buf, size_t count);" << std::endl;
	return NULL;
      }
    
    int     fd       = (int)     arguments[1];
    void *  buf      = (void *)  convert_address(arguments[2]);
    ssize_t count    = (ssize_t) arguments[3];
    void *  result   = (void *)  read(fd,buf,count);
    
    std::cout << "\n\t***** service : read          *****"        << std::endl;
    std::cout << "\tfd        : " <<             (unsigned int) fd     << std::endl;
    std::cout << "\tbuf       : " << std::hex << (unsigned int) buf    << std::endl;
  //std::cout << "\tbuf       : " << std::dec << (char *)       buf    << std::endl;
    std::cout << "\tcount     : " << std::dec << (unsigned int) count  << std::endl;
    std::cout << "\tresult    : " <<             (unsigned int) result << std::endl;
    std::cout << "\terrno     : " <<             (unsigned int) error  << std::endl;
    
    error = errno;
    
    return result;
  }

};
};
