#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_Parameters_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_Parameters_h

/*
 * $Id: Parameters.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include <math.h>

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t            _size_write_queue             ;
  public : const uint32_t            _size_execute_queue           ;
  public : const uint32_t            _nb_context                   ;
  public : const uint32_t            _nb_front_end                 ;
  public : const uint32_t            _nb_ooo_engine                ;
  public : const uint32_t            _nb_packet                    ;
  public : const uint32_t            _size_general_data            ;
  public : const uint32_t            _nb_general_register          ;
  public : const uint32_t            _size_special_data            ;
  public : const uint32_t            _nb_special_register          ;
  public : const uint32_t            _nb_bypass_write              ;

  public : const uint32_t            _nb_gpr_write                 ;
  public : const uint32_t            _nb_spr_write                 ;

  public : const uint32_t            _size_context_id              ;
  public : const uint32_t            _size_front_end_id            ;
  public : const uint32_t            _size_ooo_engine_id           ;
  public : const uint32_t            _size_packet_id               ;
  public : const uint32_t            _size_general_register        ;
  public : const uint32_t            _size_special_register        ;

  public : const bool                _have_component_execute_queue ;
  public : const bool                _have_port_context_id         ;
  public : const bool                _have_port_front_end_id       ;
  public : const bool                _have_port_ooo_engine_id      ;
  public : const bool                _have_port_packet_id          ;

  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue  ::Parameters * _param_write_queue;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::execute_queue::Parameters * _param_execute_queue;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t size_write_queue   ,
			uint32_t size_execute_queue ,
			uint32_t nb_context         ,
			uint32_t nb_front_end       ,
			uint32_t nb_ooo_engine      ,
			uint32_t nb_packet          ,
			uint32_t size_general_data  ,
			uint32_t nb_general_register,
			uint32_t size_special_data  ,
			uint32_t nb_special_register,
			uint32_t nb_bypass_write    );
  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        Parameters_test msg_error  (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::Parameters & x);
  };

}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
