/*
 * $Id: Write_unit_allocation.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/include/Write_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {



#undef  FUNCTION
#define FUNCTION "Write_unit::allocation"
  void Write_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Write_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Write_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

    // -----[ Interface "write_unit_in" ]--------------------------------    
     {
       ALLOC_INTERFACE ("write_unit_in", IN, WEST, "Input of write_unit");
       
       ALLOC_VALACK_IN ( in_WRITE_UNIT_IN_VAL,VAL);
       ALLOC_VALACK_OUT(out_WRITE_UNIT_IN_ACK,ACK);
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_CONTEXT_ID   ,"context_id"   ,Tcontext_t        ,_param->_size_context_id       );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_FRONT_END_ID ,"front_end_id" ,Tcontext_t        ,_param->_size_front_end_id     );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id    );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_PACKET_ID    ,"packet_id"    ,Tpacket_t         ,_param->_size_packet_id        );
//     ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_OPERATION    ,"operation"    ,Toperation_t      ,_param->_size_operation        );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_TYPE         ,"type"         ,Ttype_t           ,_param->_size_type             );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_WRITE_RD     ,"write_rd"     ,Tcontrol_t        ,1                              );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_NUM_REG_RD   ,"num_reg_rd"   ,Tgeneral_address_t,_param->_size_general_register );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_DATA_RD      ,"data_rd"      ,Tgeneral_data_t   ,_param->_size_general_data     );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_WRITE_RE     ,"write_re"     ,Tcontrol_t        ,1                              );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_NUM_REG_RE   ,"num_reg_re"   ,Tspecial_address_t,_param->_size_special_register );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_DATA_RE      ,"data_re"      ,Tspecial_data_t   ,_param->_size_special_data     );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_EXCEPTION    ,"exception"    ,Texception_t      ,_param->_size_exception        );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_NO_SEQUENCE  ,"no_sequence"  ,Tcontrol_t        ,1                              );
       ALLOC_SIGNAL_IN ( in_WRITE_UNIT_IN_ADDRESS      ,"address"      ,Tgeneral_data_t   ,_param->_size_general_data     );
     }

    // -----[ Interface "write_unit_out" ]-------------------------------
     {
       ALLOC_INTERFACE ("write_unit_out", OUT, EAST, "Output of write_unit");
       
       ALLOC_VALACK_OUT(out_WRITE_UNIT_OUT_VAL,VAL);
       ALLOC_VALACK_IN ( in_WRITE_UNIT_OUT_ACK,ACK);
       ALLOC_SIGNAL_OUT(out_WRITE_UNIT_OUT_CONTEXT_ID   ,"context_id"   ,Tcontext_t     ,_param->_size_context_id   );
       ALLOC_SIGNAL_OUT(out_WRITE_UNIT_OUT_FRONT_END_ID ,"front_end_id" ,Tcontext_t     ,_param->_size_front_end_id );
       ALLOC_SIGNAL_OUT(out_WRITE_UNIT_OUT_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t     ,_param->_size_ooo_engine_id);
       ALLOC_SIGNAL_OUT(out_WRITE_UNIT_OUT_PACKET_ID    ,"packet_id"    ,Tpacket_t      ,_param->_size_packet_id    );
//     ALLOC_SIGNAL_OUT(out_WRITE_UNIT_OUT_OPERATION    ,"operation"    ,Toperation_t   ,_param->_size_operation    );
//     ALLOC_SIGNAL_OUT(out_WRITE_UNIT_OUT_TYPE         ,"type"         ,Ttype_t        ,_param->_size_type         );
       ALLOC_SIGNAL_OUT(out_WRITE_UNIT_OUT_FLAGS        ,"flags"        ,Tspecial_data_t,_param->_size_special_data );
       ALLOC_SIGNAL_OUT(out_WRITE_UNIT_OUT_EXCEPTION    ,"exception"    ,Texception_t   ,_param->_size_exception    );
       ALLOC_SIGNAL_OUT(out_WRITE_UNIT_OUT_NO_SEQUENCE  ,"no_sequence"  ,Tcontrol_t     ,1                          );
       ALLOC_SIGNAL_OUT(out_WRITE_UNIT_OUT_ADDRESS      ,"address"      ,Tgeneral_data_t,_param->_size_general_data );
     }

    // -----[ Interface "gpr_write" ]-------------------------------------
     {
       ALLOC1_INTERFACE("gpr_write", OUT, SOUTH ,"Output of write_unit", _param->_nb_gpr_write);

       ALLOC1_VALACK_OUT(out_GPR_WRITE_VAL,VAL);
       ALLOC1_VALACK_IN ( in_GPR_WRITE_ACK,ACK);
       ALLOC1_SIGNAL_OUT(out_GPR_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id   );
       ALLOC1_SIGNAL_OUT(out_GPR_WRITE_NUM_REG      ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_OUT(out_GPR_WRITE_DATA         ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data    );
     }

    // -----[ Interface "spr_write" ]-------------------------------------
     {
       ALLOC1_INTERFACE("spr_write", OUT, SOUTH ,"Output of write_unit", _param->_nb_spr_write);

       ALLOC1_VALACK_OUT(out_SPR_WRITE_VAL,VAL);
       ALLOC1_VALACK_IN ( in_SPR_WRITE_ACK,ACK);
       ALLOC1_SIGNAL_OUT(out_SPR_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id   );
       ALLOC1_SIGNAL_OUT(out_SPR_WRITE_NUM_REG      ,"num_reg"      ,Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_OUT(out_SPR_WRITE_DATA         ,"data"         ,Tspecial_data_t   ,_param->_size_special_data    );
     }

    // -----[ Interface "bypass_write" ]----------------------------------
     {
       ALLOC1_INTERFACE("bypass_write", OUT, NORTH ,"Output of internal write_unit", _param->_nb_bypass_write);
       
       ALLOC1_SIGNAL_OUT(out_BYPASS_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id   );
       ALLOC1_SIGNAL_OUT(out_BYPASS_WRITE_GPR_VAL      ,"gpr_val"      ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_OUT(out_BYPASS_WRITE_GPR_NUM_REG  ,"gpr_num_reg"  ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_OUT(out_BYPASS_WRITE_GPR_DATA     ,"gpr_data"     ,Tgeneral_data_t   ,_param->_size_general_data    );
       ALLOC1_SIGNAL_OUT(out_BYPASS_WRITE_SPR_VAL      ,"spr_val"      ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_OUT(out_BYPASS_WRITE_SPR_NUM_REG  ,"spr_num_reg"  ,Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_OUT(out_BYPASS_WRITE_SPR_DATA     ,"spr_data"     ,Tspecial_data_t   ,_param->_size_special_data    );
     }


    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

     std::string name;

     {
       name = _name+"_write_queue";
       
       component_write_queue  = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Write_queue 
	 (name.c_str()
#ifdef STATISTICS
	  ,param_statistics
#endif
	  ,_param->_param_write_queue
	  ,_usage);
       
       _component->set_component (component_write_queue->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }

     if (_param->_have_component_execute_queue)
     {
       name = _name+"_execute_queue";
       
       component_execute_queue  = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::execute_queue::Execute_queue 
	 (name.c_str()
#ifdef STATISTICS
	  ,param_statistics
#endif
	  ,_param->_param_execute_queue
	  ,_usage);
       
       _component->set_component (component_execute_queue->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }

    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
     {
       name = _name+"_write_queue";
       std::cout << "Instance : " << name << std::endl;
	
#ifdef POSITION
       _component->interface_map (name ,"",
				  _name,"");
#endif

       _component->port_map(name,"in_CLOCK" , _name, "in_CLOCK");
       _component->port_map(name,"in_NRESET", _name, "in_NRESET");


#ifdef POSITION
       _component->interface_map (name ,"write_queue_in",
				  _name,"write_unit_in");
#endif

       _component->port_map(name, "in_WRITE_QUEUE_IN_VAL"          , _name, "in_WRITE_UNIT_IN_VAL"          );
       _component->port_map(name,"out_WRITE_QUEUE_IN_ACK"          , _name,"out_WRITE_UNIT_IN_ACK"          );
       if (_param->_have_port_context_id)
       _component->port_map(name, "in_WRITE_QUEUE_IN_CONTEXT_ID"   , _name, "in_WRITE_UNIT_IN_CONTEXT_ID"   );
       if (_param->_have_port_front_end_id)
       _component->port_map(name, "in_WRITE_QUEUE_IN_FRONT_END_ID" , _name, "in_WRITE_UNIT_IN_FRONT_END_ID" );
       if (_param->_have_port_ooo_engine_id)
       _component->port_map(name, "in_WRITE_QUEUE_IN_OOO_ENGINE_ID", _name, "in_WRITE_UNIT_IN_OOO_ENGINE_ID");
       if (_param->_have_port_packet_id)
       _component->port_map(name, "in_WRITE_QUEUE_IN_PACKET_ID"    , _name, "in_WRITE_UNIT_IN_PACKET_ID"    );
     //_component->port_map(name, "in_WRITE_QUEUE_IN_OPERATION"    , _name, "in_WRITE_UNIT_IN_OPERATION"    );
       _component->port_map(name, "in_WRITE_QUEUE_IN_TYPE"         , _name, "in_WRITE_UNIT_IN_TYPE"         );
       _component->port_map(name, "in_WRITE_QUEUE_IN_WRITE_RD"     , _name, "in_WRITE_UNIT_IN_WRITE_RD"     );
       _component->port_map(name, "in_WRITE_QUEUE_IN_NUM_REG_RD"   , _name, "in_WRITE_UNIT_IN_NUM_REG_RD"   );
       _component->port_map(name, "in_WRITE_QUEUE_IN_DATA_RD"      , _name, "in_WRITE_UNIT_IN_DATA_RD"      );
       _component->port_map(name, "in_WRITE_QUEUE_IN_WRITE_RE"     , _name, "in_WRITE_UNIT_IN_WRITE_RE"     );
       _component->port_map(name, "in_WRITE_QUEUE_IN_NUM_REG_RE"   , _name, "in_WRITE_UNIT_IN_NUM_REG_RE"   );
       _component->port_map(name, "in_WRITE_QUEUE_IN_DATA_RE"      , _name, "in_WRITE_UNIT_IN_DATA_RE"      );
       _component->port_map(name, "in_WRITE_QUEUE_IN_EXCEPTION"    , _name, "in_WRITE_UNIT_IN_EXCEPTION"    );
       _component->port_map(name, "in_WRITE_QUEUE_IN_NO_SEQUENCE"  , _name, "in_WRITE_UNIT_IN_NO_SEQUENCE"  );
       _component->port_map(name, "in_WRITE_QUEUE_IN_ADDRESS"      , _name, "in_WRITE_UNIT_IN_ADDRESS"      );


       if (_param->_have_component_execute_queue)
	 {
#ifdef POSITION
	   _component->interface_map (name ,"write_queue_out",
				      _name+"_execute_queue", "execute_queue_in");
#endif

	   _component->port_map(name,"out_WRITE_QUEUE_OUT_VAL"          , _name+"_execute_queue", "in_EXECUTE_QUEUE_IN_VAL"          );
	   _component->port_map(name, "in_WRITE_QUEUE_OUT_ACK"          , _name+"_execute_queue","out_EXECUTE_QUEUE_IN_ACK"          );
	   if (_param->_have_port_context_id)
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_CONTEXT_ID"   , _name+"_execute_queue", "in_EXECUTE_QUEUE_IN_CONTEXT_ID"   );
	   if (_param->_have_port_front_end_id)
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_FRONT_END_ID" , _name+"_execute_queue", "in_EXECUTE_QUEUE_IN_FRONT_END_ID" );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_OOO_ENGINE_ID", _name+"_execute_queue", "in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID");
	   if (_param->_have_port_packet_id)
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_PACKET_ID"    , _name+"_execute_queue", "in_EXECUTE_QUEUE_IN_PACKET_ID"    );
	 //_component->port_map(name,"out_WRITE_QUEUE_OUT_OPERATION"    , _name+"_execute_queue", "in_EXECUTE_QUEUE_IN_OPERATION"    );
	 //_component->port_map(name,"out_WRITE_QUEUE_OUT_TYPE"         , _name+"_execute_queue", "in_EXECUTE_QUEUE_IN_TYPE"         );
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_FLAGS"        , _name+"_execute_queue", "in_EXECUTE_QUEUE_IN_FLAGS"        );
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_EXCEPTION"    , _name+"_execute_queue", "in_EXECUTE_QUEUE_IN_EXCEPTION"    );
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_NO_SEQUENCE"  , _name+"_execute_queue", "in_EXECUTE_QUEUE_IN_NO_SEQUENCE"  );
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_ADDRESS"      , _name+"_execute_queue", "in_EXECUTE_QUEUE_IN_ADDRESS"      );
	 }
       else
	 {
#ifdef POSITION
	   _component->interface_map (name ,"write_queue_out",
				      _name,"write_unit_out");
#endif

	   _component->port_map(name,"out_WRITE_QUEUE_OUT_VAL"          , _name,"out_WRITE_UNIT_OUT_VAL"          );
	   _component->port_map(name, "in_WRITE_QUEUE_OUT_ACK"          , _name, "in_WRITE_UNIT_OUT_ACK"          );
	   if (_param->_have_port_context_id)
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_CONTEXT_ID"   , _name,"out_WRITE_UNIT_OUT_CONTEXT_ID"   );
	   if (_param->_have_port_front_end_id)
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_FRONT_END_ID" , _name,"out_WRITE_UNIT_OUT_FRONT_END_ID" );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_OOO_ENGINE_ID", _name,"out_WRITE_UNIT_OUT_OOO_ENGINE_ID");
	   if (_param->_have_port_packet_id)
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_PACKET_ID"    , _name,"out_WRITE_UNIT_OUT_PACKET_ID"    );
	 //_component->port_map(name,"out_WRITE_QUEUE_OUT_OPERATION"    , _name,"out_WRITE_UNIT_OUT_OPERATION"    );
	 //_component->port_map(name,"out_WRITE_QUEUE_OUT_TYPE"         , _name,"out_WRITE_UNIT_OUT_TYPE"         );
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_FLAGS"        , _name,"out_WRITE_UNIT_OUT_FLAGS"        );
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_EXCEPTION"    , _name,"out_WRITE_UNIT_OUT_EXCEPTION"    );
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_NO_SEQUENCE"  , _name,"out_WRITE_UNIT_OUT_NO_SEQUENCE"  );
	   _component->port_map(name,"out_WRITE_QUEUE_OUT_ADDRESS"      , _name,"out_WRITE_UNIT_OUT_ADDRESS"      );
	 }	 

       for (uint32_t i=0; i<_param->_nb_gpr_write; i++)
	 {
#ifdef POSITION
	   _component->interface_map (name ,"gpr_write_"+toString(i),
				      _name,"gpr_write_"+toString(i));
#endif	   
	   
	   _component->port_map(name,"out_GPR_WRITE_"+toString(i)+"_VAL"          ,_name,"out_GPR_WRITE_"+toString(i)+"_VAL"          );
	   _component->port_map(name, "in_GPR_WRITE_"+toString(i)+"_ACK"          ,_name, "in_GPR_WRITE_"+toString(i)+"_ACK"          );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name,"out_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID",_name,"out_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID");
	   _component->port_map(name,"out_GPR_WRITE_"+toString(i)+"_NUM_REG"      ,_name,"out_GPR_WRITE_"+toString(i)+"_NUM_REG"      );
	   _component->port_map(name,"out_GPR_WRITE_"+toString(i)+"_DATA"         ,_name,"out_GPR_WRITE_"+toString(i)+"_DATA"         );
	 }

       for (uint32_t i=0; i<_param->_nb_spr_write; i++)
	 {
#ifdef POSITION
	   _component->interface_map (name ,"spr_write_"+toString(i),
				      _name,"spr_write_"+toString(i));
#endif	   
	   
	   _component->port_map(name,"out_SPR_WRITE_"+toString(i)+"_VAL"          ,_name,"out_SPR_WRITE_"+toString(i)+"_VAL"          );
	   _component->port_map(name, "in_SPR_WRITE_"+toString(i)+"_ACK"          ,_name, "in_SPR_WRITE_"+toString(i)+"_ACK"          );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name,"out_SPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID",_name,"out_SPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID");
	   _component->port_map(name,"out_SPR_WRITE_"+toString(i)+"_NUM_REG"      ,_name,"out_SPR_WRITE_"+toString(i)+"_NUM_REG"      );
	   _component->port_map(name,"out_SPR_WRITE_"+toString(i)+"_DATA"         ,_name,"out_SPR_WRITE_"+toString(i)+"_DATA"         );
	 }


       for (uint32_t i=0; i<_param->_nb_bypass_write; i++)
	 {
#ifdef POSITION
	   _component->interface_map (name ,"bypass_write_"+toString(i),
				      _name,"bypass_write_"+toString(i));
#endif	   

	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name,"out_BYPASS_WRITE_"+toString(i)+"_OOO_ENGINE_ID",_name,"out_BYPASS_WRITE_"+toString(i)+"_OOO_ENGINE_ID");
	   _component->port_map(name,"out_BYPASS_WRITE_"+toString(i)+"_GPR_VAL"      ,_name,"out_BYPASS_WRITE_"+toString(i)+"_GPR_VAL"      );
	   _component->port_map(name,"out_BYPASS_WRITE_"+toString(i)+"_GPR_NUM_REG"  ,_name,"out_BYPASS_WRITE_"+toString(i)+"_GPR_NUM_REG"  );
	   _component->port_map(name,"out_BYPASS_WRITE_"+toString(i)+"_GPR_DATA"     ,_name,"out_BYPASS_WRITE_"+toString(i)+"_GPR_DATA"     );
	   _component->port_map(name,"out_BYPASS_WRITE_"+toString(i)+"_SPR_VAL"      ,_name,"out_BYPASS_WRITE_"+toString(i)+"_SPR_VAL"      );
	   _component->port_map(name,"out_BYPASS_WRITE_"+toString(i)+"_SPR_NUM_REG"  ,_name,"out_BYPASS_WRITE_"+toString(i)+"_SPR_NUM_REG"  );
	   _component->port_map(name,"out_BYPASS_WRITE_"+toString(i)+"_SPR_DATA"     ,_name,"out_BYPASS_WRITE_"+toString(i)+"_SPR_DATA"     );
	 }
     }

     if (_param->_have_component_execute_queue)
       {
	 name = _name+"_execute_queue";
	 std::cout << "Instance : " << name << std::endl;
	 
#ifdef POSITION
	 _component->interface_map (name ,"",
				    _name,"");
#endif
	 
	 _component->port_map(name,"in_CLOCK" , _name, "in_CLOCK");
	 _component->port_map(name,"in_NRESET", _name, "in_NRESET");
	 

#ifdef POSITION
	 _component->interface_map (name ,"execute_queue_in",
				    _name+"_write_queue","write_queue_in");
#endif

         _component->port_map(name, "in_EXECUTE_QUEUE_IN_VAL"          , _name+"_write_queue","out_WRITE_QUEUE_OUT_VAL"          );
         _component->port_map(name,"out_EXECUTE_QUEUE_IN_ACK"          , _name+"_write_queue", "in_WRITE_QUEUE_OUT_ACK"          );
         if (_param->_have_port_context_id)
         _component->port_map(name, "in_EXECUTE_QUEUE_IN_CONTEXT_ID"   , _name+"_write_queue","out_WRITE_QUEUE_OUT_CONTEXT_ID"   );
         if (_param->_have_port_front_end_id)
         _component->port_map(name, "in_EXECUTE_QUEUE_IN_FRONT_END_ID" , _name+"_write_queue","out_WRITE_QUEUE_OUT_FRONT_END_ID" );
         if (_param->_have_port_ooo_engine_id)
         _component->port_map(name, "in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID", _name+"_write_queue","out_WRITE_QUEUE_OUT_OOO_ENGINE_ID");
         if (_param->_have_port_packet_id)
         _component->port_map(name, "in_EXECUTE_QUEUE_IN_PACKET_ID"    , _name+"_write_queue","out_WRITE_QUEUE_OUT_PACKET_ID"    );
       //_component->port_map(name, "in_EXECUTE_QUEUE_IN_OPERATION"    , _name+"_write_queue","out_WRITE_QUEUE_OUT_OPERATION"    );
       //_component->port_map(name, "in_EXECUTE_QUEUE_IN_TYPE"         , _name+"_write_queue","out_WRITE_QUEUE_OUT_TYPE"         );
         _component->port_map(name, "in_EXECUTE_QUEUE_IN_FLAGS"        , _name+"_write_queue","out_WRITE_QUEUE_OUT_FLAGS"        );
         _component->port_map(name, "in_EXECUTE_QUEUE_IN_EXCEPTION"    , _name+"_write_queue","out_WRITE_QUEUE_OUT_EXCEPTION"    );
         _component->port_map(name, "in_EXECUTE_QUEUE_IN_NO_SEQUENCE"  , _name+"_write_queue","out_WRITE_QUEUE_OUT_NO_SEQUENCE"  );
         _component->port_map(name, "in_EXECUTE_QUEUE_IN_ADDRESS"      , _name+"_write_queue","out_WRITE_QUEUE_OUT_ADDRESS"      );

#ifdef POSITION
	   _component->interface_map (name ,"execute_queue_out",
				      _name,"write_unit_out");
#endif

	   _component->port_map(name,"out_EXECUTE_QUEUE_OUT_VAL"          , _name,"out_WRITE_UNIT_OUT_VAL"          );
	   _component->port_map(name, "in_EXECUTE_QUEUE_OUT_ACK"          , _name, "in_WRITE_UNIT_OUT_ACK"          );
	   if (_param->_have_port_context_id)
	   _component->port_map(name,"out_EXECUTE_QUEUE_OUT_CONTEXT_ID"   , _name,"out_WRITE_UNIT_OUT_CONTEXT_ID"   );
	   if (_param->_have_port_front_end_id)
	   _component->port_map(name,"out_EXECUTE_QUEUE_OUT_FRONT_END_ID" , _name,"out_WRITE_UNIT_OUT_FRONT_END_ID" );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name,"out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID", _name,"out_WRITE_UNIT_OUT_OOO_ENGINE_ID");
	   if (_param->_have_port_packet_id)
	   _component->port_map(name,"out_EXECUTE_QUEUE_OUT_PACKET_ID"    , _name,"out_WRITE_UNIT_OUT_PACKET_ID"    );
	 //_component->port_map(name,"out_EXECUTE_QUEUE_OUT_OPERATION"    , _name,"out_WRITE_UNIT_OUT_OPERATION"    );
	 //_component->port_map(name,"out_EXECUTE_QUEUE_OUT_TYPE"         , _name,"out_WRITE_UNIT_OUT_TYPE"         );
	   _component->port_map(name,"out_EXECUTE_QUEUE_OUT_FLAGS"        , _name,"out_WRITE_UNIT_OUT_FLAGS"        );
	   _component->port_map(name,"out_EXECUTE_QUEUE_OUT_EXCEPTION"    , _name,"out_WRITE_UNIT_OUT_EXCEPTION"    );
	   _component->port_map(name,"out_EXECUTE_QUEUE_OUT_NO_SEQUENCE"  , _name,"out_WRITE_UNIT_OUT_NO_SEQUENCE"  );
	   _component->port_map(name,"out_EXECUTE_QUEUE_OUT_ADDRESS"      , _name,"out_WRITE_UNIT_OUT_ADDRESS"      );
       }

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Write_unit,FUNCTION,"End");
  };

}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
