/*
 * $Id: Parameters_msg_error.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace execution_unit_to_write_unit {


#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

    Parameters_test test("Execution_unit_to_Write_unit");

    for (uint32_t i=0; i<_nb_execute_unit; i++)
      {
	uint32_t j;
	for (j=0; j<_nb_write_unit; j++)
	  if (_table_routing [i][j] == true)
	    break;

	if (j == _nb_write_unit)
	  test.error("The execute_unit ["+toString(i)+"] is link with none write_unit.");
      }	  

    for (uint32_t i=0; i<_nb_write_unit; i++)
      {
	uint32_t j;
	for (j=0; j<_nb_thread; j++)
	  if (_table_thread [i][j] == true)
	    break;

	if (j == _nb_thread)
	  test.error("The write_unit ["+toString(i)+"] have none source's thread.");
      }	  

    if ( (_priority != PRIORITY_STATIC     ) and
	 (_priority != PRIORITY_ROUND_ROBIN))
      test.error("Unsupported priority scheme. It must be Static or Round Robin.");

    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");

    return test;
  };

}; // end namespace execution_unit_to_write_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
