/*
 * $Id: Register_unit_Glue_allocation.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/Register_unit_Glue/include/Register_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {
namespace register_unit_glue {



#undef  FUNCTION
#define FUNCTION "Register_unit_Glue::allocation"
  void Register_unit_Glue::allocation (void)
  {
    log_printf(FUNC,Register_unit_Glue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Register_unit_Glue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
						       ,IN
						       ,SOUTH,
						       "Generalist interface"
#endif
						       );
    
     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_NO);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_NO);
    out_CONST_0      = interface->set_signal_out <Tcontrol_t> ("const_0",1);
    out_CONST_1      = interface->set_signal_out <Tcontrol_t> ("const_1",1);

    // ~~~~~[Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   in_GPR_READ_VAL               = new SC_IN (Tcontrol_t        )   * [_param->_nb_gpr_read];
  out_GPR_READ_ACK               = new SC_OUT(Tcontrol_t        )   * [_param->_nb_gpr_read];
  if (_param->_have_port_ooo_engine_id == true)
   in_GPR_READ_OOO_ENGINE_ID     = new SC_IN (Tcontext_t        )   * [_param->_nb_gpr_read];
  out_GPR_READ_DATA              = new SC_OUT(Tgeneral_data_t   )   * [_param->_nb_gpr_read];
  out_GPR_READ_DATA_VAL          = new SC_OUT(Tcontrol_t        )   * [_param->_nb_gpr_read];

  out_GPR_READ_REGISTERFILE_VAL  = new SC_OUT(Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_GPR_READ_REGISTERFILE_ACK  = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_GPR_READ_REGISTERFILE_DATA = new SC_IN (Tgeneral_data_t   )  ** [_param->_nb_ooo_engine];

  out_GPR_READ_STATUS_VAL        = new SC_OUT(Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_GPR_READ_STATUS_ACK        = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_GPR_READ_STATUS_DATA_VAL   = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];

   for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
     {
       out_GPR_READ_REGISTERFILE_VAL  [i] = new SC_OUT(Tcontrol_t        )  * [_param->_nb_gpr_read];
        in_GPR_READ_REGISTERFILE_ACK  [i] = new SC_IN (Tcontrol_t        )  * [_param->_nb_gpr_read];
        in_GPR_READ_REGISTERFILE_DATA [i] = new SC_IN (Tgeneral_data_t   )  * [_param->_nb_gpr_read];

       out_GPR_READ_STATUS_VAL        [i] = new SC_OUT(Tcontrol_t        )  * [_param->_nb_gpr_read];
        in_GPR_READ_STATUS_ACK        [i] = new SC_IN (Tcontrol_t        )  * [_param->_nb_gpr_read];
        in_GPR_READ_STATUS_DATA_VAL   [i] = new SC_IN (Tcontrol_t        )  * [_param->_nb_gpr_read];
     }

   for (uint32_t j=0; j<_param->_nb_gpr_read; j++)
     {
       Interface_fifo * interface = _interfaces->set_interface("gpr_read_"+toString(j)
#ifdef POSITION
							  ,IN
							  ,NORTH,
							  "Interface to read generalist register"
#endif
							  );
      
        in_GPR_READ_VAL           [j] = interface->set_signal_valack_in  (VAL);
       out_GPR_READ_ACK           [j] = interface->set_signal_valack_out (ACK);
       if (_param->_have_port_ooo_engine_id == true)
        in_GPR_READ_OOO_ENGINE_ID [j] = interface->set_signal_in <Tcontext_t     > ("ooo_engine_id", log2(_param->_nb_ooo_engine));
       out_GPR_READ_DATA          [j] = interface->set_signal_out<Tgeneral_data_t> ("data"         , _param->_size_general_data);
       out_GPR_READ_DATA_VAL      [j] = interface->set_signal_out<Tcontrol_t     > ("data_val"     , 1);

       for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	 {
	   {
	     Interface_fifo * interface = _interfaces->set_interface("gpr_read_registerfile_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								,IN
								,NORTH,
								"Interface to read generalist register - from/to register file"
#endif
								);
	     
	     out_GPR_READ_REGISTERFILE_VAL  [i][j] = interface->set_signal_valack_out (VAL);
	      in_GPR_READ_REGISTERFILE_ACK  [i][j] = interface->set_signal_valack_in  (ACK);
	      in_GPR_READ_REGISTERFILE_DATA [i][j] = interface->set_signal_in <Tgeneral_data_t> ("data"         , _param->_size_general_data);
	   }
	   {
	     Interface_fifo * interface = _interfaces->set_interface("gpr_read_status_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								,IN
								,NORTH,
								"Interface to read generalist register - from/to status"
#endif
								);


	     out_GPR_READ_STATUS_VAL        [i][j] = interface->set_signal_valack_out (VAL);
	      in_GPR_READ_STATUS_ACK        [i][j] = interface->set_signal_valack_in  (ACK);
	      in_GPR_READ_STATUS_DATA_VAL   [i][j] = interface->set_signal_in <Tcontrol_t     > ("data_val"     , 1);
	   }
	 }
     }

    // ~~~~~[Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   in_SPR_READ_VAL               = new SC_IN (Tcontrol_t        )   * [_param->_nb_spr_read];
  out_SPR_READ_ACK               = new SC_OUT(Tcontrol_t        )   * [_param->_nb_spr_read];
  if (_param->_have_port_ooo_engine_id == true)
   in_SPR_READ_OOO_ENGINE_ID     = new SC_IN (Tcontext_t        )   * [_param->_nb_spr_read];
  out_SPR_READ_DATA              = new SC_OUT(Tspecial_data_t   )   * [_param->_nb_spr_read];
  out_SPR_READ_DATA_VAL          = new SC_OUT(Tcontrol_t        )   * [_param->_nb_spr_read];

  out_SPR_READ_REGISTERFILE_VAL  = new SC_OUT(Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_SPR_READ_REGISTERFILE_ACK  = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_SPR_READ_REGISTERFILE_DATA = new SC_IN (Tspecial_data_t   )  ** [_param->_nb_ooo_engine];

  out_SPR_READ_STATUS_VAL        = new SC_OUT(Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_SPR_READ_STATUS_ACK        = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_SPR_READ_STATUS_DATA_VAL   = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];

   for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
     {
       out_SPR_READ_REGISTERFILE_VAL  [i] = new SC_OUT(Tcontrol_t        )  * [_param->_nb_spr_read];
        in_SPR_READ_REGISTERFILE_ACK  [i] = new SC_IN (Tcontrol_t        )  * [_param->_nb_spr_read];
        in_SPR_READ_REGISTERFILE_DATA [i] = new SC_IN (Tspecial_data_t   )  * [_param->_nb_spr_read];

       out_SPR_READ_STATUS_VAL        [i] = new SC_OUT(Tcontrol_t        )  * [_param->_nb_spr_read];
        in_SPR_READ_STATUS_ACK        [i] = new SC_IN (Tcontrol_t        )  * [_param->_nb_spr_read];
        in_SPR_READ_STATUS_DATA_VAL   [i] = new SC_IN (Tcontrol_t        )  * [_param->_nb_spr_read];
     }

   for (uint32_t j=0; j<_param->_nb_spr_read; j++)
     {
       Interface_fifo * interface = _interfaces->set_interface("spr_read_"+toString(j)
#ifdef POSITION
							  ,IN
							  ,NORTH,
							  "Interface to read special register"
#endif
							  );
      
        in_SPR_READ_VAL           [j] = interface->set_signal_valack_in  (VAL);
       out_SPR_READ_ACK           [j] = interface->set_signal_valack_out (ACK);
       if (_param->_have_port_ooo_engine_id == true)
        in_SPR_READ_OOO_ENGINE_ID [j] = interface->set_signal_in <Tcontext_t     > ("ooo_engine_id", log2(_param->_nb_ooo_engine));
       out_SPR_READ_DATA          [j] = interface->set_signal_out<Tspecial_data_t> ("data"         , _param->_size_special_data);
       out_SPR_READ_DATA_VAL      [j] = interface->set_signal_out<Tcontrol_t     > ("data_val"     , 1);

       for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	 {
	   {
	     Interface_fifo * interface = _interfaces->set_interface("spr_read_registerfile_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								,IN
								,NORTH,
								"Interface to read special register - from/to register file"
#endif
								);
	     
	     out_SPR_READ_REGISTERFILE_VAL  [i][j] = interface->set_signal_valack_out (VAL);
	      in_SPR_READ_REGISTERFILE_ACK  [i][j] = interface->set_signal_valack_in  (ACK);
	      in_SPR_READ_REGISTERFILE_DATA [i][j] = interface->set_signal_in <Tspecial_data_t> ("data"         , _param->_size_special_data);
	   }
	   {
	     Interface_fifo * interface = _interfaces->set_interface("spr_read_status_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								,IN
								,NORTH,
								"Interface to read special register - from/to status"
#endif
								);


	     out_SPR_READ_STATUS_VAL        [i][j] = interface->set_signal_valack_out (VAL);
	      in_SPR_READ_STATUS_ACK        [i][j] = interface->set_signal_valack_in  (ACK);
	      in_SPR_READ_STATUS_DATA_VAL   [i][j] = interface->set_signal_in <Tcontrol_t     > ("data_val"     , 1);
	   }
	 }
     }

    // ~~~~~[Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   in_GPR_WRITE_VAL               = new SC_IN (Tcontrol_t        )   * [_param->_nb_gpr_write];
  out_GPR_WRITE_ACK               = new SC_OUT(Tcontrol_t        )   * [_param->_nb_gpr_write];
  if (_param->_have_port_ooo_engine_id == true) 
  in_GPR_WRITE_OOO_ENGINE_ID     = new SC_IN (Tcontext_t        )   * [_param->_nb_gpr_write];

  out_GPR_WRITE_REGISTERFILE_VAL  = new SC_OUT(Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_GPR_WRITE_REGISTERFILE_ACK  = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];

  out_GPR_WRITE_STATUS_VAL        = new SC_OUT(Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_GPR_WRITE_STATUS_ACK        = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];

   for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
     {
       out_GPR_WRITE_REGISTERFILE_VAL  [i] = new SC_OUT(Tcontrol_t        )  * [_param->_nb_gpr_write];
        in_GPR_WRITE_REGISTERFILE_ACK  [i] = new SC_IN (Tcontrol_t        )  * [_param->_nb_gpr_write];

       out_GPR_WRITE_STATUS_VAL        [i] = new SC_OUT(Tcontrol_t        )  * [_param->_nb_gpr_write];
        in_GPR_WRITE_STATUS_ACK        [i] = new SC_IN (Tcontrol_t        )  * [_param->_nb_gpr_write];
     }

   for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
     {
       Interface_fifo * interface = _interfaces->set_interface("gpr_write_"+toString(j)
#ifdef POSITION
							  ,IN
							  ,NORTH,
							  "Interface to write generalist register"
#endif
							  );
      
        in_GPR_WRITE_VAL           [j] = interface->set_signal_valack_in  (VAL);
       out_GPR_WRITE_ACK           [j] = interface->set_signal_valack_out (ACK);
       if (_param->_have_port_ooo_engine_id == true)
        in_GPR_WRITE_OOO_ENGINE_ID [j] = interface->set_signal_in <Tcontext_t     > ("ooo_engine_id", log2(_param->_nb_ooo_engine));

       for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	 {
	   {
	     Interface_fifo * interface = _interfaces->set_interface("gpr_write_registerfile_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								,IN
								,NORTH,
								"Interface to write generalist register - from/to register file"
#endif
								);
	     
	     out_GPR_WRITE_REGISTERFILE_VAL  [i][j] = interface->set_signal_valack_out (VAL);
	      in_GPR_WRITE_REGISTERFILE_ACK  [i][j] = interface->set_signal_valack_in  (ACK);
	   }
	   {
	     Interface_fifo * interface = _interfaces->set_interface("gpr_write_status_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								,IN
								,NORTH,
								"Interface to write generalist register - from/to status"
#endif
								);


	     out_GPR_WRITE_STATUS_VAL        [i][j] = interface->set_signal_valack_out (VAL);
	      in_GPR_WRITE_STATUS_ACK        [i][j] = interface->set_signal_valack_in  (ACK);
	   }
	 }
     }

    // ~~~~~[Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   in_SPR_WRITE_VAL               = new SC_IN (Tcontrol_t        )   * [_param->_nb_spr_write];
  out_SPR_WRITE_ACK               = new SC_OUT(Tcontrol_t        )   * [_param->_nb_spr_write];
  if (_param->_have_port_ooo_engine_id == true) 
   in_SPR_WRITE_OOO_ENGINE_ID     = new SC_IN (Tcontext_t        )   * [_param->_nb_spr_write];

  out_SPR_WRITE_REGISTERFILE_VAL  = new SC_OUT(Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_SPR_WRITE_REGISTERFILE_ACK  = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];

  out_SPR_WRITE_STATUS_VAL        = new SC_OUT(Tcontrol_t        )  ** [_param->_nb_ooo_engine];
   in_SPR_WRITE_STATUS_ACK        = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];

   for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
     {
       out_SPR_WRITE_REGISTERFILE_VAL  [i] = new SC_OUT(Tcontrol_t        )  * [_param->_nb_spr_write];
        in_SPR_WRITE_REGISTERFILE_ACK  [i] = new SC_IN (Tcontrol_t        )  * [_param->_nb_spr_write];

       out_SPR_WRITE_STATUS_VAL        [i] = new SC_OUT(Tcontrol_t        )  * [_param->_nb_spr_write];
        in_SPR_WRITE_STATUS_ACK        [i] = new SC_IN (Tcontrol_t        )  * [_param->_nb_spr_write];
     }

   for (uint32_t j=0; j<_param->_nb_spr_write; j++)
     {
       Interface_fifo * interface = _interfaces->set_interface("spr_write_"+toString(j)
#ifdef POSITION
							  ,IN
							  ,NORTH,
							  "Interface to write special register"
#endif
							  );
      
        in_SPR_WRITE_VAL           [j] = interface->set_signal_valack_in  (VAL);
       out_SPR_WRITE_ACK           [j] = interface->set_signal_valack_out (ACK);
       if (_param->_have_port_ooo_engine_id == true)
        in_SPR_WRITE_OOO_ENGINE_ID [j] = interface->set_signal_in <Tcontext_t     > ("ooo_engine_id", log2(_param->_nb_ooo_engine));

       for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	 {
	   {
	     Interface_fifo * interface = _interfaces->set_interface("spr_write_registerfile_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								,IN
								,NORTH,
								"Interface to write special register - from/to register file"
#endif
								);
	     
	     out_SPR_WRITE_REGISTERFILE_VAL  [i][j] = interface->set_signal_valack_out (VAL);
	      in_SPR_WRITE_REGISTERFILE_ACK  [i][j] = interface->set_signal_valack_in  (ACK);
	   }
	   {
	     Interface_fifo * interface = _interfaces->set_interface("spr_write_status_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								,IN
								,NORTH,
								"Interface to write special register - from/to status"
#endif
								);


	     out_SPR_WRITE_STATUS_VAL        [i][j] = interface->set_signal_valack_out (VAL);
	      in_SPR_WRITE_STATUS_ACK        [i][j] = interface->set_signal_valack_in  (ACK);
	   }
	 }
     }

   // ~~~~~[Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    in_INSERT_ROB_VAL                  = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
   out_INSERT_ROB_ACK                  = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_INSERT_ROB_RD_USE               = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_INSERT_ROB_RE_USE               = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
   out_INSERT_ROB_GPR_STATUS_VAL       = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_INSERT_ROB_GPR_STATUS_ACK       = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
   out_INSERT_ROB_SPR_STATUS_VAL       = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_INSERT_ROB_SPR_STATUS_ACK       = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];

    for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
      {
	uint32_t x=_param->_nb_inst_insert_rob [i];

	in_INSERT_ROB_VAL                  [i] = new SC_IN (Tcontrol_t) * [x];
       out_INSERT_ROB_ACK                  [i] = new SC_OUT(Tcontrol_t) * [x];
	in_INSERT_ROB_RD_USE               [i] = new SC_IN (Tcontrol_t) * [x];
	in_INSERT_ROB_RE_USE               [i] = new SC_IN (Tcontrol_t) * [x];
       out_INSERT_ROB_GPR_STATUS_VAL       [i] = new SC_OUT(Tcontrol_t) * [x];
	in_INSERT_ROB_GPR_STATUS_ACK       [i] = new SC_IN (Tcontrol_t) * [x];
       out_INSERT_ROB_SPR_STATUS_VAL       [i] = new SC_OUT(Tcontrol_t) * [x];
	in_INSERT_ROB_SPR_STATUS_ACK       [i] = new SC_IN (Tcontrol_t) * [x];

	for (uint32_t j=0; j<x; j++)
	  {
	    {
	      Interface_fifo * interface = _interfaces->set_interface("insert_rob_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								      ,IN
								      ,WEST
								      ,"Interface to update status (insert)"
#endif
								      );

	       in_INSERT_ROB_VAL                  [i][j] = interface->set_signal_valack_in (VAL);
	      out_INSERT_ROB_ACK                  [i][j] = interface->set_signal_valack_out(ACK);
	       in_INSERT_ROB_RD_USE               [i][j] = interface->set_signal_in <Tcontrol_t> ("rd_use", 1);
	       in_INSERT_ROB_RE_USE               [i][j] = interface->set_signal_in <Tcontrol_t> ("re_use", 1);
	    }
	    {
	      Interface_fifo * interface = _interfaces->set_interface("insert_rob_gpr_status_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								      ,IN
								      ,EAST
								      ,"Interface to update status (insert)"
#endif
								      );

	      out_INSERT_ROB_GPR_STATUS_VAL       [i][j] = interface->set_signal_valack_out(VAL);
	       in_INSERT_ROB_GPR_STATUS_ACK       [i][j] = interface->set_signal_valack_in (ACK);
	    }
	    {
	      Interface_fifo * interface = _interfaces->set_interface("insert_rob_spr_status_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								      ,IN
								      ,EAST
								      ,"Interface to update status (insert)"
#endif
								      );

	      out_INSERT_ROB_SPR_STATUS_VAL       [i][j] = interface->set_signal_valack_out(VAL);
	       in_INSERT_ROB_SPR_STATUS_ACK       [i][j] = interface->set_signal_valack_in (ACK);
	    }
	  }
      }

    // ~~~~~[Interface "retire_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    in_RETIRE_ROB_VAL                      = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
   out_RETIRE_ROB_ACK                      = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_RETIRE_ROB_RD_OLD_USE               = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_RETIRE_ROB_RD_NEW_USE               = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_RETIRE_ROB_RE_OLD_USE               = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_RETIRE_ROB_RE_NEW_USE               = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
   out_RETIRE_ROB_GPR_STATUS_OLD_VAL       = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
   out_RETIRE_ROB_GPR_STATUS_NEW_VAL       = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_RETIRE_ROB_GPR_STATUS_OLD_ACK       = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_RETIRE_ROB_GPR_STATUS_NEW_ACK       = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
   out_RETIRE_ROB_SPR_STATUS_OLD_VAL       = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
   out_RETIRE_ROB_SPR_STATUS_NEW_VAL       = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_RETIRE_ROB_SPR_STATUS_OLD_ACK       = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
    in_RETIRE_ROB_SPR_STATUS_NEW_ACK       = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];

    for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
      {
	uint32_t x=_param->_nb_inst_retire_rob [i];

	 in_RETIRE_ROB_VAL                      [i] = new SC_IN (Tcontrol_t) * [x];
	out_RETIRE_ROB_ACK                      [i] = new SC_OUT(Tcontrol_t) * [x];
	 in_RETIRE_ROB_RD_OLD_USE               [i] = new SC_IN (Tcontrol_t) * [x];
	 in_RETIRE_ROB_RD_NEW_USE               [i] = new SC_IN (Tcontrol_t) * [x];
	 in_RETIRE_ROB_RE_OLD_USE               [i] = new SC_IN (Tcontrol_t) * [x];
	 in_RETIRE_ROB_RE_NEW_USE               [i] = new SC_IN (Tcontrol_t) * [x];
	out_RETIRE_ROB_GPR_STATUS_OLD_VAL       [i] = new SC_OUT(Tcontrol_t) * [x];
	out_RETIRE_ROB_GPR_STATUS_NEW_VAL       [i] = new SC_OUT(Tcontrol_t) * [x];
	 in_RETIRE_ROB_GPR_STATUS_OLD_ACK       [i] = new SC_IN (Tcontrol_t) * [x];
	 in_RETIRE_ROB_GPR_STATUS_NEW_ACK       [i] = new SC_IN (Tcontrol_t) * [x];
	out_RETIRE_ROB_SPR_STATUS_OLD_VAL       [i] = new SC_OUT(Tcontrol_t) * [x];
	out_RETIRE_ROB_SPR_STATUS_NEW_VAL       [i] = new SC_OUT(Tcontrol_t) * [x];
	 in_RETIRE_ROB_SPR_STATUS_OLD_ACK       [i] = new SC_IN (Tcontrol_t) * [x];
	 in_RETIRE_ROB_SPR_STATUS_NEW_ACK       [i] = new SC_IN (Tcontrol_t) * [x];
    
	for (uint32_t j=0; j<x; j++)
	  {
	    {
	      Interface_fifo * interface = _interfaces->set_interface("retire_rob_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								      ,IN
								      ,WEST
								      ,"Interface to update status (retire)"
#endif
								      );

	       in_RETIRE_ROB_VAL                      [i][j] = interface->set_signal_valack_in (VAL);
	      out_RETIRE_ROB_ACK                      [i][j] = interface->set_signal_valack_out(ACK);
	       in_RETIRE_ROB_RD_OLD_USE               [i][j] = interface->set_signal_in <Tcontrol_t> ("rd_old_use", 1);
	       in_RETIRE_ROB_RD_NEW_USE               [i][j] = interface->set_signal_in <Tcontrol_t> ("rd_new_use", 1);
	       in_RETIRE_ROB_RE_OLD_USE               [i][j] = interface->set_signal_in <Tcontrol_t> ("re_old_use", 1);
	       in_RETIRE_ROB_RE_NEW_USE               [i][j] = interface->set_signal_in <Tcontrol_t> ("re_new_use", 1);
	    }
	    {
	      Interface_fifo * interface = _interfaces->set_interface("retire_rob_gpr_status_old_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								      ,IN
								      ,EAST
								      ,"Interface to update status (retire)"
#endif
								      );

	      out_RETIRE_ROB_GPR_STATUS_OLD_VAL [i][j] = interface->set_signal_valack_out(VAL);
	       in_RETIRE_ROB_GPR_STATUS_OLD_ACK [i][j] = interface->set_signal_valack_in (ACK);
	    }
	    {
	      Interface_fifo * interface = _interfaces->set_interface("retire_rob_gpr_status_new_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								      ,IN
								      ,EAST
								      ,"Interface to update status (retire)"
#endif
								      );

	      out_RETIRE_ROB_GPR_STATUS_NEW_VAL [i][j] = interface->set_signal_valack_out(VAL);
	       in_RETIRE_ROB_GPR_STATUS_NEW_ACK [i][j] = interface->set_signal_valack_in (ACK);
	    }
	    {
	      Interface_fifo * interface = _interfaces->set_interface("retire_rob_spr_status_old_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								      ,IN
								      ,EAST
								      ,"Interface to update status (retire)"
#endif
								      );

	      out_RETIRE_ROB_SPR_STATUS_OLD_VAL [i][j] = interface->set_signal_valack_out(VAL);
	       in_RETIRE_ROB_SPR_STATUS_OLD_ACK [i][j] = interface->set_signal_valack_in (ACK);
	    }
	    {
	      Interface_fifo * interface = _interfaces->set_interface("retire_rob_spr_status_new_"+toString(i)+"_"+toString(j)
#ifdef POSITION
								      ,IN
								      ,EAST
								      ,"Interface to update status (retire)"
#endif
								      );

	      out_RETIRE_ROB_SPR_STATUS_NEW_VAL [i][j] = interface->set_signal_valack_out(VAL);
	       in_RETIRE_ROB_SPR_STATUS_NEW_ACK [i][j] = interface->set_signal_valack_in (ACK);
	    }
	  }
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Register_unit_Glue,FUNCTION,"End");
  };

}; // end namespace register_unit_glue
}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
