/*
 * $Id: Parameters_msg_error.cpp 83 2008-05-09 18:00:21Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


#undef  FUNCTION
#define FUNCTION "Context_State::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(Context_State,FUNCTION);

    Parameters_test test ("Context_State");

    bool _is_link_decod_unit_from_context [_nb_decod_unit];
    for (uint32_t i=0; i<_nb_decod_unit; i++)
      _is_link_decod_unit_from_context [i] = false;
    for (uint32_t i=0; i<_nb_context; i++)
      {
	if (_link_context_to_decod_unit [i] < _nb_decod_unit)
	  _is_link_decod_unit_from_context [_link_context_to_decod_unit[i]] = true;
	else
	  test.error(toString(_("The context [%d] is linked with invalid decod_unit."),i));
      }

    for (uint32_t i=0; i<_nb_decod_unit; i++)
      if (_is_link_decod_unit_from_context [i] == false)
	test.error(toString(_("The decod_unit [%d] have none context as source."),i));

    bool _is_link_ooo_engine_from_decod_unit [_nb_ooo_engine];
    for (uint32_t i=0; i<_nb_ooo_engine; i++)
      _is_link_ooo_engine_from_decod_unit [i] = false;

    for (uint32_t i=0; i<_nb_decod_unit; i++)
      {
	if (_link_decod_unit_to_ooo_engine [i] < _nb_ooo_engine)
	  _is_link_ooo_engine_from_decod_unit [_link_decod_unit_to_ooo_engine[i]] = true;
	else
	  test.error(toString(_("The decod_unit [%d] is linked with invalid ooo_engine."),i));
      }

    for (uint32_t i=0; i<_nb_ooo_engine; i++)
      if (_is_link_ooo_engine_from_decod_unit [i] == false)
	test.error(toString(_("The ooo_engine [%d] have none decod_unit as source."),i));

    log_end(Context_State,FUNCTION);

    return test;
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
