#ifndef morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_address_management_Address_management_h
#define morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_address_management_Address_management_h

/*
 * $Id: Address_management.h 84 2008-05-13 18:04:50Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace address_management {


  class Address_management 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
  public    : counter_t                      * _stat_nb_transaction_address;
  public    : counter_t                      * _stat_nb_transaction_predict;
  public    : counter_t                      * _stat_nb_transaction_event  ;
  public    : counter_t                      * _stat_sum_packet_size       ;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "address" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )   * out_ADDRESS_VAL                         ;
  public    : SC_IN (Tcontrol_t         )   *  in_ADDRESS_ACK                         ; //icache_req_ack and ifetch_queue_ack
  public    : SC_OUT(Tgeneral_address_t )   * out_ADDRESS_INSTRUCTION_ADDRESS         ;
  public    : SC_OUT(Tcontrol_t         )  ** out_ADDRESS_INSTRUCTION_ENABLE          ; //[nb_instruction]
  public    : SC_OUT(Tinst_ifetch_ptr_t )   * out_ADDRESS_INST_IFETCH_PTR             ;
  public    : SC_OUT(Tbranch_state_t    )   * out_ADDRESS_BRANCH_STATE                ;
  public    : SC_OUT(Tprediction_ptr_t  )   * out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID ;

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )   * out_PREDICT_VAL                         ;
  public    : SC_IN (Tcontrol_t         )   *  in_PREDICT_ACK                         ;
  public    : SC_OUT(Tgeneral_address_t )   * out_PREDICT_PC_PREVIOUS                 ;
  public    : SC_OUT(Tgeneral_address_t )   * out_PREDICT_PC_CURRENT                  ;
  public    : SC_OUT(Tcontrol_t         )   * out_PREDICT_PC_CURRENT_IS_DS_TAKE       ;
  public    : SC_IN (Tgeneral_address_t )   *  in_PREDICT_PC_NEXT                     ;
  public    : SC_IN (Tcontrol_t         )   *  in_PREDICT_PC_NEXT_IS_DS_TAKE          ;
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_INSTRUCTION_ENABLE          ; //[nb_instruction]
  public    : SC_IN (Tinst_ifetch_ptr_t )   *  in_PREDICT_INST_IFETCH_PTR             ;
  public    : SC_IN (Tbranch_state_t    )   *  in_PREDICT_BRANCH_STATE                ;
  public    : SC_IN (Tprediction_ptr_t  )   *  in_PREDICT_BRANCH_UPDATE_PREDICTION_ID ;

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )    *  in_EVENT_VAL                           ;
  public    : SC_OUT(Tcontrol_t        )    * out_EVENT_ACK                           ;
  public    : SC_IN (Tgeneral_address_t)    *  in_EVENT_ADDRESS                       ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : Tcontrol_t                      reg_PC_CURRENT_VAL                          ;
  private   : Tgeneral_address_t              reg_PC_CURRENT                              ;
  private   : Tcontrol_t                      reg_PC_CURRENT_IS_DS_TAKE                   ;
  private   : Tcontrol_t                    * reg_PC_CURRENT_INSTRUCTION_ENABLE           ; //[nb_instruction]
  private   : Tinst_ifetch_ptr_t              reg_PC_CURRENT_INST_IFETCH_PTR              ;
  private   : Tbranch_state_t                 reg_PC_CURRENT_BRANCH_STATE                 ;
  private   : Tprediction_ptr_t               reg_PC_CURRENT_BRANCH_UPDATE_PREDICTION_ID  ;

  private   : Tcontrol_t                      reg_PC_NEXT_VAL                             ;
  private   : Tgeneral_address_t              reg_PC_NEXT                                 ;
  private   : Tcontrol_t                      reg_PC_NEXT_IS_DS_TAKE                      ;
  private   : Tcontrol_t                    * reg_PC_NEXT_INSTRUCTION_ENABLE              ; //[nb_instruction]
  private   : Tinst_ifetch_ptr_t              reg_PC_NEXT_INST_IFETCH_PTR                 ;
  private   : Tbranch_state_t                 reg_PC_NEXT_BRANCH_STATE                    ;
  private   : Tprediction_ptr_t               reg_PC_NEXT_BRANCH_UPDATE_PREDICTION_ID     ;

  private   : Tcontrol_t                      reg_PC_NEXT_NEXT_VAL                        ;
  private   : Tgeneral_address_t              reg_PC_NEXT_NEXT                            ;
  private   : Tcontrol_t                      reg_PC_NEXT_NEXT_IS_DS_TAKE                 ;
//private   : Tcontrol_t                    * reg_PC_NEXT_NEXT_INSTRUCTION_ENABLE         ; //[nb_instruction]
//private   : Tinst_ifetch_ptr_t              reg_PC_NEXT_NEXT_INST_IFETCH_PTR            ;
//private   : Tbranch_state_t                 reg_PC_NEXT_NEXT_BRANCH_STATE               ;
//private   : Tprediction_ptr_t               reg_PC_NEXT_NEXT_BRANCH_UPDATE_PREDICTION_ID;

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                      internal_ADDRESS_VAL;
  private   : Tcontrol_t                      internal_PREDICT_VAL;
  private   : Tcontrol_t                      internal_EVENT_ACK  ;
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Address_management);
#endif
  public  :          Address_management              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Address_management             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMoore                  (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace address_management
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
