/*
 * $Id: Parameters_print.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Parameters.h"
#include <sstream>
using namespace std;

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {


  string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"print","Begin");

    string tab = string(depth,'\t');
    ostringstream msg;
    msg << tab << "<two_level_branch_predictor_glue>" << endl
	<< tab << "\t<have_bht               value=\"" << _have_bht               << "\" />" << endl
	<< tab << "\t<bht_size_history       value=\"" << _bht_size_history       << "\" />" << endl
	<< tab << "\t<bht_size_address       value=\"" << _bht_size_address       << "\" />" << endl
	<< tab << "\t<have_pht               value=\"" << _have_pht               << "\" />" << endl
	<< tab << "\t<pht_size_address       value=\"" << _pht_size_address       << "\" />" << endl
	<< tab << "\t<pht_size_address_share value=\"" << _pht_size_address_share << "\" /> <!-- Need " << _pht_size_address_shift << " bits to shift -->" << endl
	<< tab << "\t<size_address           value=\"" << _size_address           << "\" />" << endl
	<< tab << "\t<nb_prediction          value=\"" << _nb_prediction          << "\" />" << endl
	<< tab << "\t<nb_branch_complete     value=\"" << _nb_branch_complete     << "\" />" << endl
      	<< tab << "</two_level_branch_predictor_glue>" << endl;

    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"print","End");
    
    return msg.str();
  };

  ostream& operator<< (ostream& output_stream ,
		       morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor::two_level_branch_predictor_glue::Parameters & x)
  {
    output_stream << x.print(0);
    
    return output_stream;
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction


}; // end namespace behavioural
}; // end namespace morpheo              
