#ifdef SYSTEMC
/*
 * $Id: Two_Level_Branch_Predictor_deallocation.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/include/Two_Level_Branch_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace two_level_branch_predictor {

  void Two_Level_Branch_Predictor::deallocation (void)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor,"deallocation","Begin");

    delete in_CLOCK;
    delete in_NRESET;

    delete []  in_PREDICT_VAL        ;
    delete [] out_PREDICT_ACK        ;
    delete []  in_PREDICT_ADDRESS    ;
    if (_param._have_bht)
    delete [] out_PREDICT_BHT_HISTORY;
    if (_param._have_pht)
    delete [] out_PREDICT_PHT_HISTORY;

    delete []  in_BRANCH_COMPLETE_VAL        ;
    delete [] out_BRANCH_COMPLETE_ACK        ;
    delete []  in_BRANCH_COMPLETE_ADDRESS    ;
    if (_param._have_bht)
    delete []  in_BRANCH_COMPLETE_BHT_HISTORY;
    if (_param._have_pht)
    delete []  in_BRANCH_COMPLETE_PHT_HISTORY;
    delete []  in_BRANCH_COMPLETE_DIRECTION  ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    if (_param._have_bht)
    delete component_Branch_History_Table ;
    if (_param._have_pht)
    delete component_Pattern_History_Table;
    delete component_Two_Level_Branch_Predictor_Glue;
    delete _component;

    log_printf(FUNC,Two_Level_Branch_Predictor,"deallocation","End");
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction


}; // end namespace behavioural
}; // end namespace morpheo              
#endif
