/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/SelfTest/include/test.h"

#define NB_PARAMS 7

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_("nb_thread           (uint32_t   )\n"));
  err (_("nb_general_register (uint32_t   )\n"));
  err (_("nb_special_register (uint32_t   )\n"));
  err (_("nb_bank             (uint32_t   )\n"));
  err (_("nb_pop              (uint32_t   )\n"));
  err (_("nb_push             (uint32_t   )\n"));
  err (_("priority            (Tpriority_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t       x = 1;

  const string   name      =      argv[x++];
//const uint32_t size_data = atoi(argv[x++]);
//const uint32_t nb_port   = atoi(argv[x++]);
  
  uint32_t    _nb_thread           = atoi(argv[x++]);
  uint32_t    _nb_general_register = atoi(argv[x++]);
  uint32_t    _nb_special_register = atoi(argv[x++]);
  uint32_t    _nb_bank             = atoi(argv[x++]);
  uint32_t    _nb_pop              = atoi(argv[x++]);
  uint32_t    _nb_push             = atoi(argv[x++]);
  Tpriority_t _priority            = fromString<Tpriority_t>(argv[x++]);

  try 
    {
      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::free_list_unit::Parameters * param = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::free_list_unit::Parameters
	(_nb_thread          ,
	 _nb_general_register,
	 _nb_special_register,
	 _nb_bank            ,
	 _nb_pop             ,
	 _nb_push            ,
	 _priority           );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> : %s.\n"),name.c_str(), error.what ());
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

