/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_select/SelfTest/include/test.h"

#define NB_PARAMS 7

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_front_end                         (uint32_t         )\n"));
  err (_(" * nb_context            [nb_front_end] (uint32_t         )\n"));
  err (_(" * max_branch_speculated                (uint32_t         )\n"));
  err (_(" * size_general_data                    (uint32_t         )\n"));
  err (_(" * nb_inst_rename                       (uint32_t         )\n"));
  err (_(" * nb_inst_decod         [nb_front_end] (uint32_t         )\n"));
  err (_(" * nb_front_end_select                  (uint32_t         )\n"));
  err (_(" * priority                             (Tpriority_t      )\n"));
  err (_(" * load_balancing                       (Tload_balancing_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc <  static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t          _nb_front_end         = atoi(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+2*_nb_front_end))
    usage (argc, argv);

  uint32_t *        _nb_context           = new uint32_t [_nb_front_end];
  for (uint32_t i=0; i<_nb_front_end; i++)
    _nb_context [i] = atoi(argv[x++]);

  uint32_t          _max_branch_speculated= atoi(argv[x++]);
  uint32_t          _size_general_data    = atoi(argv[x++]);
  uint32_t          _nb_inst_rename       = atoi(argv[x++]);
  uint32_t *        _nb_inst_decod        = new uint32_t [_nb_front_end];
  for (uint32_t i=0; i<_nb_front_end; i++)
    _nb_inst_decod [i] = atoi(argv[x++]);

  uint32_t          _nb_front_end_select  = atoi(argv[x++]);
  Tpriority_t       _priority             = fromString<Tpriority_t      >(argv[x++]);
  Tload_balancing_t _load_balancing       = fromString<Tload_balancing_t>(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_select::Parameters * param = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_select::Parameters
	(_nb_front_end         ,
	 _nb_context           ,
	 _max_branch_speculated,
	 _size_general_data    ,
	 _nb_inst_rename       ,
	 _nb_inst_decod        ,
	 _nb_front_end_select  ,
	 _priority             ,
	 _load_balancing       );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  delete _nb_context   ;
  delete _nb_inst_decod;

  return (_return);
}
