#ifndef morpheo_behavioural_XML_h
#define morpheo_behavioural_XML_h

/*
 * $Id: XML.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <math.h>
#include <list>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

namespace morpheo     {
namespace behavioural {

  // Virtual Class - Interface of each component
  class XML
  {
    // -----[fields ]----------------------------------------------------
  private  : const std::string     _name              ;
  private  : std::string           _filename_extension;
  private  : std::string           _body              ;
  private  : std::list<std::string>     _list_balise_name  ;

    // -----[methods ]---------------------------------------------------
  public   :                  XML                 (std::string name);
  public   :                  ~XML                (void);
	
  public   : bool             balise_open         (std::string name); // no attribut
  public   : bool             balise_open_begin   (std::string name);
  public   : bool             balise_open_end     (void);      
  public   : bool             balise_close        (void);      
  public   : bool             singleton           (std::string name); // no attribut
  public   : bool             singleton_begin     (std::string name);
  public   : bool             singleton_end       (void);
  public   : bool             attribut            (std::string name, std::string value);
  public   : bool             insert_XML          (XML    xml );

  public   : void             filename_extension  (std::string extension);
  public   : void             generate_file       (void);
  public   : void             generate_file       (std::string encoding);
  public   : std::string           get_body            (void);
  public   : std::string           get_body            (uint32_t depth);

  public   : bool             comment             (std::string text);
  public   : bool             text                (std::string text);
					          
  private  : std::string           indent              (uint32_t depth );
  private  : std::string           indent              (void);
  private  : uint32_t         depth               (void);
					          
  private  : void             header              (std::string encoding);
  };
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
