/*
 * $Id: Component_signal_internal.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Component.h"

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Component::signal_internal"
  Signal * Component::signal_internal (Entity * entity_productor,
				       Signal * signal_productor)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    // create name of internal's signal
    std::string str_entity = entity_productor->get_name();
    std::string str_signal = signal_productor->get_name();
    
    UpperCase (str_entity);
    UpperCase (str_signal);
    
    std::string name_internal = "internal_"+str_entity+"_"+str_signal;
    
    // test if internal's signal exist ... else, create
    Signal * signal_internal = _entity->find_signal (name_internal);
    
    if (signal_internal == NULL)
      {
	// signal don't exist ... create
	log_printf(TRACE,Behavioural,FUNCTION, " * Create an internal signal : \"%s\".",name_internal.c_str());
	
	Interface * interface = _entity->find_interface("");
	
	if (interface == NULL)
	  throw (ErrorMorpheo ("<Component::port_map> Component \""+_entity->get_name()+"\", doesn't have an interface \"\"."));
	
	std::string signame = entity_productor->get_name()+"_"+signal_productor->get_name();
	
	// Signal's creation
	switch (signal_productor->get_type_info())
	  {
	  case BOOL     : 
	    {
	      interface->set_signal_internal<bool    >(signame, signal_productor->get_size());
	      break;
	    }
	  case UINT8_T  :
	    {
	      interface->set_signal_internal<uint8_t >(signame, signal_productor->get_size());
	      break;
	    }
	  case UINT16_T :
	    {
	      interface->set_signal_internal<uint16_t>(signame, signal_productor->get_size());
	      break;
	    }
	  case UINT32_T :
	    {
	      interface->set_signal_internal<uint32_t>(signame, signal_productor->get_size());
	      break;
	    }
	  case UINT64_T :
	    {
	      interface->set_signal_internal<uint64_t>(signame, signal_productor->get_size());
	      break;
	    }
	  default       :
	    throw (ErrorMorpheo ("Signal \""+name_internal+"\" : type unknow."));
	  }
	
	signal_internal = _entity->find_signal (name_internal);
	
	if (signal_internal == NULL)
	  throw (ErrorMorpheo ("Signal \""+name_internal+"\" : error in creation of internal's signal."));
      }

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return signal_internal;
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

