/*
 * $Id: Interface.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface.h"

namespace morpheo              {
namespace behavioural          {

  Interface::Interface  (std::string                name         
#ifdef POSITION
			 ,direction_t           direction    
			 ,localisation_t        localisation 
#endif
			 ,Tusage_t             usage
			 ):
    _name         (name        )
#ifdef POSITION
    ,_direction    (direction   )
    ,_localisation (localisation)
#endif
    ,_usage        (usage)
  {
    log_printf(FUNC,Behavioural,"Interface","Begin");

    _list_signal   = new (std::list<Signal*>);

#ifdef POSITION
    _comment       = "";
    _is_map        = false;
    _entity_map    = NULL;
    _interface_map = NULL;
#endif

#ifdef VHDL_TESTBENCH
    _nb_cycle      = 0;
#endif

    log_printf(FUNC,Behavioural,"Interface","End");
  };

  Interface::Interface  (const Interface & interface):
    _name         (interface._name        )
#ifdef POSITION
    ,_direction    (interface._direction   )
    ,_localisation (interface._localisation)
#endif
    ,_usage        (interface._usage)
  {
    log_printf(FUNC,Behavioural,"Interface (copy)","Begin");
    _list_signal   = interface._list_signal;
#ifdef POSITION
    _comment       = interface._comment    ;
    _is_map        = interface._is_map     ;
    _entity_map    = interface._entity_map   ;
    _interface_map = interface._interface_map;
#endif
#ifdef VHDL_TESTBENCH
    _nb_cycle      = interface._nb_cycle;
#endif

    log_printf(FUNC,Behavioural,"Interface (copy)","End");
  };
  
  Interface::~Interface ()
  {
    log_printf(FUNC,Behavioural,"~Interface","Begin");

    if (_list_signal->empty()== false)
      {
	std::list<Signal*>::iterator i = _list_signal->begin();

	while (i != _list_signal->end())
	  {
	    delete (*i);
	    ++i;
	  }
      }

    delete _list_signal;

    log_printf(FUNC,Behavioural,"~Interface","End");
  };
  

}; // end namespace behavioural          
}; // end namespace morpheo              
