/*
 * $Id: Interface_set_signal.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface.h"

namespace morpheo              {
namespace behavioural          {

  Signal * Interface::set_signal (std::string          name     ,
				  direction_t     direction,
				  uint32_t        size     ,
				  presence_port_t presence_port)
  {
    log_printf(FUNC,Behavioural,"set_signal","Begin");

    std::string signame = signal_name(_name, name, direction);

    Signal * sig = new Signal       (signame, direction, size, presence_port);

    _list_signal->push_back (sig);

    log_printf(FUNC,Behavioural,"set_signal","End");

    return sig;
  };

#ifdef VHDL
#  ifdef VHDL_TESTBENCH

#undef  FUNCTION
#define FUNCTION "Interface::set_signal"
  void Interface::set_signal (Vhdl * & vhdl)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    if (not _list_signal->empty())
      {
	std::list<Signal*>::iterator i = _list_signal->begin();
	
	while (i != _list_signal->end())
	  {
	    (*i)->set_signal (vhdl);
	    ++i;
	  }
      }
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };
#  endif
#endif

}; // end namespace behavioural          
}; // end namespace morpheo              
