#ifdef VHDL

/*
 * $Id: Vhdl_generate_file_model.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include <sstream>
#include <fstream>

namespace morpheo              {
namespace behavioural          {

  void Vhdl::generate_file_model(void)
  {
    log_printf(FUNC,Behavioural,"generate_file_model","Begin");

    std::string filename = _name + ".vhdl";
    
    log_printf(TRACE,Behavioural,"generate_file_model","print %s",filename.c_str());
    std::cout << "Generate file \""<< filename << "\"" << std::endl;

    log_printf(TRACE,Behavioural,"generate_file_model","declaration");
    std::ofstream file;

    log_printf(TRACE,Behavioural,"generate_file_model","open file");
    file.open(filename.c_str(),std::ios::out | std::ios::trunc);

    log_printf(TRACE,Behavioural,"generate_file_model","get model");
    file << get_model (0,filename,_name,"behavioural");
    file.close();

    log_printf(FUNC,Behavioural,"generate_file_model","End");
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
