#ifdef VHDL

/*
 * $Id: Vhdl_get_list.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_list"
  std::string Vhdl::get_list (std::list<std::string> liste                ,
			      uint32_t     depth                ,
			      std::string       separator            ,
			      bool         last_separator       )
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::list<std::string>::iterator i     = liste.begin();
    bool                             empty = liste.empty();

    std::string                 tab   = std::string(depth,'\t');
    std::ostringstream          text;

    if (not empty)
      {
	// First
	if (i != liste.end())
	  {
	    text << tab << *i;
	    ++i;
	  }
	
	while (i != liste.end())
	  {
	    text << separator << std::endl;
	    text << tab << *i;
	    ++i;
	  }
	
	if (last_separator)
	  text << separator << std::endl;
      }

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
