/*
 * $Id: Parameters.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {


#undef  FUNCTION
#define FUNCTION "Execute_queue::Parameters"
  Parameters::Parameters (uint32_t size_queue         ,
			  uint32_t nb_context         ,
			  uint32_t nb_front_end       ,
			  uint32_t nb_ooo_engine      ,
			  uint32_t nb_packet          ,
			  uint32_t size_general_data  ,
			  uint32_t size_special_data  ):
    _size_queue              (size_queue         ),
    _nb_context              (nb_context         ),
    _nb_front_end            (nb_front_end       ),
    _nb_ooo_engine           (nb_ooo_engine      ),
    _nb_packet               (nb_packet          ),
    _size_general_data       (size_general_data  ),
    _size_special_data       (size_special_data  ),

    _size_context_id         (log2(_nb_context         )),
    _size_front_end_id       (log2(_nb_front_end       )),
    _size_ooo_engine_id      (log2(_nb_ooo_engine      )),
    _size_packet_id          (log2(_nb_packet          )),

    _have_port_context_id    (_size_context_id    > 0),
    _have_port_front_end_id  (_size_front_end_id  > 0),
    _have_port_ooo_engine_id (_size_ooo_engine_id > 0),
    _have_port_packet_id     (_size_packet_id     > 0)
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");
    test();
    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "Execute_queue::Parameters (copy)"
  Parameters::Parameters (Parameters & param):
    _size_queue              (param._size_queue             ),
    _nb_context              (param._nb_context             ),
    _nb_front_end            (param._nb_front_end           ),
    _nb_ooo_engine           (param._nb_ooo_engine          ),
    _nb_packet               (param._nb_packet              ),
    _size_general_data       (param._size_general_data      ),
    _size_special_data       (param._size_special_data      ),

    _size_context_id         (param._size_context_id        ),
    _size_front_end_id       (param._size_front_end_id      ),
    _size_ooo_engine_id      (param._size_ooo_engine_id     ),
    _size_packet_id          (param._size_packet_id         ),

    _have_port_context_id    (param._have_port_context_id   ),
    _have_port_front_end_id  (param._have_port_front_end_id ),
    _have_port_ooo_engine_id (param._have_port_ooo_engine_id),
    _have_port_packet_id     (param._have_port_packet_id    )
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");
    test();
    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Execute_queue::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");
    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
