/*
 * $Id: Parameters.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::Parameters"
  Parameters::Parameters (uint32_t   nb_context             ,
			  uint32_t * size_queue             ,
			  uint32_t   size_address           ,
			  uint32_t   nb_inst_predict        ,
			  uint32_t   nb_inst_decod          ,
			  uint32_t   nb_inst_branch_complete,
			  uint32_t   nb_inst_update         ,
			  uint32_t   size_history           ,
			  uint32_t * size_ras_index         )
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");

    _nb_context              = nb_context             ;
    _size_queue              = size_queue             ;
    _size_address            = size_address           ;
    _nb_inst_predict         = nb_inst_predict        ;
    _nb_inst_decod           = nb_inst_decod          ;
    _nb_inst_branch_complete = nb_inst_branch_complete;
    _nb_inst_update          = nb_inst_update         ;
    _size_history            = size_history           ;
    _size_ras_index          = size_ras_index         ;
    
    _size_context_id         = log2(nb_context);
    _size_depth              = new uint32_t[_nb_context];
    _have_port_depth         = new bool    [_nb_context];
    for (uint32_t i=0; i<_nb_context; i++)
      {
	_size_depth      [i] = log2(_size_queue[i]);
	_have_port_depth [i] = (_size_depth [i] > 0);
      }
    _max_size_depth          = max<uint32_t>(_size_depth,_nb_context);
    _max_size_ras_index      = max<uint32_t>(_size_ras_index,nb_context);

    _have_port_context_id    = _size_context_id> 0;
    _have_port_max_depth     = _max_size_depth > 0;
    _have_port_history       = _size_history   > 0;
    
    test();
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Update_Prediction_Table::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");
    delete [] _size_depth     ;
    delete [] _have_port_depth;
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
