#include "../include/Sim2OS.h"

namespace environment {
namespace sim2os {

  void * Sim2OS::service_write (void)
  {
    if (have_all_arguments(3) == false)
      {
	std::cerr << "<" << name << "> Usage : ssize_t write(int fd, void *buf, size_t count);" << std::endl;
	return NULL;
      }
  
    int         fd       = (int)          arguments[1];
    const void *buf      = (const void *) convert_address(arguments[2]);
    ssize_t     count    = (ssize_t)      arguments[3];
    void *      result   = (void *)       write(fd,buf,count);
    error                = errno;
    
    // No swap -> because it's a char
    
    std::cout << "\n\t***** service : write         *****"        << std::endl;
    std::cout << "\tfd        : " <<             (unsigned int) fd     << std::endl;
    std::cout << "\tbuf       : " << std::hex << (unsigned int) buf    << std::endl;
  //std::cout << "\tbuf       : " << std::dec << (char *)       buf    << std::endl;
    std::cout << "\tcount     : " << std::dec << (unsigned int) count  << std::endl;
    std::cout << "\tresult    : " <<             (unsigned int) result << std::endl;
    std::cout << "\terrno     : " <<             (unsigned int) error  << std::endl;
    
    return      result;
  }

};
};
