#ifdef SYSTEMC
/*
 * $Id: Functionnal_unit_transition.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Functionnal_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {


#undef  FUNCTION
#define FUNCTION "Functionnal_unit::transition"
  void Functionnal_unit::transition (void)
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");

    if (PORT_READ(in_NRESET) == 0)
      {
	reg_BUSY = false;
	
	for (uint32_t i=0; i<_param->_nb_context; i++)
	  for (uint32_t j=0; j<_param->_nb_front_end; j++)
	    for (uint32_t k=0; k<_param->_nb_ooo_engine; k++)
	      {
		uint32_t num_thread = get_num_thread(i,_param->_size_context_id,
						     j,_param->_size_front_end_id,
						     k,_param->_size_ooo_engine_id);
		
		for (uint32_t x=GROUP_CUSTOM_1; x<GROUP_CUSTOM_8; x++)
		  {
		    function_execute_end_cycle_t * fct = (_param->_get_custom_information(num_thread)._get_custom_execute_reset(x));
		    
		    if (fct != NULL)
		      (* fct) (_execute_register[i][j][k], _execute_param);
		  }
	      }
      }
    else
      {
	// Test if pop
	if (internal_EXECUTE_OUT_VAL and PORT_READ(in_EXECUTE_OUT_ACK))
	  {
	    // transaction
	    reg_BUSY = false;
	  }
	
	// Test if push
	execute_register_t * execute_register = NULL;

	if (PORT_READ(in_EXECUTE_IN_VAL) and internal_EXECUTE_IN_ACK)
	  {
	    reg_BUSY = true;

	    Tcontext_t   context_id    = (_param->_have_port_context_id   )?PORT_READ(in_EXECUTE_IN_CONTEXT_ID   ):0;
	    Tcontext_t   front_end_id  = (_param->_have_port_front_end_id )?PORT_READ(in_EXECUTE_IN_FRONT_END_ID ):0;
	    Tcontext_t   ooo_engine_id = (_param->_have_port_ooo_engine_id)?PORT_READ(in_EXECUTE_IN_OOO_ENGINE_ID):0;
	    Tcontext_t   packet_id     = (_param->_have_port_packet_id    )?PORT_READ(in_EXECUTE_IN_PACKET_ID    ):0;
	    Toperation_t operation     = PORT_READ(in_EXECUTE_IN_OPERATION);
	    Ttype_t      type          = PORT_READ(in_EXECUTE_IN_TYPE);
	    
	    _execute_operation->_context_id    = context_id   ;
	    _execute_operation->_front_end_id  = front_end_id ;
	    _execute_operation->_ooo_engine_id = ooo_engine_id;
	    _execute_operation->_packet_id     = packet_id    ;
	    _execute_operation->_operation     = operation    ;
	    _execute_operation->_type          = type         ;
	    _execute_operation->_has_immediat  = PORT_READ(in_EXECUTE_IN_HAS_IMMEDIAT);
	    _execute_operation->_immediat      = PORT_READ(in_EXECUTE_IN_IMMEDIAT    );
	    _execute_operation->_data_ra       = PORT_READ(in_EXECUTE_IN_DATA_RA     );
	    _execute_operation->_data_rb       = PORT_READ(in_EXECUTE_IN_DATA_RB     );
	    _execute_operation->_data_rc       = PORT_READ(in_EXECUTE_IN_DATA_RC     );
	    _execute_operation->_write_rd      = PORT_READ(in_EXECUTE_IN_WRITE_RD    );
	    _execute_operation->_num_reg_rd    = PORT_READ(in_EXECUTE_IN_NUM_REG_RD  );
	    _execute_operation->_write_re      = PORT_READ(in_EXECUTE_IN_WRITE_RE    );
	    _execute_operation->_num_reg_re    = PORT_READ(in_EXECUTE_IN_NUM_REG_RE  );

#ifdef DEBUG_TEST
	    if (type >= _param->_nb_type)
	      throw ERRORMORPHEO(FUNCTION,"Invalid type : '"+toString(type)+"' is higher that _nb_type");
	    if (operation >= _param->_nb_operation)
	      throw ERRORMORPHEO(FUNCTION,"Invalid operation : '"+toString(operation)+"' is higher that _nb_operation");
#endif

	    // execute the operation
 	    execute_register = _execute_register[context_id][front_end_id][ooo_engine_id];

	    // Test if operation is a custom
	    if (type == TYPE_CUSTOM)
	      {
		uint32_t num_thread = get_num_thread(context_id   ,_param->_size_context_id,
						     front_end_id ,_param->_size_front_end_id,
						     ooo_engine_id,_param->_size_ooo_engine_id);

		(*(_param->_get_custom_information(num_thread)._get_custom_execute_genMoore(operation))) (_execute_operation, execute_register, _execute_param);
	      }
	    else
	      (*(_function_execute[type][operation])) (_execute_operation, execute_register, _execute_param);


#ifdef STATISTICS
            (*_stat_use_functionnal_unit) ++;
	    (*_stat_sum_delay)   += _execute_operation->_timing._delay;
	    (*_stat_sum_latence) += _execute_operation->_timing._latence;
#endif
	  }
	
	// End cycle
	{
	  for (uint32_t i=0; i<_param->_nb_context; i++)
	    for (uint32_t j=0; j<_param->_nb_front_end; j++)
	      for (uint32_t k=0; k<_param->_nb_ooo_engine; k++)
		{
		  uint32_t num_thread = get_num_thread(i,_param->_size_context_id,
						       j,_param->_size_front_end_id,
						       k,_param->_size_ooo_engine_id);

		  for (uint32_t x=GROUP_CUSTOM_1; x<GROUP_CUSTOM_8; x++)
		    {
		      function_execute_end_cycle_t * fct = (_param->_get_custom_information(num_thread)._get_custom_execute_transition(x));
		      
		      if (fct != NULL)
			(* fct) (_execute_register[i][j][k], _execute_param);
		    }
		}

	  // Update status
	  if (execute_register != NULL)
	    {
	      // They have an access
	      execute_register->_i_write_spr = false;
	      execute_register->_i_read_spr  = false;
	    }
	}
      }

    // each cycle : decrease the latence
    if (reg_BUSY and (_execute_operation->_timing._latence > 0))
      _execute_operation->_timing._latence --;

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
