#ifdef VHDL
/*
 * $Id: Read_queue_vhdl.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Read_queue.h"
#include "Behavioural/Generic/Queue/include/Queue.h"
#include "Behavioural/include/Vhdl.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {


  void Read_queue::vhdl (void)
  {
    log_printf(FUNC,Read_queue,"vhdl","Begin");
    
    //----- Queue -----
    
    morpheo::behavioural::generic::queue::Parameters * param_queue;
    morpheo::behavioural::generic::queue::Queue      * queue;
    
    param_queue = new morpheo::behavioural::generic::queue::Parameters
      (_param->_size_queue,
       _param->_size_internal_queue
       );
    
    std::string queue_name = _name + "_queue";
    queue = new morpheo::behavioural::generic::queue::Queue
      (queue_name.c_str()
#ifdef STATISTICS
       ,NULL
#endif
       ,param_queue
       ,USE_VHDL);
    
    _component->set_component(queue->_component
#ifdef POSITION
                              , 0, 0, 0, 0
#endif
                              , INSTANCE_LIBRARY
                              );


    Vhdl * vhdl = new Vhdl (_name);

    _interfaces->set_port(vhdl);
    _component->vhdl_instance(vhdl);

    vhdl_declaration (vhdl);
    vhdl_body        (vhdl);

    vhdl->generate_file();

    delete vhdl;
    delete param_queue;
    delete queue;

    log_printf(FUNC,Read_queue,"vhdl","End");
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
