/*
 * $Id: Read_unit_to_Execution_unit_allocation.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit/include/Read_unit_to_Execution_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace read_unit_to_execution_unit {



#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::allocation"
  void Read_unit_to_Execution_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Read_unit_to_Execution_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

    // ~~~~~[ Interface "read_unit_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("read_unit_out", IN, EAST, "Output of read_unit", _param->_nb_read_unit);

       ALLOC1_VALACK_IN ( in_READ_UNIT_OUT_VAL,VAL);
       ALLOC1_VALACK_OUT(out_READ_UNIT_OUT_ACK,ACK);

       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_CONTEXT_ID           ,"CONTEXT_ID"           ,Tcontext_t        ,_param->_size_context_id);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_FRONT_END_ID         ,"FRONT_END_ID"         ,Tcontext_t        ,_param->_size_front_end_id);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_OOO_ENGINE_ID        ,"OOO_ENGINE_ID"        ,Tcontext_t        ,_param->_size_ooo_engine_id);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_PACKET_ID            ,"PACKET_ID"            ,Tpacket_t         ,_param->_size_packet_id);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_OPERATION            ,"OPERATION"            ,Toperation_t      ,_param->_size_operation);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_TYPE                 ,"TYPE"                 ,Ttype_t           ,_param->_size_type);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE,"STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,log2(_param->_size_store_queue));
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ,"LOAD_QUEUE_PTR_WRITE" ,Tlsq_ptr_t        ,log2(_param->_size_load_queue));
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_HAS_IMMEDIAT         ,"HAS_IMMEDIAT"         ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_IMMEDIAT             ,"IMMEDIAT"             ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_DATA_RA              ,"DATA_RA"              ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_DATA_RB              ,"DATA_RB"              ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_DATA_RC              ,"DATA_RC"              ,Tspecial_data_t   ,_param->_size_special_data);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_WRITE_RD             ,"WRITE_RD"             ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_NUM_REG_RD           ,"NUM_REG_RD"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_WRITE_RE             ,"WRITE_RE"             ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_READ_UNIT_OUT_NUM_REG_RE           ,"NUM_REG_RE"           ,Tspecial_address_t,_param->_size_special_register);
     }
    // ~~~~~[ Interface "execute_unit_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("execute_unit_in", OUT, WEST, "Input of execute_unit", _param->_nb_execute_unit);
       
       ALLOC1_VALACK_OUT(out_EXECUTE_UNIT_IN_VAL,VAL);
       ALLOC1_VALACK_IN ( in_EXECUTE_UNIT_IN_ACK,ACK);

       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_CONTEXT_ID           ,"CONTEXT_ID"           ,Tcontext_t        ,_param->_size_context_id);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_FRONT_END_ID         ,"FRONT_END_ID"         ,Tcontext_t        ,_param->_size_front_end_id);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID        ,"OOO_ENGINE_ID"        ,Tcontext_t        ,_param->_size_ooo_engine_id);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_PACKET_ID            ,"PACKET_ID"            ,Tpacket_t         ,_param->_size_packet_id);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_OPERATION            ,"OPERATION"            ,Toperation_t      ,_param->_size_operation);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_TYPE                 ,"TYPE"                 ,Ttype_t           ,_param->_size_type);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT         ,"HAS_IMMEDIAT"         ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_DATA_RC              ,"DATA_RC"              ,Tspecial_data_t   ,_param->_size_special_data);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_WRITE_RD             ,"WRITE_RD"             ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_WRITE_RE             ,"WRITE_RE"             ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_NUM_REG_RE           ,"NUM_REG_RE"           ,Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE,"STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,log2(_param->_size_store_queue));
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE ,"LOAD_QUEUE_PTR_WRITE" ,Tlsq_ptr_t        ,log2(_param->_size_load_queue));
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_IMMEDIAT             ,"IMMEDIAT"             ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_DATA_RA              ,"DATA_RA"              ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_DATA_RB              ,"DATA_RB"              ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_UNIT_IN_NUM_REG_RD           ,"NUM_REG_RD"           ,Tgeneral_address_t,_param->_size_general_register);
     }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
     _destination = new std::list<uint32_t> ** [_param->_nb_read_unit];
     for (uint32_t i=0; i<_param->_nb_read_unit; i++)
       {
	 _destination [i] = new std::list<uint32_t> * [_param->_nb_thread];
	 for (uint32_t j=0; j<_param->_nb_thread; j++)
	   {
	     _destination [i][j] = new std::list<uint32_t> [_param->_nb_type];
	   }
       }

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"End");
  };

}; // end namespace read_unit_to_execution_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
