#ifdef SYSTEMC
/*
 * $Id: Decod_queue_genMealy_decod_out.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Decod_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::genMealy_decod_out"
  void Decod_queue::genMealy_decod_out (void)
  {
    log_begin(Decod_queue,FUNCTION);

    Tcontrol_t val [_param->_nb_inst_decod];
    for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
      {
	val                    [i] = 0;
	internal_DECOD_OUT_VAL [i] = 0;
	internal_DECOD_OUT_ACK [i] = 0;
      }

    if (not reg_QUEUE->empty())
      for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	if (reg_QUEUE->front()->_val [i])
	  {
	    log_printf(TRACE,Decod_queue,FUNCTION,_("Queue is not empty, slot [%d] is valid."),i);

	    Tcontext_t context         = reg_QUEUE->front()->_context_id    [i];
	    Tdepth_t   depth           = reg_QUEUE->front()->_depth         [i];
	    Tdepth_t   depth_base      = (_param->_have_port_depth)?PORT_READ(in_DEPTH_TAIL      [context]):0;
	    Tdepth_t   depth_offset    = (_param->_have_port_depth)?PORT_READ(in_DEPTH_NB_BRANCH [context]):0;
	    Tdepth_t   depth_max       = depth_base + depth_offset;

	    // is a valid instruction ?
	    //  * depth must be lower that depth max
	    Tcontrol_t is_valid        = depth <= ((depth>depth_base)?(depth_max):(depth_max%_param->_nb_branch_speculated [context]));

	    log_printf(TRACE,Decod_queue,FUNCTION,_("  * is_valid : %d"),is_valid);

	    internal_DECOD_OUT_VAL [i] = 1; // in all case, val is set (entry is not empty, and instruction is valid)
	    if (is_valid)
	      {
		val                    [i] = 1;
		internal_DECOD_OUT_ACK [i] = PORT_READ(in_DECOD_OUT_ACK [i]);
	      }
	    else
	      {
		// Cusume the instruction (to erase)
		internal_DECOD_OUT_ACK [i] = 1;
	      }
	  }

    for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
      {
	PORT_WRITE(out_DECOD_OUT_VAL [i],val [i]);
      }

    log_end(Decod_queue,FUNCTION);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
