/*
 * $Id: test.cpp 83 2008-05-09 18:00:21Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::decod_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Decod_unit * _Decod_unit = new Decod_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC2_SC_SIGNAL( in_IFETCH_VAL                         ," in_IFETCH_VAL                         ",Tcontrol_t         ,_param->_nb_context, _param->_nb_inst_fetch[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL(out_IFETCH_ACK                         ,"out_IFETCH_ACK                         ",Tcontrol_t         ,_param->_nb_context, _param->_nb_inst_fetch[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_IFETCH_INSTRUCTION                 ," in_IFETCH_INSTRUCTION                 ",Tinstruction_t     ,_param->_nb_context, _param->_nb_inst_fetch[alloc_signal_it1]);

  ALLOC1_SC_SIGNAL(in_IFETCH_CONTEXT_ID                   ,"in_IFETCH_CONTEXT_ID                   ",Tcontext_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(in_IFETCH_ADDRESS                      ,"in_IFETCH_ADDRESS                      ",Tgeneral_address_t ,_param->_nb_context);
//ALLOC1_SC_SIGNAL(in_IFETCH_ADDRESS_NEXT                 ,"in_IFETCH_ADDRESS_NEXT                 ",Tgeneral_address_t ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(in_IFETCH_INST_IFETCH_PTR              ,"in_IFETCH_INST_IFETCH_PTR              ",Tinst_ifetch_ptr_t ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(in_IFETCH_BRANCH_STATE                 ,"in_IFETCH_BRANCH_STATE                 ",Tbranch_state_t    ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(in_IFETCH_BRANCH_UPDATE_PREDICTION_ID  ,"in_IFETCH_BRANCH_UPDATE_PREDICTION_ID  ",Tprediction_ptr_t  ,_param->_nb_context);

  ALLOC1_SC_SIGNAL(out_DECOD_VAL                          ,"out_DECOD_VAL                          ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_ACK                          ," in_DECOD_ACK                          ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_CONTEXT_ID                   ,"out_DECOD_CONTEXT_ID                   ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_DEPTH                        ,"out_DECOD_DEPTH                        ",Tdepth_t           ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_TYPE                         ,"out_DECOD_TYPE                         ",Ttype_t            ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OPERATION                    ,"out_DECOD_OPERATION                    ",Toperation_t       ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_IS_DELAY_SLOT                ,"out_DECOD_IS_DELAY_SLOT                ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_ADDRESS                      ,"out_DECOD_ADDRESS                      ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_HAS_IMMEDIAT                 ,"out_DECOD_HAS_IMMEDIAT                 ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_IMMEDIAT                     ,"out_DECOD_IMMEDIAT                     ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RA                      ,"out_DECOD_READ_RA                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RA                   ,"out_DECOD_NUM_REG_RA                   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RB                      ,"out_DECOD_READ_RB                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RB                   ,"out_DECOD_NUM_REG_RB                   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RC                      ,"out_DECOD_READ_RC                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RC                   ,"out_DECOD_NUM_REG_RC                   ",Tspecial_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_WRITE_RD                     ,"out_DECOD_WRITE_RD                     ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RD                   ,"out_DECOD_NUM_REG_RD                   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_WRITE_RE                     ,"out_DECOD_WRITE_RE                     ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RE                   ,"out_DECOD_NUM_REG_RE                   ",Tspecial_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_EXCEPTION_USE                ,"out_DECOD_EXCEPTION_USE                ",Texception_t       ,_param->_nb_inst_decod);

  ALLOC1_SC_SIGNAL(out_PREDICT_VAL                        ,"out_PREDICT_VAL                        ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_PREDICT_ACK                        ," in_PREDICT_ACK                        ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_CONTEXT_ID                 ,"out_PREDICT_CONTEXT_ID                 ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_MATCH_INST_IFETCH_PTR      ,"out_PREDICT_MATCH_INST_IFETCH_PTR      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_STATE               ,"out_PREDICT_BRANCH_STATE               ",Tbranch_state_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,"out_PREDICT_BRANCH_UPDATE_PREDICTION_ID",Tprediction_ptr_t  ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_CONDITION           ,"out_PREDICT_BRANCH_CONDITION           ",Tbranch_condition_t,_param->_nb_inst_decod);
//ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_STACK_WRITE         ,"out_PREDICT_BRANCH_STACK_WRITE         ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_DIRECTION           ,"out_PREDICT_BRANCH_DIRECTION           ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_ADDRESS_SRC                ,"out_PREDICT_ADDRESS_SRC                ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_ADDRESS_DEST               ,"out_PREDICT_ADDRESS_DEST               ",Tgeneral_data_t    ,_param->_nb_inst_decod);
//ALLOC1_SC_SIGNAL( in_PREDICT_CAN_CONTINUE               ," in_PREDICT_CAN_CONTINUE               ",Tcontrol_t         ,_param->_nb_inst_decod);

  ALLOC1_SC_SIGNAL( in_DEPTH_TAIL                         ," in_DEPTH_TAIL                         ",Tdepth_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_DEPTH_NB_BRANCH                    ," in_DEPTH_NB_BRANCH                    ",Tdepth_t           ,_param->_nb_context);

  ALLOC1_SC_SIGNAL(out_NB_INST_DECOD_ALL                  ,"out_NB_INST_DECOD_ALL                  ",Tcounter_t         ,_param->_nb_context);

  ALLOC1_SC_SIGNAL( in_CONTEXT_DECOD_ENABLE               ," in_CONTEXT_DECOD_ENABLE               ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_CONTEXT_DEPTH                      ," in_CONTEXT_DEPTH                      ",Tdepth_t           ,_param->_nb_context);

  ALLOC_SC_SIGNAL( out_CONTEXT_EVENT_VAL                  ,"out_CONTEXT_EVENT_VAL                  ",Tcontrol_t         );
  ALLOC_SC_SIGNAL(  in_CONTEXT_EVENT_ACK                  ," in_CONTEXT_EVENT_ACK                  ",Tcontrol_t         );
  ALLOC_SC_SIGNAL( out_CONTEXT_EVENT_CONTEXT_ID           ,"out_CONTEXT_EVENT_CONTEXT_ID           ",Tcontext_t         );
  ALLOC_SC_SIGNAL( out_CONTEXT_EVENT_TYPE                 ,"out_CONTEXT_EVENT_TYPE                 ",Tevent_type_t      );
  ALLOC_SC_SIGNAL( out_CONTEXT_EVENT_IS_DELAY_SLOT        ,"out_CONTEXT_EVENT_IS_DELAY_SLOT        ",Tcontrol_t         );
  ALLOC_SC_SIGNAL( out_CONTEXT_EVENT_ADDRESS              ,"out_CONTEXT_EVENT_ADDRESS              ",Tgeneral_data_t    );
  ALLOC_SC_SIGNAL( out_CONTEXT_EVENT_ADDRESS_EPCR         ,"out_CONTEXT_EVENT_ADDRESS_EPCR         ",Tgeneral_data_t    );
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Decod_unit.\n"),name.c_str());

  (*(_Decod_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Decod_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE2_SC_SIGNAL(_Decod_unit, in_IFETCH_VAL                         ,_param->_nb_context, _param->_nb_inst_fetch[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Decod_unit,out_IFETCH_ACK                         ,_param->_nb_context, _param->_nb_inst_fetch[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Decod_unit, in_IFETCH_INSTRUCTION                 ,_param->_nb_context, _param->_nb_inst_fetch[alloc_signal_it1]);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Decod_unit,in_IFETCH_CONTEXT_ID                   ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Decod_unit,in_IFETCH_ADDRESS                      ,_param->_nb_context);
//INSTANCE1_SC_SIGNAL(_Decod_unit,in_IFETCH_ADDRESS_NEXT                 ,_param->_nb_context);
  if (_param->_have_port_inst_ifetch_ptr)
  INSTANCE1_SC_SIGNAL(_Decod_unit,in_IFETCH_INST_IFETCH_PTR              ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Decod_unit,in_IFETCH_BRANCH_STATE                 ,_param->_nb_context);
  if (_param->_have_port_branch_update_prediction_id)
  INSTANCE1_SC_SIGNAL(_Decod_unit,in_IFETCH_BRANCH_UPDATE_PREDICTION_ID  ,_param->_nb_context);

  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_VAL                          ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_DECOD_ACK                          ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_CONTEXT_ID                   ,_param->_nb_inst_decod);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_DEPTH                        ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_TYPE                         ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_OPERATION                    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_IS_DELAY_SLOT                ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_ADDRESS                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_HAS_IMMEDIAT                 ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_IMMEDIAT                     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_READ_RA                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_NUM_REG_RA                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_READ_RB                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_NUM_REG_RB                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_READ_RC                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_NUM_REG_RC                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_WRITE_RD                     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_NUM_REG_RD                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_WRITE_RE                     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_NUM_REG_RE                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_EXCEPTION_USE                ,_param->_nb_inst_decod);

  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_VAL                        ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_PREDICT_ACK                        ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_CONTEXT_ID                 ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_MATCH_INST_IFETCH_PTR      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_BRANCH_STATE               ,_param->_nb_inst_decod);
  if (_param->_have_port_branch_update_prediction_id)
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_BRANCH_CONDITION           ,_param->_nb_inst_decod);
//INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_BRANCH_STACK_WRITE         ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_BRANCH_DIRECTION           ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_ADDRESS_SRC                ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_ADDRESS_DEST               ,_param->_nb_inst_decod);
//INSTANCE1_SC_SIGNAL(_Decod_unit, in_PREDICT_CAN_CONTINUE               ,_param->_nb_inst_decod);

  if (_param->_have_port_depth)
    {
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_DEPTH_TAIL                         ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_DEPTH_NB_BRANCH                    ,_param->_nb_context);
    }

  INSTANCE1_SC_SIGNAL(_Decod_unit,out_NB_INST_DECOD_ALL                  ,_param->_nb_context);

  INSTANCE1_SC_SIGNAL(_Decod_unit, in_CONTEXT_DECOD_ENABLE               ,_param->_nb_context);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_CONTEXT_DEPTH                      ,_param->_nb_context);

  INSTANCE_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_VAL                  );
  INSTANCE_SC_SIGNAL( _Decod_unit, in_CONTEXT_EVENT_ACK                  );
  if (_param->_have_port_context_id)
  INSTANCE_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_CONTEXT_ID           );
  INSTANCE_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_TYPE                 );
  INSTANCE_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_IS_DELAY_SLOT        );
  INSTANCE_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_ADDRESS              );
  INSTANCE_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_ADDRESS_EPCR         );


  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE2_SC_SIGNAL( in_IFETCH_VAL                         ,_param->_nb_context, _param->_nb_inst_fetch[alloc_signal_it1]);
  DELETE2_SC_SIGNAL(out_IFETCH_ACK                         ,_param->_nb_context, _param->_nb_inst_fetch[alloc_signal_it1]);
  DELETE2_SC_SIGNAL( in_IFETCH_INSTRUCTION                 ,_param->_nb_context, _param->_nb_inst_fetch[alloc_signal_it1]);
  DELETE1_SC_SIGNAL(in_IFETCH_CONTEXT_ID                   ,_param->_nb_context);
  DELETE1_SC_SIGNAL(in_IFETCH_ADDRESS                      ,_param->_nb_context);
//DELETE1_SC_SIGNAL(in_IFETCH_ADDRESS_NEXT                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL(in_IFETCH_INST_IFETCH_PTR              ,_param->_nb_context);
  DELETE1_SC_SIGNAL(in_IFETCH_BRANCH_STATE                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL(in_IFETCH_BRANCH_UPDATE_PREDICTION_ID  ,_param->_nb_context);

  DELETE1_SC_SIGNAL(out_DECOD_VAL                          ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_ACK                          ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_CONTEXT_ID                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_DEPTH                        ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_TYPE                         ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OPERATION                    ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_IS_DELAY_SLOT                ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_ADDRESS                      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_HAS_IMMEDIAT                 ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_IMMEDIAT                     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_READ_RA                      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RA                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_READ_RB                      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RB                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_READ_RC                      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RC                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_WRITE_RD                     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RD                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_WRITE_RE                     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RE                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_EXCEPTION_USE                ,_param->_nb_inst_decod);

  DELETE1_SC_SIGNAL(out_PREDICT_VAL                        ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_PREDICT_ACK                        ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_CONTEXT_ID                 ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_MATCH_INST_IFETCH_PTR      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_STATE               ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_CONDITION           ,_param->_nb_inst_decod);
//DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_STACK_WRITE         ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_DIRECTION           ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_ADDRESS_SRC                ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_ADDRESS_DEST               ,_param->_nb_inst_decod);
//DELETE1_SC_SIGNAL( in_PREDICT_CAN_CONTINUE               ,_param->_nb_inst_decod);

  DELETE1_SC_SIGNAL( in_DEPTH_TAIL                         ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_DEPTH_NB_BRANCH                    ,_param->_nb_context);

  DELETE1_SC_SIGNAL(out_NB_INST_DECOD_ALL                  ,_param->_nb_context);

  DELETE1_SC_SIGNAL( in_CONTEXT_DECOD_ENABLE               ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_CONTEXT_DEPTH                      ,_param->_nb_context);

  DELETE_SC_SIGNAL( out_CONTEXT_EVENT_VAL                  );
  DELETE_SC_SIGNAL(  in_CONTEXT_EVENT_ACK                  );
  DELETE_SC_SIGNAL( out_CONTEXT_EVENT_CONTEXT_ID           );
  DELETE_SC_SIGNAL( out_CONTEXT_EVENT_TYPE                 );
  DELETE_SC_SIGNAL( out_CONTEXT_EVENT_IS_DELAY_SLOT        );
  DELETE_SC_SIGNAL( out_CONTEXT_EVENT_ADDRESS              );
  DELETE_SC_SIGNAL( out_CONTEXT_EVENT_ADDRESS_EPCR         );

    }
#endif

  delete _Decod_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
