/*
 * $Id: Ifetch_unit_Glue_allocation.cpp 85 2008-05-14 13:09:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_unit_Glue/include/Ifetch_unit_Glue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_unit_glue {



#undef  FUNCTION
#define FUNCTION "Ifetch_unit_Glue::allocation"
  void Ifetch_unit_Glue::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Ifetch_unit_Glue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Ifetch_unit_Glue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC_INTERFACE("icache_req",OUT, WEST, "Instruction Cache request.");

      ALLOC_SIGNAL_OUT(out_ICACHE_REQ_VAL            ,"val"            ,Tcontrol_t,1);
      ALLOC_SIGNAL_IN ( in_ICACHE_REQ_ADDRESS_VAL    ,"address_val"    ,Tcontrol_t,1);
      ALLOC_SIGNAL_OUT(out_ICACHE_REQ_QUEUE_VAL      ,"queue_val"      ,Tcontrol_t,1);
      ALLOC_SIGNAL_IN ( in_ICACHE_REQ_ACK            ,"ack"            ,Tcontrol_t,1);
      ALLOC_SIGNAL_OUT(out_ICACHE_REQ_ADDRESS_ACK    ,"address_ack"    ,Tcontrol_t,1);
      ALLOC_SIGNAL_IN ( in_ICACHE_REQ_QUEUE_ACK      ,"queue_ack"      ,Tcontrol_t,1);
      ALLOC_SIGNAL_OUT(out_ICACHE_REQ_TYPE           ,"type"           ,Ticache_type_t,_param->_size_icache_type);
      ALLOC_SIGNAL_OUT(out_ICACHE_REQ_ADDRESS        ,"address"        ,Taddress_t,_param->_size_address);
      ALLOC_SIGNAL_IN ( in_ICACHE_REQ_ADDRESS_ADDRESS,"address_address",Taddress_t,_param->_size_address);
      ALLOC_SIGNAL_OUT(out_ICACHE_REQ_QUEUE_ADDRESS  ,"queue_address"  ,Taddress_t,_param->_size_address);
    }

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC_INTERFACE("event",IN, EAST, "Event interface.");

      ALLOC_SIGNAL_IN ( in_EVENT_VAL        ,"val"        ,Tcontrol_t,1);
      ALLOC_SIGNAL_OUT(out_EVENT_ADDRESS_VAL,"address_val",Tcontrol_t,1);
      ALLOC_SIGNAL_OUT(out_EVENT_QUEUE_VAL  ,"queue_val"  ,Tcontrol_t,1);
      ALLOC_SIGNAL_OUT(out_EVENT_ACK        ,"ack"        ,Tcontrol_t,1);
      ALLOC_SIGNAL_IN ( in_EVENT_ADDRESS_ACK,"address_ack",Tcontrol_t,1);
      ALLOC_SIGNAL_IN ( in_EVENT_QUEUE_ACK  ,"queue_ack"  ,Tcontrol_t,1);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Ifetch_unit_Glue,FUNCTION,"End");
  };

}; // end namespace ifetch_unit_glue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
