#ifndef ENVIRONMENT_CACHE_TYPES_H
#define ENVIRONMENT_CACHE_TYPES_H

namespace environment {
namespace cache {

  // =====================================================
  // =====[ CACHE ]=======================================
  // =====================================================

  typedef enum
    {
      INSTRUCTION_CACHE ,
      DATA_CACHE 
    } cache_t;
  
  // =====================================================
  // =====[ DIRECTION ]===================================
  // =====================================================

  typedef enum
    {
      READ       ,
      WRITE      ,
      NONE
    } direction_req_cache_t;
  
  // =====================================================
  // =====[ REQUEST ]=====================================
  // =====================================================

  typedef enum 
    {
      CACHED     , // address can be in the cache
      UNCACHED   , // Always miss (not address in cache)
      INVALIDATE , // The direction is not used
      PREFETCH   , // The direction is not used
      FLUSH        // The direction is not used
    } type_req_cache_t;

  // =====================================================
  // =====[ RESPONS ]=====================================
  // =====================================================

  typedef enum 
    {
      HIT_CACHE        ,
      HIT_BYPASS       ,
      HIT_WRITE_BUFFER ,
      MISS
    } type_rsp_cache_t;

};
};
#endif
