/*
 * $Id: Parameters_print.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {


#undef  FUNCTION
#define FUNCTION "Execute_loop::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Execute_loop,FUNCTION,"Begin");

    XML xml ("execute_loop");

    xml.balise_open("execute_loop");
    xml.singleton_begin("nb_read_unit                         "); xml.attribut("value",toString(_nb_read_unit                         )); xml.singleton_end();
    xml.singleton_begin("nb_functionnal_unit                  "); xml.attribut("value",toString(_nb_functionnal_unit                  )); xml.singleton_end();
    xml.singleton_begin("nb_load_store_unit                   "); xml.attribut("value",toString(_nb_load_store_unit                   )); xml.singleton_end();
    xml.singleton_begin("nb_write_unit                        "); xml.attribut("value",toString(_nb_write_unit                        )); xml.singleton_end();
    xml.singleton_begin("nb_context                           "); xml.attribut("value",toString(_nb_context                           )); xml.singleton_end();
    xml.singleton_begin("nb_front_end                         "); xml.attribut("value",toString(_nb_front_end                         )); xml.singleton_end();
    xml.singleton_begin("nb_ooo_engine                        "); xml.attribut("value",toString(_nb_ooo_engine                        )); xml.singleton_end();
    xml.singleton_begin("nb_packet                            "); xml.attribut("value",toString(_nb_packet                            )); xml.singleton_end();
    xml.singleton_begin("size_general_data                    "); xml.attribut("value",toString(_size_general_data                    )); xml.singleton_end();
    xml.singleton_begin("size_special_data                    "); xml.attribut("value",toString(_size_special_data                    )); xml.singleton_end();
    xml.singleton_begin("nb_gpr_bank                          "); xml.attribut("value",toString(_nb_gpr_bank                          )); xml.singleton_end();
    xml.singleton_begin("nb_gpr_port_read_by_bank             "); xml.attribut("value",toString(_nb_gpr_port_read_by_bank             )); xml.singleton_end();
    xml.singleton_begin("nb_gpr_port_write_by_bank            "); xml.attribut("value",toString(_nb_gpr_port_write_by_bank            )); xml.singleton_end();
    xml.singleton_begin("nb_spr_bank                          "); xml.attribut("value",toString(_nb_spr_bank                          )); xml.singleton_end();
    xml.singleton_begin("nb_spr_port_read_by_bank             "); xml.attribut("value",toString(_nb_spr_port_read_by_bank             )); xml.singleton_end();
    xml.singleton_begin("nb_spr_port_write_by_bank            "); xml.attribut("value",toString(_nb_spr_port_write_by_bank            )); xml.singleton_end();
    xml.singleton_begin("execution_unit_to_write_unit_priority"); xml.attribut("value",toString(_execution_unit_to_write_unit_priority)); xml.singleton_end();
    xml.singleton_begin("read_unit_to_execution_unit_priority "); xml.attribut("value",toString(_read_unit_to_execution_unit_priority )); xml.singleton_end();

    for (uint32_t i=0; i<_nb_read_unit; i++)
      {
	xml.balise_open_begin("component");
	xml. attribut("type","read_unit");
	xml. attribut("id"  ,toString(i));
	xml.balise_open_end();
	xml. singleton_begin("size_read_queue         "); xml.attribut("value",toString(_size_read_queue          [i])); xml.singleton_end();
	xml. singleton_begin("size_reservation_station"); xml.attribut("value",toString(_size_reservation_station [i])); xml.singleton_end();
	xml. singleton_begin("nb_inst_retire          "); xml.attribut("value",toString(_nb_inst_retire           [i])); xml.singleton_end();
	xml.balise_close();
      }

    for (uint32_t i=0; i<_nb_load_store_unit; i++)
      {
	xml.balise_open_begin("component");
	xml. attribut("type","load_store_unit");
	xml. attribut("id"  ,toString(i));
	xml.balise_open_end();
	xml. singleton_begin("size_store_queue             "); xml.attribut("value",toString(_size_store_queue             [i])); xml.singleton_end();
	xml. singleton_begin("size_load_queue              "); xml.attribut("value",toString(_size_load_queue              [i])); xml.singleton_end();
	xml. singleton_begin("size_speculative_access_queue"); xml.attribut("value",toString(_size_speculative_access_queue[i])); xml.singleton_end();
	xml. singleton_begin("nb_port_check                "); xml.attribut("value",toString(_nb_port_check                [i])); xml.singleton_end();
	xml. singleton_begin("speculative_load             "); xml.attribut("value",toString(_speculative_load             [i])); xml.singleton_end();
	xml. singleton_begin("nb_bypass_memory             "); xml.attribut("value",toString(_nb_bypass_memory             [i])); xml.singleton_end();
	xml.balise_close();
      }

    for (uint32_t i=0; i<_nb_write_unit; i++)
      {
	xml.balise_open_begin("component");
	xml. attribut("type","write_unit");
	xml. attribut("id"  ,toString(i));
	xml.balise_open_end();
	xml. singleton_begin("size_write_queue  "); xml.attribut("value",toString(_size_write_queue   [i])); xml.singleton_end();
	xml. singleton_begin("size_execute_queue"); xml.attribut("value",toString(_size_execute_queue [i])); xml.singleton_end();
	xml. singleton_begin("nb_bypass_write   "); xml.attribut("value",toString(_nb_bypass_write    [i])); xml.singleton_end();
	xml.balise_close();
      }

    for (uint32_t i=0; i<_nb_ooo_engine; i++)
      {
	xml.balise_open_begin("component");
	xml. attribut("type","ooo_engine");
	xml. attribut("id"  ,toString(i));
	xml.balise_open_end();
	xml. singleton_begin("nb_general_register"); xml.attribut("value",toString(_nb_general_register [i])); xml.singleton_end();
	xml. singleton_begin("nb_special_register"); xml.attribut("value",toString(_nb_special_register [i])); xml.singleton_end();
	xml. singleton_begin("nb_inst_insert_rob "); xml.attribut("value",toString(_nb_inst_insert_rob  [i])); xml.singleton_end();
	xml. singleton_begin("nb_inst_retire_rob "); xml.attribut("value",toString(_nb_inst_retire_rob  [i])); xml.singleton_end();
	xml.balise_close();
      }


    std::string str = "";
    for (uint32_t i=0; i<_nb_read_unit; i++)
      str += _param_read_unit [i]->print(depth+1);
    for (uint32_t i=0; i<_nb_functionnal_unit; i++)
      str += _param_functionnal_unit [i]->print(depth+1);
    for (uint32_t i=0; i<_nb_load_store_unit; i++)
      str += _param_load_store_unit [i]->print(depth+1);
    for (uint32_t i=0; i<_nb_write_unit; i++)
    str += _param_write_unit [i]->print(depth+1);
    str += _param_read_unit_to_execution_unit->print(depth+1);
    str += _param_execution_unit_to_write_unit->print(depth+1);
    str += _param_register_unit->print(depth+1);

    xml.comment("\n"+str);

    xml.balise_close();

    log_printf(FUNC,Execute_loop,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Execute_loop::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_execute_loop::execute_loop::Parameters & x)
  {
    log_printf(FUNC,Execute_loop,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Execute_loop,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
