/*
 * $Id: Parameters_print.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {


#undef  FUNCTION
#define FUNCTION "Ifetch_queue::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

    XML xml ("ifetch_queue");

    xml.balise_open("ifetch_queue");
    xml.singleton_begin("size_queue                   "); xml.attribut("value",toString(_size_queue                   )); xml.singleton_end();
    xml.singleton_begin("nb_instruction               "); xml.attribut("value",toString(_nb_instruction               )); xml.singleton_end();
    xml.singleton_begin("size_branch_update_prediction"); xml.attribut("value",toString(_size_branch_update_prediction)); xml.singleton_end();
    xml.singleton_begin("size_general_data            "); xml.attribut("value",toString(_size_general_data            )); xml.singleton_end();
    xml.balise_close();

    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Ifetch_queue::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Parameters & x)
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
