#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_prediction_unit_glue_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_prediction_unit_glue_Parameters_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace prediction_unit_glue {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t   _nb_context               ;// == nb_ifetch_unit
  public : uint32_t   _nb_decod_unit            ;
//public : uint32_t   _nb_ooo_engine            ;
  public : uint32_t   _size_address             ;
  public : uint32_t * _nb_instruction           ;//[nb_context]
  public : uint32_t * _size_depth               ;//[nb_context]
  public : uint32_t * _nb_inst_decod            ;//[nb_decod_unit]
//public : uint32_t * _nb_inst_update           ;//[nb_ooo_engine]
  public : uint32_t   _nb_inst_branch_predict   ;
  public : uint32_t   _nb_inst_branch_decod     ;
  public : uint32_t   _nb_inst_branch_update    ;
//public : uint32_t   _nb_inst_branch_complete  ;

  public : uint32_t   _size_context_id          ;
  public : uint32_t * _size_inst_ifetch_ptr     ;//[nb_context]
  public : uint32_t   _max_size_depth           ;

  public : bool       _have_port_context_id     ;
  public : bool       _have_port_max_depth      ;
  public : bool     * _have_port_depth          ;//[nb_context]
  public : bool     * _have_port_inst_ifetch_ptr;//[nb_context]

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t   nb_context            ,
			uint32_t   nb_decod_unit         ,
// 			uint32_t   nb_ooo_engine         ,
			uint32_t   size_address          ,
			uint32_t * nb_instruction        ,
			uint32_t * size_depth            ,
			uint32_t * nb_inst_decod         ,
// 			uint32_t * nb_inst_update        ,
			uint32_t   nb_inst_branch_predict,
			uint32_t   nb_inst_branch_decod  ,
			uint32_t   nb_inst_branch_update );
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::prediction_unit_glue::Parameters & x);
  };

}; // end namespace prediction_unit_glue
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
