/*
 * $Id: Parameters.cpp 85 2008-05-14 13:09:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {


#undef  FUNCTION
#define FUNCTION "Ifetch_unit::Parameters"
  Parameters::Parameters (uint32_t size_queue                   ,
			  uint32_t nb_instruction               ,
			  uint32_t size_branch_update_prediction,
			  uint32_t size_address                 )
  {
    log_printf(FUNC,Ifetch_unit,FUNCTION,"Begin");

    _size_queue                            = size_queue                   ;
    _nb_instruction                        = nb_instruction               ;
    _size_branch_update_prediction         = size_branch_update_prediction;
    _size_address                          = size_address                 ;

    _size_queue_ptr                        = log2(size_queue);
    _size_instruction_ptr                  = log2(nb_instruction);

    _have_port_queue_ptr                   = _size_queue_ptr > 0;
    _have_port_instruction_ptr             = _size_instruction_ptr > 0;
    _have_port_branch_update_prediction_id = size_branch_update_prediction > 0;

    test();

    _param_address_management = new morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::address_management::Parameters
      (nb_instruction               ,
       size_address                 ,
       size_branch_update_prediction);
    _param_ifetch_queue       = new morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::      Parameters
      (size_queue                   ,
       nb_instruction               ,
       size_branch_update_prediction,
       size_address                 );
    _param_ifetch_unit_glue   = new morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_unit_glue::  Parameters
      (size_address);
    
    log_printf(FUNC,Ifetch_unit,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Ifetch_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Ifetch_unit,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Ifetch_unit,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Ifetch_unit::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Ifetch_unit,FUNCTION,"Begin");
    delete _param_address_management;
    delete _param_ifetch_queue      ;
    delete _param_ifetch_unit_glue  ;
    log_printf(FUNC,Ifetch_unit,FUNCTION,"End");
  };

}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
