/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/SelfTest/include/test.h"

#define NB_PARAMS 0

void usage (int argc, char * argv[])
{
  cerr << "<Usage> " << argv[0] << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - nb_port_read          (uint32_t   )" << endl
       << " - nb_port_write         (uint32_t   )" << endl
       << " - nb_word               (uint32_t   )" << endl
       << " - size_word             (uint32_t   )" << endl
       << " - nb_bank               (uint32_t   )" << endl
       << " - nb_port_read_by_bank  (uint32_t   )" << endl
       << " - nb_port_write_by_bank (uint32_t   )" << endl
       << " - crossbar              (Tcrossbar_t)" << endl
       << " - instance *            (Tinstance_t)" << endl
       << "" << endl;

  for (int i=0; i<argc; i++)
    cerr << argv[i] << " ";
  cerr << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < 2+NB_PARAMS)
    usage (argc, argv);

  const string   name      = argv[1];
  const uint32_t    nb_port_read          = atoi(argv[2]);
  const uint32_t    nb_port_write         = atoi(argv[3]);
  const uint32_t    nb_word               = atoi(argv[4]);
  const uint32_t    size_word             = atoi(argv[5]);
  const uint32_t    nb_bank               = atoi(argv[6]);
  const uint32_t    nb_port_read_by_bank  = atoi(argv[7]);
  const uint32_t    nb_port_write_by_bank = atoi(argv[8]);
  const Tcrossbar_t crossbar              = fromString<Tcrossbar_t>(argv[9]);
  const morpheo::behavioural::generic::registerfile::Tinstance_t instance              = (strcmp(argv[10], "0") == 0)?instance_RegisterFile_Monolithic:instance_RegisterFile_Multi_Banked;

  try 
    {
      morpheo::behavioural::generic::registerfile::Parameters * param;

      if (instance == instance_RegisterFile_Monolithic)
	{
	  morpheo::behavioural::generic::registerfile::registerfile_monolithic  ::Parameters * param1 = new morpheo::behavioural::generic::registerfile::registerfile_monolithic  ::Parameters (nb_port_read         ,
																								nb_port_write        ,
																								0                    ,
																								nb_word              ,
																								size_word            );
	  
	  param = new morpheo::behavioural::generic::registerfile::Parameters(param1);
	}
      else
	{
	  morpheo::behavioural::generic::registerfile::registerfile_multi_banked::Parameters * param2 = new morpheo::behavioural::generic::registerfile::registerfile_multi_banked::Parameters (nb_port_read         ,
																								nb_port_write        ,
																								nb_word              ,
																								size_word            ,
																								nb_bank              ,
																								nb_port_read_by_bank ,
																								nb_port_write_by_bank,
																								crossbar             );
	  
	  param = new morpheo::behavioural::generic::registerfile::Parameters(param2);
	}
      
      cout << param->print(1);
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

