/*
 * $Id: Signal_set_port.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Signal.h"


namespace morpheo              {
namespace behavioural          {

#ifdef VHDL
  void Signal::set_port (Vhdl * & vhdl)
  {
    log_printf(FUNC,Behavioural,"set_port (Vhdl)","Begin");

    if ((_presence_port == PORT_VHDL_YES_TESTBENCH_YES) or
	(_presence_port == PORT_VHDL_YES_TESTBENCH_NO ) or
	(_presence_port == CLOCK_VHDL_YES)              or
	(_presence_port == RESET_VHDL_YES))
      vhdl->set_port (_name,_direction,_size);

    log_printf(FUNC,Behavioural,"set_port (Vhdl)","End");
  };

#ifdef VHDL_TESTBENCH
  void Signal::set_signal (Vhdl * & vhdl)
  {
    log_printf(FUNC,Behavioural,"set_signal (Vhdl)","Begin");
    
    if (   (_presence_port == PORT_VHDL_YES_TESTBENCH_YES)
	or (_presence_port == PORT_VHDL_NO_TESTBENCH_YES )
// 	or (_presence_port == CLOCK_VHDL_YES)
// 	or (_presence_port == CLOCK_VHDL_NO )
// 	or (_presence_port == RESET_VHDL_YES)
// 	or (_presence_port == RESET_VHDL_NO ) 
	)
      vhdl->set_signal (_name        ,_size);

    if (_direction == OUT)
      vhdl->set_signal (_name+"_test",_size);

    log_printf(FUNC,Behavioural,"set_signal (Vhdl)","End");
  };
#endif
#endif

}; // end namespace behavioural          
}; // end namespace morpheo              
