/*
 * $Id: Parameters.cpp 83 2008-05-09 18:00:21Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


#undef  FUNCTION
#define FUNCTION "Context_State::Parameters"
  Parameters::Parameters (uint32_t   nb_context,
			  uint32_t   nb_decod_unit,
			  uint32_t   nb_ooo_engine,
			  uint32_t   nb_inst_branch_complete,
			  uint32_t * size_depth,                
			  uint32_t   size_address,
			  uint32_t * size_inst_decod,           
			  uint32_t * size_inst_commit,          
			  uint32_t * link_context_to_decod_unit,
			  uint32_t * link_decod_unit_to_ooo_engine)
  {
    log_begin(Context_State,FUNCTION);

    _nb_context                    = nb_context                   ;
    _nb_decod_unit                 = nb_decod_unit                ;
    _nb_ooo_engine                 = nb_ooo_engine                ;
    _nb_inst_branch_complete       = nb_inst_branch_complete      ;
    _size_depth                    = size_depth                   ;
    _size_address                  = size_address                 ;
    _size_inst_decod               = size_inst_decod              ;
    _size_inst_commit              = size_inst_commit             ;
    _link_context_to_decod_unit    = link_context_to_decod_unit   ;
    _link_decod_unit_to_ooo_engine = link_decod_unit_to_ooo_engine;
    
    _size_context_id               = log2(_nb_context);
    _size_max_depth                = max<uint32_t>(_size_depth,_nb_context);

    _have_port_context_id          = (_size_context_id>0);
    _have_port_max_depth           = (_size_max_depth >0);
    _have_port_depth               = new bool [_nb_context];
    for (uint32_t i=0; i<_nb_context; i++)
      _have_port_depth [i] = (_size_depth [i] >0);
    
    test();
    log_end(Context_State,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Context_State::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Context_State,FUNCTION);
//     test();
//     log_end(Context_State,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Context_State::~Parameters"
  Parameters::~Parameters () 
  {
    log_begin(Context_State,FUNCTION);
    delete [] _have_port_depth;
    log_end(Context_State,FUNCTION);
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
