#ifdef SYSTEMC
/*
 * $Id: Meta_Predictor_Glue_genMealy_branch_complete_ack.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace meta_predictor_glue {

  void Meta_Predictor_Glue::genMealy_branch_complete_ack (void)
  {
    log_printf(FUNC,Meta_Predictor_Glue,"genMealy_branch_complete_ack","Begin");
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	Tcontrol_t predictor_0_ack =  not _param._have_meta_predictor or PORT_READ(in_BRANCH_COMPLETE_PREDICTOR_0_ACK [i]);
	Tcontrol_t predictor_1_ack =  not _param._have_meta_predictor or PORT_READ(in_BRANCH_COMPLETE_PREDICTOR_1_ACK [i]);
	Tcontrol_t predictor_2_ack =                                     PORT_READ(in_BRANCH_COMPLETE_PREDICTOR_2_ACK [i]);

	PORT_WRITE(out_BRANCH_COMPLETE_ACK [i], predictor_0_ack and predictor_1_ack and predictor_2_ack);
      }

    log_printf(FUNC,Meta_Predictor_Glue,"genMealy_branch_complete_ack","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
