#include "../include/Segment.h"
#include <sstream>

namespace environment {
namespace data {

  std::string Segment::print(uint32_t depth)
  {
    std::ostringstream out("");
    std::string tab = std::string(depth,'\t');


    out << tab << "Segment \"" << name << "\""     << std::endl
        << std::hex
        << tab << "  * base     : " << std::setw(8) << std::setfill('0') << base << std::endl
        << tab << "  * size     : " << std::setw(8) << std::setfill('0') << size << std::endl
        << std::dec
        << tab << "  * uncached : " << uncached    << std::endl
        << tab << "  * type     : " << type;

    return out.str();
  }
  
  std::ostream& operator<< (std::ostream& output, Segment & x)
  {
    output << x.print(0);
	
    return output;
  };
  
};
};
