/*
 * $Id: Instance_getLink.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Instance.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Instance::getLink"
  std::vector<std::string> Instance::getLink (const char * name, ...)
  {
    log_begin(Configuration,FUNCTION);

    std::string src = "";
    std::string dest;

    // Create src id
    {
      va_list args;
      va_start(args, name);

      std::string tmp;
      while ((tmp = va_arg(args,const char *)) != "")
        {
          if (src == "")
            src = tmp;
          else
            src += "." + tmp;
        }
      va_end(args);
    }

    // Find link
    bool find = true;
    
    {
      // find link
      list_links_t::iterator it1=_list_links->find(name);
      
      if (it1 == _list_links->end())
        {
//        log_printf(INFO,Configuration,FUNCTION,_("Link       \"%s\" is not define, don't link."),name);
          find = false;
        }
      else
        {
          // Find src
          list_link_t::iterator it2=it1->second.find(src);
          
          if (it2 == it1->second.end())
            {
//            log_printf(INFO,Configuration,FUNCTION,_("Link       \"%s[%s]\" is not define, don't link."),name,src.c_str());
              find = false;
            }
          else
            {
              if (it2->second->_use)
                throw ERRORMORPHEO(FUNCTION,toString(_("Link \"%s[%s]\" is already used.\n"),name,src.c_str()));

              dest = it2->second->_dest;
              it2->second->_use = true; // now, this parameters is use
            }
        }
    }

    std::vector<std::string> _return;
    if (find)
      {
        _return = link2array(dest);
        log_printf(INFO,Configuration,FUNCTION,_("Link       \"%s[%s]\"= %s."),name,src.c_str(),dest.c_str());
      }
    else
      {
        _return.clear();
        log_printf(INFO,Configuration,FUNCTION,_("Link       \"%s[%s]\" not find."),name,src.c_str());
      }

    log_end(Configuration,FUNCTION);

    return _return;
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
