/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Core_Glue/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/BitManipulation.h"

void test (string name,
	   morpheo::behavioural::core::core_glue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Core_Glue * _Core_Glue = new Core_Glue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC2_SC_SIGNAL(out_RENAME_FRONT_END_ID                       ,"out_RENAME_FRONT_END_ID                       ",Tcontext_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_VAL             ,"out_BRANCH_COMPLETE_FRONT_END_VAL             ",Tcontrol_t        ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL( in_BRANCH_COMPLETE_FRONT_END_ACK             ," in_BRANCH_COMPLETE_FRONT_END_ACK             ",Tcontrol_t        ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_CONTEXT_ID      ,"out_BRANCH_COMPLETE_FRONT_END_CONTEXT_ID      ",Tcontext_t        ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_DEPTH           ,"out_BRANCH_COMPLETE_FRONT_END_DEPTH           ",Tdepth_t          ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_ADDRESS         ,"out_BRANCH_COMPLETE_FRONT_END_ADDRESS         ",Taddress_t        ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_FLAG            ,"out_BRANCH_COMPLETE_FRONT_END_FLAG            ",Tcontrol_t        ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL( in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION ," in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION ",Tcontrol_t        ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_VAL            ," in_BRANCH_COMPLETE_OOO_ENGINE_VAL            ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL(out_BRANCH_COMPLETE_OOO_ENGINE_ACK            ,"out_BRANCH_COMPLETE_OOO_ENGINE_ACK            ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID   ," in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID   ",Tcontext_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID     ," in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID     ",Tcontext_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH          ," in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH          ",Tdepth_t          ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS        ," in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS        ",Taddress_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_FLAG           ," in_BRANCH_COMPLETE_OOO_ENGINE_FLAG           ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  ALLOC2_SC_SIGNAL(out_BRANCH_COMPLETE_OOO_ENGINE_MISS_PREDICTION,"out_BRANCH_COMPLETE_OOO_ENGINE_MISS_PREDICTION",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  ALLOC1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_VAL                ,"out_COMMIT_EVENT_FRONT_END_VAL                ",Tcontrol_t        ,_param->_nb_front_end);
  ALLOC1_SC_SIGNAL( in_COMMIT_EVENT_FRONT_END_ACK                ," in_COMMIT_EVENT_FRONT_END_ACK                ",Tcontrol_t        ,_param->_nb_front_end);
  ALLOC1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_CONTEXT_ID         ,"out_COMMIT_EVENT_FRONT_END_CONTEXT_ID         ",Tcontext_t        ,_param->_nb_front_end);
  ALLOC1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_DEPTH              ,"out_COMMIT_EVENT_FRONT_END_DEPTH              ",Tdepth_t          ,_param->_nb_front_end);
  ALLOC1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_TYPE               ,"out_COMMIT_EVENT_FRONT_END_TYPE               ",Tevent_type_t     ,_param->_nb_front_end);
  ALLOC1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_IS_DELAY_SLOT      ,"out_COMMIT_EVENT_FRONT_END_IS_DELAY_SLOT      ",Tcontrol_t        ,_param->_nb_front_end);
  ALLOC1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS            ,"out_COMMIT_EVENT_FRONT_END_ADDRESS            ",Taddress_t        ,_param->_nb_front_end);
  ALLOC1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR       ,"out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR       ",Taddress_t        ,_param->_nb_front_end);
  ALLOC1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR_VAL   ,"out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR_VAL   ",Tcontrol_t        ,_param->_nb_front_end);
  ALLOC1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR       ,"out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR       ",Taddress_t        ,_param->_nb_front_end);
  ALLOC1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_VAL               ," in_COMMIT_EVENT_OOO_ENGINE_VAL               ",Tcontrol_t        ,_param->_nb_ooo_engine);
  ALLOC1_SC_SIGNAL(out_COMMIT_EVENT_OOO_ENGINE_ACK               ,"out_COMMIT_EVENT_OOO_ENGINE_ACK               ",Tcontrol_t        ,_param->_nb_ooo_engine);
  ALLOC1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID      ," in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID      ",Tcontext_t        ,_param->_nb_ooo_engine);
  ALLOC1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID        ," in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID        ",Tcontext_t        ,_param->_nb_ooo_engine);
  ALLOC1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_DEPTH             ," in_COMMIT_EVENT_OOO_ENGINE_DEPTH             ",Tdepth_t          ,_param->_nb_ooo_engine);
  ALLOC1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_TYPE              ," in_COMMIT_EVENT_OOO_ENGINE_TYPE              ",Tevent_type_t     ,_param->_nb_ooo_engine);
  ALLOC1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT     ," in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT     ",Tcontrol_t        ,_param->_nb_ooo_engine);
  ALLOC1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS           ," in_COMMIT_EVENT_OOO_ENGINE_ADDRESS           ",Taddress_t        ,_param->_nb_ooo_engine);
  ALLOC1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR      ," in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR      ",Taddress_t        ,_param->_nb_ooo_engine);
  ALLOC1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL  ," in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL  ",Tcontrol_t        ,_param->_nb_ooo_engine);
  ALLOC1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR      ," in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR      ",Taddress_t        ,_param->_nb_ooo_engine);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_VAL                      ," in_ISSUE_OOO_ENGINE_VAL                      ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_OOO_ENGINE_ACK                      ,"out_ISSUE_OOO_ENGINE_ACK                      ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_FRONT_END_ID             ," in_ISSUE_OOO_ENGINE_FRONT_END_ID             ",Tcontext_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_CONTEXT_ID               ," in_ISSUE_OOO_ENGINE_CONTEXT_ID               ",Tcontext_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_PACKET_ID                ," in_ISSUE_OOO_ENGINE_PACKET_ID                ",Tpacket_t         ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_TYPE                     ," in_ISSUE_OOO_ENGINE_TYPE                     ",Ttype_t           ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_OPERATION                ," in_ISSUE_OOO_ENGINE_OPERATION                ",Toperation_t      ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE    ," in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE    ",Tlsq_ptr_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE     ," in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE     ",Tlsq_ptr_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT             ," in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT             ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_IMMEDIAT                 ," in_ISSUE_OOO_ENGINE_IMMEDIAT                 ",Tgeneral_data_t   ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_READ_RA                  ," in_ISSUE_OOO_ENGINE_READ_RA                  ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RA               ," in_ISSUE_OOO_ENGINE_NUM_REG_RA               ",Tgeneral_address_t,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_READ_RB                  ," in_ISSUE_OOO_ENGINE_READ_RB                  ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RB               ," in_ISSUE_OOO_ENGINE_NUM_REG_RB               ",Tgeneral_address_t,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_READ_RC                  ," in_ISSUE_OOO_ENGINE_READ_RC                  ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RC               ," in_ISSUE_OOO_ENGINE_NUM_REG_RC               ",Tspecial_address_t,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_WRITE_RD                 ," in_ISSUE_OOO_ENGINE_WRITE_RD                 ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RD               ," in_ISSUE_OOO_ENGINE_NUM_REG_RD               ",Tgeneral_address_t,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_WRITE_RE                 ," in_ISSUE_OOO_ENGINE_WRITE_RE                 ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RE               ," in_ISSUE_OOO_ENGINE_NUM_REG_RE               ",Tspecial_address_t,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_VAL                    ,"out_ISSUE_EXECUTE_LOOP_VAL                    ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_EXECUTE_LOOP_ACK                    ," in_ISSUE_EXECUTE_LOOP_ACK                    ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_CONTEXT_ID             ,"out_ISSUE_EXECUTE_LOOP_CONTEXT_ID             ",Tcontext_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_FRONT_END_ID           ,"out_ISSUE_EXECUTE_LOOP_FRONT_END_ID           ",Tcontext_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID          ,"out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID          ",Tcontext_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_PACKET_ID              ,"out_ISSUE_EXECUTE_LOOP_PACKET_ID              ",Tpacket_t         ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_OPERATION              ,"out_ISSUE_EXECUTE_LOOP_OPERATION              ",Toperation_t      ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_TYPE                   ,"out_ISSUE_EXECUTE_LOOP_TYPE                   ",Ttype_t           ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE  ,"out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE  ",Tlsq_ptr_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE   ,"out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE   ",Tlsq_ptr_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT           ,"out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT           ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_IMMEDIAT               ,"out_ISSUE_EXECUTE_LOOP_IMMEDIAT               ",Tgeneral_data_t   ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_READ_RA                ,"out_ISSUE_EXECUTE_LOOP_READ_RA                ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RA             ,"out_ISSUE_EXECUTE_LOOP_NUM_REG_RA             ",Tgeneral_address_t,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_READ_RB                ,"out_ISSUE_EXECUTE_LOOP_READ_RB                ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RB             ,"out_ISSUE_EXECUTE_LOOP_NUM_REG_RB             ",Tgeneral_address_t,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_READ_RC                ,"out_ISSUE_EXECUTE_LOOP_READ_RC                ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RC             ,"out_ISSUE_EXECUTE_LOOP_NUM_REG_RC             ",Tspecial_address_t,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_WRITE_RD               ,"out_ISSUE_EXECUTE_LOOP_WRITE_RD               ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RD             ,"out_ISSUE_EXECUTE_LOOP_NUM_REG_RD             ",Tgeneral_address_t,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_WRITE_RE               ,"out_ISSUE_EXECUTE_LOOP_WRITE_RE               ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RE             ,"out_ISSUE_EXECUTE_LOOP_NUM_REG_RE             ",Tspecial_address_t,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  ALLOC3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_VAL                    ,"out_EXECUTE_OOO_ENGINE_VAL                    ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  ALLOC3_SC_SIGNAL( in_EXECUTE_OOO_ENGINE_ACK                    ," in_EXECUTE_OOO_ENGINE_ACK                    ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  ALLOC3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_FRONT_END_ID           ,"out_EXECUTE_OOO_ENGINE_FRONT_END_ID           ",Tcontext_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  ALLOC3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_CONTEXT_ID             ,"out_EXECUTE_OOO_ENGINE_CONTEXT_ID             ",Tcontext_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  ALLOC3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_PACKET_ID              ,"out_EXECUTE_OOO_ENGINE_PACKET_ID              ",Tpacket_t         ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
//ALLOC3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_TYPE                   ,"out_EXECUTE_OOO_ENGINE_TYPE                   ",Ttype_t           ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
//ALLOC3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_OPERATION              ,"out_EXECUTE_OOO_ENGINE_OPERATION              ",Toperation_t      ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  ALLOC3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_FLAGS                  ,"out_EXECUTE_OOO_ENGINE_FLAGS                  ",Tspecial_data_t   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  ALLOC3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_EXCEPTION              ,"out_EXECUTE_OOO_ENGINE_EXCEPTION              ",Texception_t      ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  ALLOC3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_NO_SEQUENCE            ,"out_EXECUTE_OOO_ENGINE_NO_SEQUENCE            ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  ALLOC3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_ADDRESS                ,"out_EXECUTE_OOO_ENGINE_ADDRESS                ",Tgeneral_data_t   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  ALLOC3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_DATA                   ,"out_EXECUTE_OOO_ENGINE_DATA                   ",Tgeneral_data_t   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_VAL                  ," in_EXECUTE_EXECUTE_LOOP_VAL                  ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  ALLOC2_SC_SIGNAL(out_EXECUTE_EXECUTE_LOOP_ACK                  ,"out_EXECUTE_EXECUTE_LOOP_ACK                  ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID           ," in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID           ",Tcontext_t        ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID         ," in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID         ",Tcontext_t        ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID        ," in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID        ",Tcontext_t        ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_PACKET_ID            ," in_EXECUTE_EXECUTE_LOOP_PACKET_ID            ",Tpacket_t         ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
//ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_OPERATION            ," in_EXECUTE_EXECUTE_LOOP_OPERATION            ",Toperation_t      ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
//ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_TYPE                 ," in_EXECUTE_EXECUTE_LOOP_TYPE                 ",Ttype_t           ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_FLAGS                ," in_EXECUTE_EXECUTE_LOOP_FLAGS                ",Tspecial_data_t   ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_EXCEPTION            ," in_EXECUTE_EXECUTE_LOOP_EXCEPTION            ",Texception_t      ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE          ," in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE          ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_ADDRESS              ," in_EXECUTE_EXECUTE_LOOP_ADDRESS              ",Tgeneral_data_t   ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_DATA                 ," in_EXECUTE_EXECUTE_LOOP_DATA                 ",Tgeneral_data_t   ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_OOO_ENGINE_VAL                     ," in_INSERT_OOO_ENGINE_VAL                     ",Tcontrol_t          ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL(out_INSERT_OOO_ENGINE_ACK                     ,"out_INSERT_OOO_ENGINE_ACK                     ",Tcontrol_t          ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_OOO_ENGINE_RD_USE                  ," in_INSERT_OOO_ENGINE_RD_USE                  ",Tcontrol_t          ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_OOO_ENGINE_RD_NUM_REG              ," in_INSERT_OOO_ENGINE_RD_NUM_REG              ",Tgeneral_address_t  ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_OOO_ENGINE_RE_USE                  ," in_INSERT_OOO_ENGINE_RE_USE                  ",Tcontrol_t          ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_OOO_ENGINE_RE_NUM_REG              ," in_INSERT_OOO_ENGINE_RE_NUM_REG              ",Tspecial_address_t  ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  ALLOC3_SC_SIGNAL(out_INSERT_EXECUTE_LOOP_VAL                   ,"out_INSERT_EXECUTE_LOOP_VAL                   ",Tcontrol_t          ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  ALLOC3_SC_SIGNAL( in_INSERT_EXECUTE_LOOP_ACK                   ," in_INSERT_EXECUTE_LOOP_ACK                   ",Tcontrol_t          ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  ALLOC3_SC_SIGNAL(out_INSERT_EXECUTE_LOOP_RD_USE                ,"out_INSERT_EXECUTE_LOOP_RD_USE                ",Tcontrol_t          ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  ALLOC3_SC_SIGNAL(out_INSERT_EXECUTE_LOOP_RD_NUM_REG            ,"out_INSERT_EXECUTE_LOOP_RD_NUM_REG            ",Tgeneral_address_t  ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  ALLOC3_SC_SIGNAL(out_INSERT_EXECUTE_LOOP_RE_USE                ,"out_INSERT_EXECUTE_LOOP_RE_USE                ",Tcontrol_t          ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  ALLOC3_SC_SIGNAL(out_INSERT_EXECUTE_LOOP_RE_NUM_REG            ,"out_INSERT_EXECUTE_LOOP_RE_NUM_REG            ",Tspecial_address_t  ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);

  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Core_Glue.\n"),name.c_str());

  (*(_Core_Glue->in_CLOCK))        (*(in_CLOCK));
  (*(_Core_Glue->in_NRESET))       (*(in_NRESET));

  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_RENAME_FRONT_END_ID                       ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_BRANCH_COMPLETE_FRONT_END_VAL             ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_BRANCH_COMPLETE_FRONT_END_ACK             ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_BRANCH_COMPLETE_FRONT_END_CONTEXT_ID      ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  if (_param->_have_port_depth)
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_BRANCH_COMPLETE_FRONT_END_DEPTH           ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_BRANCH_COMPLETE_FRONT_END_ADDRESS         ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_BRANCH_COMPLETE_FRONT_END_FLAG            ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_BRANCH_COMPLETE_OOO_ENGINE_VAL            ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_BRANCH_COMPLETE_OOO_ENGINE_ACK            ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID     ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  if (_param->_have_port_depth)
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH          ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_BRANCH_COMPLETE_OOO_ENGINE_FLAG           ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_BRANCH_COMPLETE_OOO_ENGINE_MISS_PREDICTION,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  INSTANCE1_SC_SIGNAL(_Core_Glue,out_COMMIT_EVENT_FRONT_END_VAL                ,_param->_nb_front_end);
  INSTANCE1_SC_SIGNAL(_Core_Glue, in_COMMIT_EVENT_FRONT_END_ACK                ,_param->_nb_front_end);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Core_Glue,out_COMMIT_EVENT_FRONT_END_CONTEXT_ID         ,_param->_nb_front_end);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Core_Glue,out_COMMIT_EVENT_FRONT_END_DEPTH              ,_param->_nb_front_end);
  INSTANCE1_SC_SIGNAL(_Core_Glue,out_COMMIT_EVENT_FRONT_END_TYPE               ,_param->_nb_front_end);
  INSTANCE1_SC_SIGNAL(_Core_Glue,out_COMMIT_EVENT_FRONT_END_IS_DELAY_SLOT      ,_param->_nb_front_end);
  INSTANCE1_SC_SIGNAL(_Core_Glue,out_COMMIT_EVENT_FRONT_END_ADDRESS            ,_param->_nb_front_end);
  INSTANCE1_SC_SIGNAL(_Core_Glue,out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR       ,_param->_nb_front_end);
  INSTANCE1_SC_SIGNAL(_Core_Glue,out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR_VAL   ,_param->_nb_front_end);
  INSTANCE1_SC_SIGNAL(_Core_Glue,out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR       ,_param->_nb_front_end);
  INSTANCE1_SC_SIGNAL(_Core_Glue, in_COMMIT_EVENT_OOO_ENGINE_VAL               ,_param->_nb_ooo_engine);
  INSTANCE1_SC_SIGNAL(_Core_Glue,out_COMMIT_EVENT_OOO_ENGINE_ACK               ,_param->_nb_ooo_engine);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Core_Glue, in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID      ,_param->_nb_ooo_engine);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Core_Glue, in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID        ,_param->_nb_ooo_engine);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Core_Glue, in_COMMIT_EVENT_OOO_ENGINE_DEPTH             ,_param->_nb_ooo_engine);
  INSTANCE1_SC_SIGNAL(_Core_Glue, in_COMMIT_EVENT_OOO_ENGINE_TYPE              ,_param->_nb_ooo_engine);
  INSTANCE1_SC_SIGNAL(_Core_Glue, in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT     ,_param->_nb_ooo_engine);
  INSTANCE1_SC_SIGNAL(_Core_Glue, in_COMMIT_EVENT_OOO_ENGINE_ADDRESS           ,_param->_nb_ooo_engine);
  INSTANCE1_SC_SIGNAL(_Core_Glue, in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR      ,_param->_nb_ooo_engine);
  INSTANCE1_SC_SIGNAL(_Core_Glue, in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL  ,_param->_nb_ooo_engine);
  INSTANCE1_SC_SIGNAL(_Core_Glue, in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR      ,_param->_nb_ooo_engine);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_VAL                      ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_OOO_ENGINE_ACK                      ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_FRONT_END_ID             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_CONTEXT_ID               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  if (_param->_have_port_rob_ptr)
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_PACKET_ID                ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_TYPE                     ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_OPERATION                ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE    ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]); 
  if (_param->_have_port_load_queue_ptr)
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE     ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_IMMEDIAT                 ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_READ_RA                  ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_NUM_REG_RA               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_READ_RB                  ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_NUM_REG_RB               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_READ_RC                  ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_NUM_REG_RC               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_WRITE_RD                 ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_NUM_REG_RD               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_WRITE_RE                 ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_OOO_ENGINE_NUM_REG_RE               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_VAL                    ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_ISSUE_EXECUTE_LOOP_ACK                    ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_CONTEXT_ID             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_FRONT_END_ID           ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID          ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  if (_param->_have_port_rob_ptr)
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_PACKET_ID              ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_OPERATION              ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_TYPE                   ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE  ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE   ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT           ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_IMMEDIAT               ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_READ_RA                ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_NUM_REG_RA             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_READ_RB                ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_NUM_REG_RB             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_READ_RC                ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_NUM_REG_RC             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_WRITE_RD               ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_NUM_REG_RD             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_WRITE_RE               ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_ISSUE_EXECUTE_LOOP_NUM_REG_RE             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_EXECUTE_OOO_ENGINE_VAL                    ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Core_Glue, in_EXECUTE_OOO_ENGINE_ACK                    ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  if (_param->_have_port_front_end_id)
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_EXECUTE_OOO_ENGINE_FRONT_END_ID           ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  if (_param->_have_port_context_id)
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_EXECUTE_OOO_ENGINE_CONTEXT_ID             ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  if (_param->_have_port_rob_ptr)
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_EXECUTE_OOO_ENGINE_PACKET_ID              ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
//INSTANCE3_SC_SIGNAL(_Core_Glue,out_EXECUTE_OOO_ENGINE_TYPE                   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
//INSTANCE3_SC_SIGNAL(_Core_Glue,out_EXECUTE_OOO_ENGINE_OPERATION              ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_EXECUTE_OOO_ENGINE_FLAGS                  ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_EXECUTE_OOO_ENGINE_EXCEPTION              ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_EXECUTE_OOO_ENGINE_NO_SEQUENCE            ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_EXECUTE_OOO_ENGINE_ADDRESS                ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_EXECUTE_OOO_ENGINE_DATA                   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_VAL                  ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_EXECUTE_EXECUTE_LOOP_ACK                  ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID           ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID         ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID        ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  if (_param->_have_port_rob_ptr)
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_PACKET_ID            ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
//INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_OPERATION            ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
//INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_TYPE                 ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_FLAGS                ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_EXCEPTION            ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE          ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_ADDRESS              ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_EXECUTE_EXECUTE_LOOP_DATA                 ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_INSERT_OOO_ENGINE_VAL                     ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue,out_INSERT_OOO_ENGINE_ACK                     ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_INSERT_OOO_ENGINE_RD_USE                  ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_INSERT_OOO_ENGINE_RD_NUM_REG              ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_INSERT_OOO_ENGINE_RE_USE                  ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Core_Glue, in_INSERT_OOO_ENGINE_RE_NUM_REG              ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_INSERT_EXECUTE_LOOP_VAL                   ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Core_Glue, in_INSERT_EXECUTE_LOOP_ACK                   ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_INSERT_EXECUTE_LOOP_RD_USE                ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_INSERT_EXECUTE_LOOP_RD_NUM_REG            ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_INSERT_EXECUTE_LOOP_RE_USE                ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Core_Glue,out_INSERT_EXECUTE_LOOP_RE_NUM_REG            ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Test RENAME_FRONT_END_ID");
  if (_param->_have_port_front_end_id)
    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      for (uint32_t j=0; j<_param->_nb_inst_decod [i]; ++j)
        {
          Tcontext_t id = out_RENAME_FRONT_END_ID [i][j]->read();
          bool       find = false;

          for (uint32_t x=0; x<_param->_nb_ooo_engine; ++x)
            if ((id < _param->_ooo_engine_nb_front_end [x]) and    // Valid value
                (_param->_translate_ooo_engine_num_front_end [x][id] == i)) // Correctness of translation
              find = true;
          TEST(bool,find,true);
        }

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      //---------------------------------------------------------------------------------
      // BRANCH_COMPLETE : random input
      //---------------------------------------------------------------------------------
      for (uint32_t i=0; i<_param->_nb_front_end; ++i)
        for (uint32_t j=0; j<_param->_front_end_nb_inst_branch_complete[i]; ++j)
          {
            in_BRANCH_COMPLETE_FRONT_END_ACK             [i][j]->write(rand()%2);
            in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION [i][j]->write(rand()%2);
          }

      for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
        for (uint32_t j=0; j<_param->_ooo_engine_nb_inst_branch_complete[i]; ++j)
          {
            Tcontext_t front_end_id   = rand() % _param->_ooo_engine_nb_front_end [i];
            Tcontext_t num_front_end  = _param->_translate_ooo_engine_num_front_end[i][front_end_id];
            Tcontext_t context_id     = rand() % _param->_nb_context[num_front_end];

            LABEL("BRANCH_COMPLETE_OOO_ENGINE [%d][%d]",i,j);
            LABEL("  * front_end    : id %d, num %d",front_end_id,num_front_end);
            LABEL("  * context      : id %d"        ,context_id);

            in_BRANCH_COMPLETE_OOO_ENGINE_VAL          [i][j]->write(rand()%2);
            in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID [i][j]->write(range<Tcontext_t>(front_end_id,_param->_size_front_end_id));
            in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID   [i][j]->write(range<Tcontext_t>(context_id  ,_param->_size_context_id  ));
            in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH        [i][j]->write(range<Tdepth_t  >(rand(),_param->_size_depth              ));
            in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS      [i][j]->write(range<Taddress_t>(rand(),_param->_size_instruction_address));
            in_BRANCH_COMPLETE_OOO_ENGINE_FLAG         [i][j]->write(rand()%2);
          }

      //---------------------------------------------------------------------------------
      // COMMIT_EVENT : random input
      //---------------------------------------------------------------------------------
      for (uint32_t i=0; i<_param->_nb_front_end; ++i)
        {
          in_COMMIT_EVENT_FRONT_END_ACK             [i]->write(rand()%2);
        }
      
      for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
        {
          Tcontext_t front_end_id   = rand() % _param->_ooo_engine_nb_front_end [i];
          Tcontext_t num_front_end  = _param->_translate_ooo_engine_num_front_end[i][front_end_id];
          Tcontext_t context_id     = rand() % _param->_nb_context[num_front_end];

          LABEL("COMMIT_EVENT_OOO_ENGINE [%d]",i);
          LABEL("  * front_end    : id %d, num %d",front_end_id,num_front_end);
          LABEL("  * context      : id %d"        ,context_id);

          in_COMMIT_EVENT_OOO_ENGINE_VAL             [i]->write(rand()%2);
          in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID    [i]->write(range<Tcontext_t>(front_end_id,_param->_size_front_end_id));
          in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID      [i]->write(range<Tcontext_t>(context_id  ,_param->_size_context_id  ));
          in_COMMIT_EVENT_OOO_ENGINE_DEPTH           [i]->write(range<Tdepth_t  >(rand(),_param->_size_depth              ));
          in_COMMIT_EVENT_OOO_ENGINE_TYPE            [i]->write(range<Tevent_type_t>(rand(),_param->_size_event_type));
          in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT   [i]->write(rand()%2);
          in_COMMIT_EVENT_OOO_ENGINE_ADDRESS         [i]->write(range<Taddress_t>(rand(),_param->_size_instruction_address));
          in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR    [i]->write(range<Taddress_t>(rand(),_param->_size_instruction_address));
          in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL[i]->write(rand()%2);
          in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR    [i]->write(range<Taddress_t>(rand(),_param->_size_instruction_address));
        }

      //---------------------------------------------------------------------------------
      // EXECUTE : random input
      //---------------------------------------------------------------------------------
      for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
        for (uint32_t j=0; j<_param->_ooo_engine_nb_execute_loop[i]; ++j)
          for (uint32_t k=0; k<_param->_nb_inst_execute [i][j]; ++j)
            in_EXECUTE_OOO_ENGINE_ACK [i][j][k]->write(rand()%2);

      for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
        for (uint32_t j=0; j<_param->_nb_write_unit[i]; ++j)
          {
            in_EXECUTE_EXECUTE_LOOP_VAL           [i][j]->write(rand()%2);

            Tcontext_t ooo_engine_id  = rand() % _param->_execute_loop_nb_ooo_engine [i];
            Tcontext_t num_ooo_engine = _param->_translate_execute_loop_num_ooo_engine[i][ooo_engine_id];
            Tcontext_t front_end_id   = rand() % _param->_ooo_engine_nb_front_end [num_ooo_engine];
            Tcontext_t num_front_end  = _param->_translate_ooo_engine_num_front_end[num_ooo_engine][front_end_id];
            Tcontext_t context_id     = rand() % _param->_nb_context[num_front_end];
            
            LABEL("EXECUTE_EXECUTE_LOOP [%d][%d]",i,j);
            LABEL("  * ooo_engine   : id %d, num %d",ooo_engine_id,num_ooo_engine);
            LABEL("  * front_end    : id %d, num %d",front_end_id,num_front_end);
            LABEL("  * context      : id %d"        ,context_id);

            in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID  [i][j]->write(range<Tcontext_t     >(front_end_id ,_param->_size_front_end_id       ));
            in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID    [i][j]->write(range<Tcontext_t     >(context_id   ,_param->_size_context_id         ));
            in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID [i][j]->write(range<Tcontext_t     >(ooo_engine_id,_param->_size_ooo_engine_id      ));
            in_EXECUTE_EXECUTE_LOOP_PACKET_ID     [i][j]->write(range<Tpacket_t      >(rand(),_param->_size_rob_ptr            ));
//          in_EXECUTE_EXECUTE_LOOP_OPERATION     [i][j]->write(range<Toperation_t   >(rand(),_param->_size_operation          ));
//          in_EXECUTE_EXECUTE_LOOP_TYPE          [i][j]->write(range<Ttype_t        >(rand(),_param->_size_type               ));
            in_EXECUTE_EXECUTE_LOOP_FLAGS         [i][j]->write(range<Tspecial_data_t>(rand(),_param->_size_special_data       ));
            in_EXECUTE_EXECUTE_LOOP_EXCEPTION     [i][j]->write(range<Texception_t   >(rand(),_param->_size_exception          ));
            in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE   [i][j]->write(rand()%2);
            in_EXECUTE_EXECUTE_LOOP_ADDRESS       [i][j]->write(range<Tgeneral_data_t>(rand(),_param->_size_general_data       ));
            in_EXECUTE_EXECUTE_LOOP_DATA          [i][j]->write(range<Tgeneral_data_t>(rand(),_param->_size_general_data       ));
          }

      //---------------------------------------------------------------------------------
      // ISSUE : random input
      //---------------------------------------------------------------------------------
      for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
        for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
          in_ISSUE_EXECUTE_LOOP_ACK [i][j]->write(rand()%2);

      for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
        for (uint32_t j=0; j<_param->_nb_inst_issue[i]; ++j)
          {
            Tcontext_t front_end_id   = rand() % _param->_ooo_engine_nb_front_end [i];
            Tcontext_t num_front_end  = _param->_translate_ooo_engine_num_front_end[i][front_end_id];
            Tcontext_t context_id     = rand() % _param->_nb_context[num_front_end];
            
            LABEL("ISSUE_OOO_ENGINE [%d][%d]",i,j);
            LABEL("  * front_end    : id %d, num %d",front_end_id,num_front_end);
            LABEL("  * context      : id %d"        ,context_id);

            in_ISSUE_OOO_ENGINE_VAL                   [i][j]->write(rand()%2);
            in_ISSUE_OOO_ENGINE_FRONT_END_ID          [i][j]->write(range<Tcontext_t     >(front_end_id ,_param->_size_front_end_id       ));
            in_ISSUE_OOO_ENGINE_CONTEXT_ID            [i][j]->write(range<Tcontext_t     >(context_id   ,_param->_size_context_id         ));
            in_ISSUE_OOO_ENGINE_PACKET_ID             [i][j]->write(range<Tpacket_t      >(rand(),_param->_size_rob_ptr            ));
            in_ISSUE_OOO_ENGINE_TYPE                  [i][j]->write(range<Toperation_t   >(rand(),_param->_size_operation          ));
            in_ISSUE_OOO_ENGINE_OPERATION             [i][j]->write(range<Ttype_t        >(rand(),_param->_size_type               ));
            in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE [i][j]->write(range<Tlsq_ptr_t     >(rand(),_param->_size_store_queue_ptr    ));
            in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE  [i][j]->write(range<Tlsq_ptr_t     >(rand(),_param->_size_load_queue_ptr     ));
            in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT          [i][j]->write(rand()%2);
            in_ISSUE_OOO_ENGINE_IMMEDIAT              [i][j]->write(i|(j<<_param->_size_ooo_engine_id));
            in_ISSUE_OOO_ENGINE_READ_RA               [i][j]->write(rand()%2);
            in_ISSUE_OOO_ENGINE_NUM_REG_RA            [i][j]->write(range<Tgeneral_address_t>(rand(),_param->_size_general_register));
            in_ISSUE_OOO_ENGINE_READ_RB               [i][j]->write(rand()%2);
            in_ISSUE_OOO_ENGINE_NUM_REG_RB            [i][j]->write(range<Tgeneral_address_t>(rand(),_param->_size_general_register));
            in_ISSUE_OOO_ENGINE_READ_RC               [i][j]->write(rand()%2);
            in_ISSUE_OOO_ENGINE_NUM_REG_RC            [i][j]->write(range<Tspecial_address_t>(rand(),_param->_size_special_register));
            in_ISSUE_OOO_ENGINE_WRITE_RD              [i][j]->write(rand()%2);
            in_ISSUE_OOO_ENGINE_NUM_REG_RD            [i][j]->write(range<Tgeneral_address_t>(rand(),_param->_size_general_register));
            in_ISSUE_OOO_ENGINE_WRITE_RE              [i][j]->write(rand()%2);
            in_ISSUE_OOO_ENGINE_NUM_REG_RE            [i][j]->write(range<Tspecial_address_t>(rand(),_param->_size_special_register));
          }

      //=================================================================================
      // TEST
      //=================================================================================
      for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
        for (uint32_t j=0; j<_param->_ooo_engine_nb_inst_branch_complete[i]; ++j)
          {
            uint32_t id= in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID [i][j]->read();
            uint32_t x = _param->_translate_ooo_engine_num_front_end[i][id];

            TEST(Tcontrol_t,out_BRANCH_COMPLETE_FRONT_END_VAL              [x][j]->read(),
                             in_BRANCH_COMPLETE_OOO_ENGINE_VAL             [i][j]->read());
            TEST(Tcontext_t,out_BRANCH_COMPLETE_FRONT_END_CONTEXT_ID       [x][j]->read(),
                             in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID      [i][j]->read());
            TEST(Tdepth_t  ,out_BRANCH_COMPLETE_FRONT_END_DEPTH            [x][j]->read(),
                             in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH           [i][j]->read());
            TEST(Taddress_t,out_BRANCH_COMPLETE_FRONT_END_ADDRESS          [x][j]->read(),
                             in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS         [i][j]->read());
            TEST(Tcontrol_t,out_BRANCH_COMPLETE_FRONT_END_FLAG             [x][j]->read(),
                             in_BRANCH_COMPLETE_OOO_ENGINE_FLAG            [i][j]->read());
            TEST(Tcontrol_t,out_BRANCH_COMPLETE_OOO_ENGINE_ACK             [i][j]->read(),
                             in_BRANCH_COMPLETE_FRONT_END_ACK              [x][j]->read());
            TEST(Tcontrol_t,out_BRANCH_COMPLETE_OOO_ENGINE_MISS_PREDICTION [i][j]->read(),
                             in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION  [x][j]->read());
          }

      for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
        {
            uint32_t id= in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID [i]->read();
            uint32_t x = _param->_translate_ooo_engine_num_front_end[i][id];


            TEST(Tcontrol_t,out_COMMIT_EVENT_FRONT_END_VAL                 [x]->read(),
                             in_COMMIT_EVENT_OOO_ENGINE_VAL                [i]->read());
            TEST(Tcontext_t,out_COMMIT_EVENT_FRONT_END_CONTEXT_ID          [x]->read(),
                             in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID         [i]->read());
            TEST(Tdepth_t  ,out_COMMIT_EVENT_FRONT_END_DEPTH               [x]->read(),
                             in_COMMIT_EVENT_OOO_ENGINE_DEPTH              [i]->read());
            TEST(Tcontrol_t,out_COMMIT_EVENT_OOO_ENGINE_ACK                [i]->read(),
                             in_COMMIT_EVENT_FRONT_END_ACK                 [x]->read());

            TEST(Tevent_type_t,out_COMMIT_EVENT_FRONT_END_TYPE             [x]->read(),
                                in_COMMIT_EVENT_OOO_ENGINE_TYPE            [i]->read());
            TEST(Tcontrol_t   ,out_COMMIT_EVENT_FRONT_END_IS_DELAY_SLOT    [x]->read(),
                                in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT   [i]->read());
            TEST(Taddress_t   ,out_COMMIT_EVENT_FRONT_END_ADDRESS          [x]->read(),
                                in_COMMIT_EVENT_OOO_ENGINE_ADDRESS         [i]->read());
            TEST(Taddress_t   ,out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR     [x]->read(),
                                in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR    [i]->read());
            TEST(Tcontrol_t   ,out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR_VAL [x]->read(),
                                in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL[i]->read());
            TEST(Taddress_t   ,out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR     [x]->read(),
                                in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR    [i]->read());
        }

      for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
        for (uint32_t j=0; j<_param->_nb_write_unit[i]; ++j)
          {
            Tcontext_t id = in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID [i][j]->read();
            Tcontext_t x  = _param->_translate_execute_loop_num_ooo_engine[i][id];
            Tcontext_t y  = _param->_translate_num_execute_loop_to_ooo_engine_execute_loop_id[i][id];

            TEST(Tcontrol_t     ,out_EXECUTE_OOO_ENGINE_VAL          [x][y][j]->read(),
                                  in_EXECUTE_EXECUTE_LOOP_VAL           [i][j]->read());
            TEST(Tcontext_t     ,out_EXECUTE_OOO_ENGINE_FRONT_END_ID [x][y][j]->read(),
                                  in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID  [i][j]->read());
            TEST(Tcontext_t     ,out_EXECUTE_OOO_ENGINE_CONTEXT_ID   [x][y][j]->read(),
                                  in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID    [i][j]->read());
            TEST(Tpacket_t      ,out_EXECUTE_OOO_ENGINE_PACKET_ID    [x][y][j]->read(),
                                  in_EXECUTE_EXECUTE_LOOP_PACKET_ID     [i][j]->read());
//          TEST(Ttype_t        ,out_EXECUTE_OOO_ENGINE_TYPE         [x][y][j]->read(),
//                                in_EXECUTE_EXECUTE_LOOP_TYPE          [i][j]->read());
//          TEST(Toperation_t   ,out_EXECUTE_OOO_ENGINE_OPERATION    [x][y][j]->read(),
//                                in_EXECUTE_EXECUTE_LOOP_OPERATION     [i][j]->read());
            TEST(Tspecial_data_t,out_EXECUTE_OOO_ENGINE_FLAGS        [x][y][j]->read(),
                                  in_EXECUTE_EXECUTE_LOOP_FLAGS         [i][j]->read());
            TEST(Texception_t   ,out_EXECUTE_OOO_ENGINE_EXCEPTION    [x][y][j]->read(),
                                  in_EXECUTE_EXECUTE_LOOP_EXCEPTION     [i][j]->read());
            TEST(Tcontrol_t     ,out_EXECUTE_OOO_ENGINE_NO_SEQUENCE  [x][y][j]->read(),
                                  in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE   [i][j]->read());
            TEST(Tgeneral_data_t,out_EXECUTE_OOO_ENGINE_ADDRESS      [x][y][j]->read(),
                                  in_EXECUTE_EXECUTE_LOOP_ADDRESS       [i][j]->read());
            TEST(Tgeneral_data_t,out_EXECUTE_OOO_ENGINE_DATA         [x][y][j]->read(),
                                  in_EXECUTE_EXECUTE_LOOP_DATA          [i][j]->read());
            TEST(Tcontrol_t     ,out_EXECUTE_EXECUTE_LOOP_ACK           [i][j]->read()   ,
                                  in_EXECUTE_OOO_ENGINE_ACK          [x][y][j]->read());
          }

      for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
        for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
          // Test transaction
          if (out_ISSUE_EXECUTE_LOOP_VAL [i][j]->read() and
               in_ISSUE_EXECUTE_LOOP_ACK [i][j]->read())
            {
              Tgeneral_data_t imm = out_ISSUE_EXECUTE_LOOP_IMMEDIAT [i][j]->read();
              Tcontext_t      x   = range<Tcontext_t>(imm,_param->_size_ooo_engine_id);
              Tcontext_t      y   = imm>>_param->_size_ooo_engine_id; // port_issue

              LABEL("ISSUE - transaction");
              LABEL("  * execute_loop : %d",i);
              LABEL("  * read_unit    : %d",j);
              LABEL("  * ooo_engine   : %d",x);
              LABEL("  * port_issue   : %d",y);
              
              TEST(Tcontext_t,x,_param->_translate_execute_loop_num_ooo_engine[i][out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID [i][j]->read()]);
              
              TEST(bool,_param->_table_dispatch [x][y][i][j],true);

              TEST(Tcontrol_t        , in_ISSUE_OOO_ENGINE_VAL                      [x][y]->read(),1);
              TEST(Tcontrol_t        ,out_ISSUE_OOO_ENGINE_ACK                      [x][y]->read(),1);

              TEST(Tcontext_t        ,out_ISSUE_EXECUTE_LOOP_FRONT_END_ID           [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_FRONT_END_ID             [x][y]->read());
              TEST(Tcontext_t        ,out_ISSUE_EXECUTE_LOOP_CONTEXT_ID             [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_CONTEXT_ID               [x][y]->read());
              TEST(Tpacket_t         ,out_ISSUE_EXECUTE_LOOP_PACKET_ID              [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_PACKET_ID                [x][y]->read());
              TEST(Ttype_t           ,out_ISSUE_EXECUTE_LOOP_TYPE                   [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_TYPE                     [x][y]->read());
              TEST(Toperation_t      ,out_ISSUE_EXECUTE_LOOP_OPERATION              [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_OPERATION                [x][y]->read());
              TEST(Tlsq_ptr_t        ,out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE  [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE    [x][y]->read());
              TEST(Tlsq_ptr_t        ,out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE   [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE     [x][y]->read());
              TEST(Tcontrol_t        ,out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT           [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT             [x][y]->read());
              TEST(Tgeneral_data_t   ,out_ISSUE_EXECUTE_LOOP_IMMEDIAT               [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_IMMEDIAT                 [x][y]->read());
              TEST(Tcontrol_t        ,out_ISSUE_EXECUTE_LOOP_READ_RA                [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_READ_RA                  [x][y]->read());
              TEST(Tgeneral_address_t,out_ISSUE_EXECUTE_LOOP_NUM_REG_RA             [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_NUM_REG_RA               [x][y]->read());
              TEST(Tcontrol_t        ,out_ISSUE_EXECUTE_LOOP_READ_RB                [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_READ_RB                  [x][y]->read());
              TEST(Tgeneral_address_t,out_ISSUE_EXECUTE_LOOP_NUM_REG_RB             [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_NUM_REG_RB               [x][y]->read());
              TEST(Tcontrol_t        ,out_ISSUE_EXECUTE_LOOP_READ_RC                [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_READ_RC                  [x][y]->read());
              TEST(Tspecial_address_t,out_ISSUE_EXECUTE_LOOP_NUM_REG_RC             [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_NUM_REG_RC               [x][y]->read());
              TEST(Tcontrol_t        ,out_ISSUE_EXECUTE_LOOP_WRITE_RD               [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_WRITE_RD                 [x][y]->read());
              TEST(Tgeneral_address_t,out_ISSUE_EXECUTE_LOOP_NUM_REG_RD             [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_NUM_REG_RD               [x][y]->read());
              TEST(Tcontrol_t        ,out_ISSUE_EXECUTE_LOOP_WRITE_RE               [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_WRITE_RE                 [x][y]->read());
              TEST(Tspecial_address_t,out_ISSUE_EXECUTE_LOOP_NUM_REG_RE             [i][j]->read(), 
                                       in_ISSUE_OOO_ENGINE_NUM_REG_RE               [x][y]->read());
            }

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE2_SC_SIGNAL(out_RENAME_FRONT_END_ID                       ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_VAL             ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL( in_BRANCH_COMPLETE_FRONT_END_ACK             ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_CONTEXT_ID      ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_DEPTH           ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_ADDRESS         ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_FLAG            ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL( in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_VAL            ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL(out_BRANCH_COMPLETE_OOO_ENGINE_ACK            ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID     ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH          ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_FLAG           ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  DELETE2_SC_SIGNAL(out_BRANCH_COMPLETE_OOO_ENGINE_MISS_PREDICTION,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
  DELETE1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_VAL                ,_param->_nb_front_end);
  DELETE1_SC_SIGNAL( in_COMMIT_EVENT_FRONT_END_ACK                ,_param->_nb_front_end);
  DELETE1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_CONTEXT_ID         ,_param->_nb_front_end);
  DELETE1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_DEPTH              ,_param->_nb_front_end);
  DELETE1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_TYPE               ,_param->_nb_front_end);
  DELETE1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_IS_DELAY_SLOT      ,_param->_nb_front_end);
  DELETE1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS            ,_param->_nb_front_end);
  DELETE1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR       ,_param->_nb_front_end);
  DELETE1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR_VAL   ,_param->_nb_front_end);
  DELETE1_SC_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR       ,_param->_nb_front_end);
  DELETE1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_VAL               ,_param->_nb_ooo_engine);
  DELETE1_SC_SIGNAL(out_COMMIT_EVENT_OOO_ENGINE_ACK               ,_param->_nb_ooo_engine);
  DELETE1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID      ,_param->_nb_ooo_engine);
  DELETE1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID        ,_param->_nb_ooo_engine);
  DELETE1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_DEPTH             ,_param->_nb_ooo_engine);
  DELETE1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_TYPE              ,_param->_nb_ooo_engine);
  DELETE1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT     ,_param->_nb_ooo_engine);
  DELETE1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS           ,_param->_nb_ooo_engine);
  DELETE1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR      ,_param->_nb_ooo_engine);
  DELETE1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL  ,_param->_nb_ooo_engine);
  DELETE1_SC_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR      ,_param->_nb_ooo_engine);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_VAL                      ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_OOO_ENGINE_ACK                      ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_FRONT_END_ID             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_CONTEXT_ID               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_PACKET_ID                ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_TYPE                     ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_OPERATION                ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE    ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE     ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_IMMEDIAT                 ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_READ_RA                  ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RA               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_READ_RB                  ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RB               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_READ_RC                  ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RC               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_WRITE_RD                 ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RD               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_WRITE_RE                 ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RE               ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_VAL                    ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_EXECUTE_LOOP_ACK                    ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_CONTEXT_ID             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_FRONT_END_ID           ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID          ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_PACKET_ID              ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_OPERATION              ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_TYPE                   ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE  ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE   ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT           ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_IMMEDIAT               ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_READ_RA                ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RA             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_READ_RB                ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RB             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_READ_RC                ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RC             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_WRITE_RD               ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RD             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_WRITE_RE               ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RE             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
  DELETE3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_VAL                    ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  DELETE3_SC_SIGNAL( in_EXECUTE_OOO_ENGINE_ACK                    ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  DELETE3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_FRONT_END_ID           ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  DELETE3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_CONTEXT_ID             ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  DELETE3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_PACKET_ID              ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
//DELETE3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_TYPE                   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
//DELETE3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_OPERATION              ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  DELETE3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_FLAGS                  ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  DELETE3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_EXCEPTION              ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  DELETE3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_NO_SEQUENCE            ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  DELETE3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_ADDRESS                ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  DELETE3_SC_SIGNAL(out_EXECUTE_OOO_ENGINE_DATA                   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
  DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_VAL                  ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  DELETE2_SC_SIGNAL(out_EXECUTE_EXECUTE_LOOP_ACK                  ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID           ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID         ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID        ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_PACKET_ID            ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
//DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_OPERATION            ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
//DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_TYPE                 ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_FLAGS                ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_EXCEPTION            ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE          ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_ADDRESS              ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_EXECUTE_LOOP_DATA                 ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_OOO_ENGINE_VAL                     ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_OOO_ENGINE_ACK                     ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_OOO_ENGINE_RD_USE                  ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_OOO_ENGINE_RD_NUM_REG              ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_OOO_ENGINE_RE_USE                  ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_OOO_ENGINE_RE_NUM_REG              ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
  DELETE3_SC_SIGNAL(out_INSERT_EXECUTE_LOOP_VAL                   ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  DELETE3_SC_SIGNAL( in_INSERT_EXECUTE_LOOP_ACK                   ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  DELETE3_SC_SIGNAL(out_INSERT_EXECUTE_LOOP_RD_USE                ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  DELETE3_SC_SIGNAL(out_INSERT_EXECUTE_LOOP_RD_NUM_REG            ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  DELETE3_SC_SIGNAL(out_INSERT_EXECUTE_LOOP_RE_USE                ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
  DELETE3_SC_SIGNAL(out_INSERT_EXECUTE_LOOP_RE_NUM_REG            ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
    }
#endif

  delete _Core_Glue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
