/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Dcache_Access/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

typedef struct
{
  uint32_t execute_loop   ;
  uint32_t load_store_unit;
  uint32_t cache_access   ;
} thread_id_t;

void test (string name,
	   morpheo::behavioural::core::dcache_access::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Dcache_Access * _Dcache_Access = new Dcache_Access 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_VAL         ,"out_DCACHE_REQ_VAL      ",Tcontrol_t        ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_REQ_ACK         ," in_DCACHE_REQ_ACK      ",Tcontrol_t        ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_THREAD_ID   ,"out_DCACHE_REQ_THREAD_ID",Tcontext_t        ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_PACKET_ID   ,"out_DCACHE_REQ_PACKET_ID",Tpacket_t         ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_ADDRESS     ,"out_DCACHE_REQ_ADDRESS  ",Tdcache_address_t ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_WDATA       ,"out_DCACHE_REQ_WDATA    ",Tdcache_data_t    ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_TYPE        ,"out_DCACHE_REQ_TYPE     ",Tdcache_type_t    ,_param->_nb_dcache_port);

  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_VAL         ," in_DCACHE_RSP_VAL      ",Tcontrol_t        ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_RSP_ACK         ,"out_DCACHE_RSP_ACK      ",Tcontrol_t        ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_THREAD_ID   ," in_DCACHE_RSP_THREAD_ID",Tcontext_t        ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_PACKET_ID   ," in_DCACHE_RSP_PACKET_ID",Tpacket_t         ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_RDATA       ," in_DCACHE_RSP_RDATA    ",Tdcache_data_t    ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_ERROR       ," in_DCACHE_RSP_ERROR    ",Tdcache_error_t   ,_param->_nb_dcache_port);

  ALLOC3_SC_SIGNAL( in_LSQ_REQ_VAL            ," in_LSQ_REQ_VAL         ",Tcontrol_t        ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  ALLOC3_SC_SIGNAL(out_LSQ_REQ_ACK            ,"out_LSQ_REQ_ACK         ",Tcontrol_t        ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  ALLOC3_SC_SIGNAL( in_LSQ_REQ_THREAD_ID      ," in_LSQ_REQ_THREAD_ID   ",Tcontext_t        ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  ALLOC3_SC_SIGNAL( in_LSQ_REQ_PACKET_ID      ," in_LSQ_REQ_PACKET_ID   ",Tpacket_t         ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  ALLOC3_SC_SIGNAL( in_LSQ_REQ_ADDRESS        ," in_LSQ_REQ_ADDRESS     ",Tdcache_address_t ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  ALLOC3_SC_SIGNAL( in_LSQ_REQ_WDATA          ," in_LSQ_REQ_WDATA       ",Tdcache_data_t    ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  ALLOC3_SC_SIGNAL( in_LSQ_REQ_TYPE           ," in_LSQ_REQ_TYPE        ",Tdcache_type_t    ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);

  ALLOC3_SC_SIGNAL(out_LSQ_RSP_VAL            ,"out_LSQ_RSP_VAL         ",Tcontrol_t        ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  ALLOC3_SC_SIGNAL( in_LSQ_RSP_ACK            ," in_LSQ_RSP_ACK         ",Tcontrol_t        ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  ALLOC3_SC_SIGNAL(out_LSQ_RSP_THREAD_ID      ,"out_LSQ_RSP_THREAD_ID   ",Tcontext_t        ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  ALLOC3_SC_SIGNAL(out_LSQ_RSP_PACKET_ID      ,"out_LSQ_RSP_PACKET_ID   ",Tpacket_t         ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  ALLOC3_SC_SIGNAL(out_LSQ_RSP_RDATA          ,"out_LSQ_RSP_RDATA       ",Tdcache_data_t    ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  ALLOC3_SC_SIGNAL(out_LSQ_RSP_ERROR          ,"out_LSQ_RSP_ERROR       ",Tdcache_error_t   ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Dcache_Access.\n"),name.c_str());

  (*(_Dcache_Access->in_CLOCK))        (*(in_CLOCK));
  (*(_Dcache_Access->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Dcache_Access,out_DCACHE_REQ_VAL         ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Dcache_Access, in_DCACHE_REQ_ACK         ,_param->_nb_dcache_port);
  if (_param->_have_port_dcache_thread_id)
  INSTANCE1_SC_SIGNAL(_Dcache_Access,out_DCACHE_REQ_THREAD_ID   ,_param->_nb_dcache_port);
  if (_param->_have_port_dcache_packet_id)
  INSTANCE1_SC_SIGNAL(_Dcache_Access,out_DCACHE_REQ_PACKET_ID   ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Dcache_Access,out_DCACHE_REQ_ADDRESS     ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Dcache_Access,out_DCACHE_REQ_WDATA       ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Dcache_Access,out_DCACHE_REQ_TYPE        ,_param->_nb_dcache_port);

  INSTANCE1_SC_SIGNAL(_Dcache_Access, in_DCACHE_RSP_VAL         ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Dcache_Access,out_DCACHE_RSP_ACK         ,_param->_nb_dcache_port);
  if (_param->_have_port_dcache_thread_id)
  INSTANCE1_SC_SIGNAL(_Dcache_Access, in_DCACHE_RSP_THREAD_ID   ,_param->_nb_dcache_port);
  if (_param->_have_port_dcache_packet_id)
  INSTANCE1_SC_SIGNAL(_Dcache_Access, in_DCACHE_RSP_PACKET_ID   ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Dcache_Access, in_DCACHE_RSP_RDATA       ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Dcache_Access, in_DCACHE_RSP_ERROR       ,_param->_nb_dcache_port);

  INSTANCE3_SC_SIGNAL(_Dcache_Access, in_LSQ_REQ_VAL            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Dcache_Access,out_LSQ_REQ_ACK            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Dcache_Access, in_LSQ_REQ_ADDRESS        ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Dcache_Access, in_LSQ_REQ_WDATA          ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Dcache_Access, in_LSQ_REQ_TYPE           ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);

  INSTANCE3_SC_SIGNAL(_Dcache_Access,out_LSQ_RSP_VAL            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Dcache_Access, in_LSQ_RSP_ACK            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Dcache_Access,out_LSQ_RSP_RDATA          ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  INSTANCE3_SC_SIGNAL(_Dcache_Access,out_LSQ_RSP_ERROR          ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);

  for (uint32_t i=0; i<_param->_nb_execute_loop; i++)
    for (uint32_t j=0; j<_param->_nb_load_store_unit[i]; j++)
      {
	if (_param->_have_port_lsq_thread_id [i][j])
	  {
	    INSTANCE1_SC_SIGNAL(_Dcache_Access, in_LSQ_REQ_THREAD_ID [i][j], _param->_nb_cache_access[i][j]);
	    INSTANCE1_SC_SIGNAL(_Dcache_Access,out_LSQ_RSP_THREAD_ID [i][j], _param->_nb_cache_access[i][j]);
	  }
	if (_param->_have_port_lsq_packet_id [i][j])
	  {
	    INSTANCE1_SC_SIGNAL(_Dcache_Access, in_LSQ_REQ_PACKET_ID [i][j], _param->_nb_cache_access[i][j]);
	    INSTANCE1_SC_SIGNAL(_Dcache_Access,out_LSQ_RSP_PACKET_ID [i][j], _param->_nb_cache_access[i][j]);
	  }
      }

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_req = 75;
  const  int32_t percent_transaction_rsp = 75;

  thread_id_t link_cache_rsp    [_param->_nb_dcache_port][_param->_nb_execute_loop*_param->_max_nb_load_store_unit*_param->_max_nb_cache_access];
  uint32_t    nb_link_cache_rsp [_param->_nb_dcache_port];
  
  for (uint32_t i=0; i<_param->_nb_dcache_port; i++)
    nb_link_cache_rsp [i] = 0;

  for (uint32_t i=0; i<_param->_nb_execute_loop; i++)
    for (uint32_t j=0; j<_param->_nb_load_store_unit [i]; j++)
      for (uint32_t k=0; k<_param->_nb_cache_access [i][j]; ++k)
	{
	  uint32_t x = _param->_table_routing [i][j][k];
	  
	  link_cache_rsp [x][nb_link_cache_rsp[x]].execute_loop    = i;
	  link_cache_rsp [x][nb_link_cache_rsp[x]].load_store_unit = j;
	  link_cache_rsp [x][nb_link_cache_rsp[x]].cache_access    = k;
	  nb_link_cache_rsp[x] ++;
	}

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      for (uint32_t i=0; i<_param->_nb_dcache_port; i++)
	{
	  in_DCACHE_REQ_ACK       [i]->write((rand()%100)<percent_transaction_req);

	  uint32_t z = rand()%nb_link_cache_rsp[i];
	  uint32_t a = link_cache_rsp[i][z].execute_loop;
	  uint32_t b = link_cache_rsp[i][z].load_store_unit  ;
	  uint32_t c = link_cache_rsp[i][z].cache_access     ;
	  
	  in_DCACHE_RSP_VAL       [i]->write((rand()%100)<percent_transaction_rsp);
	  in_DCACHE_RSP_THREAD_ID [i]->write(_param->_translate_load_store_unit_to_thread[a][b][0]);
	  in_DCACHE_RSP_PACKET_ID [i]->write((c << _param->_shift_num_cache_access));
	  in_DCACHE_RSP_RDATA     [i]->write(0);
	  in_DCACHE_RSP_ERROR     [i]->write(0);
	}

      for (uint32_t i=0; i<_param->_nb_execute_loop; i++)
	for (uint32_t j=0; j<_param->_nb_load_store_unit [i]; j++)
	  for (uint32_t k=0; k<_param->_nb_cache_access [i][j]; ++k)
	    {
	      in_LSQ_REQ_VAL        [i][j][k]->write((rand()%100)<percent_transaction_req);
	      in_LSQ_REQ_ADDRESS    [i][j][k]->write(0);
	      in_LSQ_REQ_THREAD_ID  [i][j][k]->write(0);
	      in_LSQ_REQ_PACKET_ID  [i][j][k]->write(0);
	      in_LSQ_REQ_ADDRESS    [i][j][k]->write(0);
	      in_LSQ_REQ_WDATA      [i][j][k]->write(0);
	      in_LSQ_REQ_TYPE       [i][j][k]->write(0);
	      
	      in_LSQ_RSP_ACK        [i][j][k]->write((rand()%100)<percent_transaction_rsp);
	    }

      SC_START(0);

      int32_t nb_request = 0;
      int32_t nb_respons = 0;

      for (uint32_t i=0; i<_param->_nb_dcache_port; i++)
	{
	  if (out_DCACHE_REQ_VAL [i]->read() and  in_DCACHE_REQ_ACK [i]->read())
	    {
	      LABEL("DCACHE_REQ  [%d] - Transaction Accepted.",i);

	      nb_request ++;
	    }
	  if ( in_DCACHE_RSP_VAL [i]->read() and out_DCACHE_RSP_ACK [i]->read())
	    {
	      LABEL("DCACHE_RSP  [%d] - Transaction Accepted.",i);

	      nb_respons ++;
	    }
	}

      for (uint32_t i=0; i<_param->_nb_execute_loop; i++)
	for (uint32_t j=0; j<_param->_nb_load_store_unit [i]; j++)
	  for (uint32_t k=0; k<_param->_nb_cache_access [i][j]; ++k)
	    {
	    if (in_LSQ_REQ_VAL [i][j][k]->read() and out_LSQ_REQ_ACK [i][j][k]->read())
	      {
		LABEL("LSQ_REQ [%d][%d][%d] - Transaction Accepted.",i,j,k);
		
		uint32_t x=_param->_table_routing[i][j][k];
		
		TEST(Tcontrol_t,out_DCACHE_REQ_VAL[x]->read(), 1);
		TEST(Tcontrol_t, in_DCACHE_REQ_ACK[x]->read(), 1);
		
 		TEST(Tcontext_t       ,out_DCACHE_REQ_THREAD_ID [x]->read(), _param->_translate_load_store_unit_to_thread [i][j][0]);
		TEST(Tpacket_t        ,out_DCACHE_REQ_PACKET_ID [x]->read(), (k << _param->_shift_num_cache_access));
		TEST(Tdcache_address_t,out_DCACHE_REQ_ADDRESS   [x]->read(), 0);
		TEST(Tdcache_address_t,out_DCACHE_REQ_WDATA     [x]->read(), 0);
		TEST(Tdcache_type_t   ,out_DCACHE_REQ_TYPE      [x]->read(), 0);
		
		nb_request --;
	      }

	    if (out_LSQ_RSP_VAL [i][j][k]->read() and  in_LSQ_RSP_ACK [i][j][k]->read())
	      {
		LABEL("LSQ_RSP [%d][%d][%d] - Transaction Accepted.",i,j,k);

//   public    : SC_OUT(Tcontext_t           ) **** out_LSQ_RSP_THREAD_ID      ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
//   public    : SC_OUT(Tpacket_t            ) **** out_LSQ_RSP_PACKET_ID      ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
//   public    : SC_OUT(Tdcache_data_t       ) **** out_LSQ_RSP_RDATA          ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
//   public    : SC_OUT(Tdcache_error_t      ) **** out_LSQ_RSP_ERROR          ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
		nb_respons --;
	      }
	  }
      
      TEST(int32_t, nb_request, 0);
      TEST(int32_t, nb_respons, 0);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL(out_DCACHE_REQ_VAL         ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_REQ_ACK         ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_THREAD_ID   ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_PACKET_ID   ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_ADDRESS     ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_WDATA       ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_TYPE        ,_param->_nb_dcache_port);

  DELETE1_SC_SIGNAL( in_DCACHE_RSP_VAL         ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_RSP_ACK         ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_THREAD_ID   ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_PACKET_ID   ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_RDATA       ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_ERROR       ,_param->_nb_dcache_port);

  DELETE3_SC_SIGNAL( in_LSQ_REQ_VAL            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  DELETE3_SC_SIGNAL(out_LSQ_REQ_ACK            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  DELETE3_SC_SIGNAL( in_LSQ_REQ_THREAD_ID      ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  DELETE3_SC_SIGNAL( in_LSQ_REQ_PACKET_ID      ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  DELETE3_SC_SIGNAL( in_LSQ_REQ_ADDRESS        ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  DELETE3_SC_SIGNAL( in_LSQ_REQ_WDATA          ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  DELETE3_SC_SIGNAL( in_LSQ_REQ_TYPE           ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);

  DELETE3_SC_SIGNAL(out_LSQ_RSP_VAL            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  DELETE3_SC_SIGNAL( in_LSQ_RSP_ACK            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  DELETE3_SC_SIGNAL(out_LSQ_RSP_THREAD_ID      ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  DELETE3_SC_SIGNAL(out_LSQ_RSP_PACKET_ID      ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  DELETE3_SC_SIGNAL(out_LSQ_RSP_RDATA          ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
  DELETE3_SC_SIGNAL(out_LSQ_RSP_ERROR          ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2]);
    }
#endif

  delete _Dcache_Access;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
