/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Icache_Access/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

typedef struct
{
  uint32_t front_end;
  uint32_t context;
} thread_id_t;

void test (string name,
	   morpheo::behavioural::core::icache_access::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Icache_Access * _Icache_Access = new Icache_Access 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_VAL         ,"out_ICACHE_REQ_VAL         ",Tcontrol_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL( in_ICACHE_REQ_ACK         ," in_ICACHE_REQ_ACK         ",Tcontrol_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_THREAD_ID   ,"out_ICACHE_REQ_THREAD_ID   ",Tcontext_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_PACKET_ID   ,"out_ICACHE_REQ_PACKET_ID   ",Tpacket_t            ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_ADDRESS     ,"out_ICACHE_REQ_ADDRESS     ",Ticache_address_t    ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_TYPE        ,"out_ICACHE_REQ_TYPE        ",Ticache_type_t       ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_VAL         ," in_ICACHE_RSP_VAL         ",Tcontrol_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_RSP_ACK         ,"out_ICACHE_RSP_ACK         ",Tcontrol_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_THREAD_ID   ," in_ICACHE_RSP_THREAD_ID   ",Tcontext_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_PACKET_ID   ," in_ICACHE_RSP_PACKET_ID   ",Tpacket_t            ,_param->_nb_icache_port);
  ALLOC2_SC_SIGNAL( in_ICACHE_RSP_INSTRUCTION ," in_ICACHE_RSP_INSTRUCTION ",Ticache_instruction_t,_param->_nb_icache_port,_param->_icache_nb_instruction[it1]);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_ERROR       ," in_ICACHE_RSP_ERROR       ",Ticache_error_t      ,_param->_nb_icache_port);
  ALLOC2_SC_SIGNAL( in_CONTEXT_REQ_VAL        ," in_CONTEXT_REQ_VAL        ",Tcontrol_t           ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_CONTEXT_REQ_ACK        ,"out_CONTEXT_REQ_ACK        ",Tcontrol_t           ,_param->_nb_front_end,_param->_nb_context[it1]);
//ALLOC2_SC_SIGNAL( in_CONTEXT_REQ_THREAD_ID  ," in_CONTEXT_REQ_THREAD_ID  ",Tcontext_t           ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_CONTEXT_REQ_PACKET_ID  ," in_CONTEXT_REQ_PACKET_ID  ",Tpacket_t            ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_CONTEXT_REQ_ADDRESS    ," in_CONTEXT_REQ_ADDRESS    ",Ticache_address_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_CONTEXT_REQ_TYPE       ," in_CONTEXT_REQ_TYPE       ",Ticache_type_t       ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_CONTEXT_RSP_VAL        ,"out_CONTEXT_RSP_VAL        ",Tcontrol_t           ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_CONTEXT_RSP_ACK        ," in_CONTEXT_RSP_ACK        ",Tcontrol_t           ,_param->_nb_front_end,_param->_nb_context[it1]);
//ALLOC2_SC_SIGNAL(out_CONTEXT_RSP_THREAD_ID  ,"out_CONTEXT_RSP_THREAD_ID  ",Tcontext_t           ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_CONTEXT_RSP_PACKET_ID  ,"out_CONTEXT_RSP_PACKET_ID  ",Tpacket_t            ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC3_SC_SIGNAL(out_CONTEXT_RSP_INSTRUCTION,"out_CONTEXT_RSP_INSTRUCTION",Ticache_instruction_t,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_instruction[it1][it2]);
  ALLOC2_SC_SIGNAL(out_CONTEXT_RSP_ERROR      ,"out_CONTEXT_RSP_ERROR      ",Ticache_error_t      ,_param->_nb_front_end,_param->_nb_context[it1]);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Icache_Access.\n"),name.c_str());

  (*(_Icache_Access->in_CLOCK))        (*(in_CLOCK));
  (*(_Icache_Access->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Icache_Access,out_ICACHE_REQ_VAL         ,_param->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Icache_Access, in_ICACHE_REQ_ACK         ,_param->_nb_icache_port);
  if (_param->_have_port_icache_thread_id)
  INSTANCE1_SC_SIGNAL(_Icache_Access,out_ICACHE_REQ_THREAD_ID   ,_param->_nb_icache_port);
  if (_param->_have_port_icache_packet_id)
  INSTANCE1_SC_SIGNAL(_Icache_Access,out_ICACHE_REQ_PACKET_ID   ,_param->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Icache_Access,out_ICACHE_REQ_ADDRESS     ,_param->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Icache_Access,out_ICACHE_REQ_TYPE        ,_param->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Icache_Access, in_ICACHE_RSP_VAL         ,_param->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Icache_Access,out_ICACHE_RSP_ACK         ,_param->_nb_icache_port);
  if (_param->_have_port_icache_thread_id)
  INSTANCE1_SC_SIGNAL(_Icache_Access, in_ICACHE_RSP_THREAD_ID   ,_param->_nb_icache_port);
  if (_param->_have_port_icache_packet_id)
  INSTANCE1_SC_SIGNAL(_Icache_Access, in_ICACHE_RSP_PACKET_ID   ,_param->_nb_icache_port);
  INSTANCE2_SC_SIGNAL(_Icache_Access, in_ICACHE_RSP_INSTRUCTION ,_param->_nb_icache_port,_param->_icache_nb_instruction[it1]);
  INSTANCE1_SC_SIGNAL(_Icache_Access, in_ICACHE_RSP_ERROR       ,_param->_nb_icache_port);
  INSTANCE2_SC_SIGNAL(_Icache_Access, in_CONTEXT_REQ_VAL        ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Icache_Access,out_CONTEXT_REQ_ACK        ,_param->_nb_front_end,_param->_nb_context[it1]);
//INSTANCE2_SC_SIGNAL(_Icache_Access, in_CONTEXT_REQ_THREAD_ID  ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Icache_Access, in_CONTEXT_REQ_ADDRESS    ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Icache_Access, in_CONTEXT_REQ_TYPE       ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Icache_Access,out_CONTEXT_RSP_VAL        ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Icache_Access, in_CONTEXT_RSP_ACK        ,_param->_nb_front_end,_param->_nb_context[it1]);
//INSTANCE2_SC_SIGNAL(_Icache_Access,out_CONTEXT_RSP_THREAD_ID  ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE3_SC_SIGNAL(_Icache_Access,out_CONTEXT_RSP_INSTRUCTION,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_instruction[it1][it2]);
  INSTANCE2_SC_SIGNAL(_Icache_Access,out_CONTEXT_RSP_ERROR      ,_param->_nb_front_end,_param->_nb_context[it1]);

  for (uint32_t i=0; i<_param->_nb_front_end; ++i)
    for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
      if (_param->_have_port_packet_id [i][j])
	{
	INSTANCE_SC_SIGNAL(_Icache_Access, in_CONTEXT_REQ_PACKET_ID [i][j]);
	INSTANCE_SC_SIGNAL(_Icache_Access,out_CONTEXT_RSP_PACKET_ID [i][j]);
      }

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_req = 75;
  const  int32_t percent_transaction_rsp = 75;

  thread_id_t link_cache_rsp    [_param->_nb_icache_port][_param->_nb_front_end*_param->_max_nb_context];
  uint32_t    nb_link_cache_rsp [_param->_nb_icache_port];
  
  for (uint32_t i=0; i<_param->_nb_icache_port; i++)
    nb_link_cache_rsp [i] = 0;

  for (uint32_t i=0; i<_param->_nb_front_end; i++)
    for (uint32_t j=0; j<_param->_nb_context [i]; j++)
      {
	uint32_t x = _param->_table_routing [i][j];
	
	link_cache_rsp [x][nb_link_cache_rsp[x]].front_end = i;
	link_cache_rsp [x][nb_link_cache_rsp[x]].context   = j;
	nb_link_cache_rsp[x] ++;
      }

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      for (uint32_t i=0; i<_param->_nb_icache_port; i++)
	{
	  in_ICACHE_REQ_ACK       [i]->write((rand()%100)<percent_transaction_req);

	  uint32_t z = rand()%nb_link_cache_rsp[i];
	  uint32_t x = link_cache_rsp[i][z].front_end;
	  uint32_t y = link_cache_rsp[i][z].context  ;
	  
	  in_ICACHE_RSP_VAL       [i]->write((rand()%100)<percent_transaction_rsp);
	  in_ICACHE_RSP_THREAD_ID [i]->write(_param->_translate_context_to_thread[x][y]);
	  in_ICACHE_RSP_PACKET_ID [i]->write(0);
	  in_ICACHE_RSP_ERROR     [i]->write(0);
	 
	  for (uint32_t j=0; j<_param->_icache_nb_instruction[i]; j++)
	  in_ICACHE_RSP_INSTRUCTION [i][j]->write(0);
	}

      for (uint32_t i=0; i<_param->_nb_front_end; i++)
	for (uint32_t j=0; j<_param->_nb_context [i]; j++)
	  {
	    in_CONTEXT_REQ_VAL        [i][j]->write((rand()%100)<percent_transaction_req);
	    in_CONTEXT_REQ_ADDRESS    [i][j]->write(0);
	    in_CONTEXT_REQ_PACKET_ID  [i][j]->write(0);
	    in_CONTEXT_REQ_TYPE       [i][j]->write(0);

	    in_CONTEXT_RSP_ACK        [i][j]->write((rand()%100)<percent_transaction_rsp);
	  }

      SC_START(0);

      int32_t nb_request = 0;
      int32_t nb_respons = 0;

      for (uint32_t i=0; i<_param->_nb_icache_port; i++)
	{
	  if (out_ICACHE_REQ_VAL [i]->read() and  in_ICACHE_REQ_ACK [i]->read())
	    {
	      LABEL("ICACHE_REQ  [%d] - Transaction Accepted.",i);

	      nb_request ++;
	    }
	  if ( in_ICACHE_RSP_VAL [i]->read() and out_ICACHE_RSP_ACK [i]->read())
	    {
	      LABEL("ICACHE_RSP  [%d] - Transaction Accepted.",i);

	      nb_respons ++;
	    }
	}

      for (uint32_t i=0; i<_param->_nb_front_end; i++)
	for (uint32_t j=0; j<_param->_nb_context [i]; j++)
	  {
	    if (in_CONTEXT_REQ_VAL [i][j]->read() and out_CONTEXT_REQ_ACK [i][j]->read())
	      {
		LABEL("CONTEXT_REQ [%d][%d] - Transaction Accepted.",i,j);
		
		uint32_t x=_param->_table_routing[i][j];
		
		TEST(Tcontrol_t,out_ICACHE_REQ_VAL[x]->read(), 1);
		TEST(Tcontrol_t, in_ICACHE_REQ_ACK[x]->read(), 1);
		
		TEST(Tcontext_t       ,out_ICACHE_REQ_THREAD_ID [x]->read(), _param->_translate_context_to_thread[i][j]);
		TEST(Tpacket_t        ,out_ICACHE_REQ_PACKET_ID [x]->read(), 0);
		TEST(Ticache_address_t,out_ICACHE_REQ_ADDRESS   [x]->read(), 0);
		TEST(Ticache_type_t   ,out_ICACHE_REQ_TYPE      [x]->read(), 0);
		
		nb_request --;
	      }

	    if (out_CONTEXT_RSP_VAL [i][j]->read() and  in_CONTEXT_RSP_ACK [i][j]->read())
	      {
		LABEL("CONTEXT_RSP [%d][%d] - Transaction Accepted.",i,j);

//   public    : SC_OUT(Tcontrol_t           )  *** out_CONTEXT_RSP_VAL        ;//[nb_front_end][nb_context]
// //public    : SC_OUT(Tcontext_t           )  *** out_CONTEXT_RSP_THREAD_ID  ;//[nb_front_end][nb_context]
//   public    : SC_OUT(Tpacket_t            )  *** out_CONTEXT_RSP_PACKET_ID  ;//[nb_front_end][nb_context]
//   public    : SC_OUT(Ticache_instruction_t) **** out_CONTEXT_RSP_INSTRUCTION;//[nb_front_end][nb_context][nb_instruction]
//   public    : SC_OUT(Ticache_error_t      )  *** out_CONTEXT_RSP_ERROR      ;//[nb_front_end][nb_context]

		nb_respons --;
	      }
	  }
      
      TEST(int32_t, nb_request, 0);
      TEST(int32_t, nb_respons, 0);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL(out_ICACHE_REQ_VAL         ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_REQ_ACK         ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_THREAD_ID   ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_PACKET_ID   ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_ADDRESS     ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_TYPE        ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_VAL         ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_RSP_ACK         ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_THREAD_ID   ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_PACKET_ID   ,_param->_nb_icache_port);
  DELETE2_SC_SIGNAL( in_ICACHE_RSP_INSTRUCTION ,_param->_nb_icache_port,_param->_icache_nb_instruction[it1]);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_ERROR       ,_param->_nb_icache_port);
  DELETE2_SC_SIGNAL( in_CONTEXT_REQ_VAL        ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_CONTEXT_REQ_ACK        ,_param->_nb_front_end,_param->_nb_context[it1]);
//DELETE2_SC_SIGNAL( in_CONTEXT_REQ_THREAD_ID  ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_CONTEXT_REQ_PACKET_ID  ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_CONTEXT_REQ_ADDRESS    ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_CONTEXT_REQ_TYPE       ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_CONTEXT_RSP_VAL        ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_CONTEXT_RSP_ACK        ,_param->_nb_front_end,_param->_nb_context[it1]);
//DELETE2_SC_SIGNAL(out_CONTEXT_RSP_THREAD_ID  ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_CONTEXT_RSP_PACKET_ID  ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE3_SC_SIGNAL(out_CONTEXT_RSP_INSTRUCTION,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_instruction[it1][it2]);
  DELETE2_SC_SIGNAL(out_CONTEXT_RSP_ERROR      ,_param->_nb_front_end,_param->_nb_context[it1]);

    }
#endif

  delete _Icache_Access;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
