/*
 * $Id: Parameters_msg_error.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {


#undef  FUNCTION
#define FUNCTION "Load_store_unit::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");
    
    Parameters_test test("Load_store_unit");

    switch (_speculative_load)
      {
      case SPECULATIVE_LOAD_COMMIT :
	{
	  if (not (_nb_bypass_memory == 0))
	    test.error(_("Bypass memory is not supported. Please wait a next revision.\n"));
 
	  break;
	}
      case NO_SPECULATIVE_LOAD     :
      case SPECULATIVE_LOAD_ACCESS :
      // case SPECULATIVE_LOAD_BYPASS :
      default                      :
	{
	  if (not (_nb_bypass_memory == 0))
	    test.error(toString(_("In the load scheme '%s', they have none bypass.\n"),toString(_speculative_load).c_str()));

	  test.error(toString(_("Speculative load scheme '%s' is not supported. Please wait a next revision.\n"),toString(_speculative_load).c_str()));
	  break;
	}
      }

    if (not (_size_store_queue >= 2))
      test.error(_("Store queue must have at less two slot.\n"));

    if (not (_nb_bypass_memory <= _size_load_queue))
      test.error(_("Bypass number must be less than load_queue's size.\n"));

    if (_nb_cache_port > 1)
      test.warning(_("nb_cache_port > 1 is unsupported (Coming Soon).\n")); 

    if (_nb_inst_memory > 1)
      test.warning(_("nb_inst_memory > 1 is unsupported (Coming Soon).\n")); 

    log_printf(FUNC,Load_store_unit,FUNCTION,"End");

    return test;

  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
